/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc.endpoints;

import jakarta.ws.rs.POST;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import java.util.List;
import org.jboss.resteasy.reactive.NoCache;
import org.keycloak.common.ClientConnection;
import org.keycloak.events.EventBuilder;
import org.keycloak.events.EventType;
import org.keycloak.http.HttpRequest;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.protocol.oidc.TokenIntrospectionProvider;
import org.keycloak.protocol.oidc.utils.AuthorizeClientUtil;
import org.keycloak.services.ErrorResponseException;
import org.keycloak.services.clientpolicy.ClientPolicyContext;
import org.keycloak.services.clientpolicy.ClientPolicyException;
import org.keycloak.services.clientpolicy.context.TokenIntrospectContext;

public class TokenIntrospectionEndpoint {
    public static final String PARAM_TOKEN_TYPE_HINT = "token_type_hint";
    public static final String PARAM_TOKEN = "token";
    private final KeycloakSession session;
    private final HttpRequest request;
    private final ClientConnection clientConnection;
    private final RealmModel realm;
    private final EventBuilder event;

    public TokenIntrospectionEndpoint(KeycloakSession session, EventBuilder event) {
        this.session = session;
        this.clientConnection = session.getContext().getConnection();
        this.realm = session.getContext().getRealm();
        this.event = event;
        this.request = session.getContext().getHttpRequest();
    }

    @POST
    @NoCache
    @Produces(value={"application/json", "application/jwt"})
    public Response introspect() {
        String token;
        this.event.event(EventType.INTROSPECT_TOKEN);
        this.checkSsl();
        this.checkRealm();
        this.authorizeClient();
        MultivaluedMap formParams = this.request.getDecodedFormParameters();
        this.checkParameterDuplicated((MultivaluedMap<String, String>)formParams);
        String tokenTypeHint = (String)formParams.getFirst((Object)PARAM_TOKEN_TYPE_HINT);
        if (tokenTypeHint == null) {
            tokenTypeHint = "access_token";
        }
        if ((token = (String)formParams.getFirst((Object)PARAM_TOKEN)) == null) {
            throw this.throwErrorResponseException("invalid_request", "Token not provided.", Response.Status.BAD_REQUEST);
        }
        TokenIntrospectionProvider provider = (TokenIntrospectionProvider)this.session.getProvider(TokenIntrospectionProvider.class, tokenTypeHint);
        if (provider == null) {
            throw this.throwErrorResponseException("invalid_request", "Unsupported token type [" + tokenTypeHint + "].", Response.Status.BAD_REQUEST);
        }
        try {
            this.session.clientPolicy().triggerOnEvent((ClientPolicyContext)new TokenIntrospectContext((MultivaluedMap<String, String>)formParams));
            token = (String)formParams.getFirst((Object)PARAM_TOKEN);
        }
        catch (ClientPolicyException cpe) {
            this.event.detail("reason", "client_policy_error");
            this.event.detail("client_policy_error", cpe.getError());
            this.event.detail("client_policy_error_detail", cpe.getErrorDetail());
            this.event.error(cpe.getError());
            throw this.throwErrorResponseException("invalid_request", cpe.getErrorDetail(), Response.Status.BAD_REQUEST);
        }
        try {
            return provider.introspect(token, this.event);
        }
        catch (ErrorResponseException ere) {
            throw ere;
        }
        catch (Exception e) {
            throw this.throwErrorResponseException("invalid_request", "Failed to introspect token.", Response.Status.BAD_REQUEST);
        }
    }

    private void authorizeClient() {
        try {
            ClientModel client = AuthorizeClientUtil.authorizeClient(this.session, this.event, null).getClient();
            this.event.client(client);
            if (client == null || client.isPublicClient()) {
                throw this.throwErrorResponseException("invalid_request", "Client not allowed.", Response.Status.FORBIDDEN);
            }
        }
        catch (ErrorResponseException ere) {
            throw ere;
        }
        catch (Exception e) {
            throw this.throwErrorResponseException("invalid_request", "Authentication failed.", Response.Status.UNAUTHORIZED);
        }
    }

    private void checkSsl() {
        if (!this.session.getContext().getUri().getBaseUri().getScheme().equals("https") && this.realm.getSslRequired().isRequired(this.clientConnection)) {
            throw new ErrorResponseException("invalid_request", "HTTPS required", Response.Status.FORBIDDEN);
        }
    }

    private void checkRealm() {
        if (!this.realm.isEnabled()) {
            throw new ErrorResponseException("access_denied", "Realm not enabled", Response.Status.FORBIDDEN);
        }
    }

    private void checkParameterDuplicated(MultivaluedMap<String, String> formParams) {
        for (String key : formParams.keySet()) {
            if (((List)formParams.get((Object)key)).size() == 1) continue;
            throw this.throwErrorResponseException("invalid_request", "duplicated parameter", Response.Status.BAD_REQUEST);
        }
    }

    private ErrorResponseException throwErrorResponseException(String error, String detail, Response.Status status) {
        this.event.detail("detail", detail).error(error);
        return new ErrorResponseException(error, detail, status);
    }
}

