/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.transaction;

import jakarta.ws.rs.container.AsyncResponse;
import jakarta.ws.rs.core.Response;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakTransaction;
import org.keycloak.services.ErrorPage;

public class AsyncResponseTransaction
implements KeycloakTransaction {
    private final KeycloakSession session;
    private final AsyncResponse responseToFinishInTransaction;
    private final Response responseToSend;

    public static void finishAsyncResponseInTransaction(KeycloakSession session, AsyncResponse responseToFinishInTransaction, Response responseToSend) {
        session.getTransactionManager().enlistAfterCompletion((KeycloakTransaction)new AsyncResponseTransaction(session, responseToFinishInTransaction, responseToSend));
    }

    private AsyncResponseTransaction(KeycloakSession session, AsyncResponse responseToFinishInTransaction, Response responseToSend) {
        this.session = session;
        this.responseToFinishInTransaction = responseToFinishInTransaction;
        this.responseToSend = responseToSend;
    }

    public void begin() {
    }

    public void commit() {
        this.responseToFinishInTransaction.resume((Object)this.responseToSend);
    }

    public void rollback() {
        this.responseToFinishInTransaction.resume((Object)ErrorPage.error(this.session, null, Response.Status.INTERNAL_SERVER_ERROR, "internalServerError", new Object[0]));
    }

    public void setRollbackOnly() {
    }

    public boolean getRollbackOnly() {
        return false;
    }

    public boolean isActive() {
        return false;
    }
}

