/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute;

import io.quarkus.qute.Evaluator;
import io.quarkus.qute.Expression;
import io.quarkus.qute.ExpressionImpl;
import io.quarkus.qute.ResolutionContext;
import io.quarkus.qute.SectionBlock;
import io.quarkus.qute.Template;
import io.quarkus.qute.TemplateInstance;
import java.util.Map;
import java.util.concurrent.CompletionStage;

class ResolutionContextImpl
implements ResolutionContext {
    private final Object data;
    private final Evaluator evaluator;
    private final Map<String, SectionBlock> extendingBlocks;
    private final TemplateInstance templateInstance;

    ResolutionContextImpl(Object data, Evaluator evaluator, Map<String, SectionBlock> extendingBlocks, TemplateInstance templateInstance) {
        this.data = data;
        this.evaluator = evaluator;
        this.extendingBlocks = extendingBlocks;
        this.templateInstance = templateInstance;
    }

    @Override
    public CompletionStage<Object> evaluate(String value) {
        return this.evaluate(ExpressionImpl.from(value));
    }

    @Override
    public CompletionStage<Object> evaluate(Expression expression) {
        return this.evaluator.evaluate(expression, this);
    }

    @Override
    public ResolutionContext createChild(Object data, Map<String, SectionBlock> extendingBlocks) {
        return new ChildResolutionContext(this, data, extendingBlocks);
    }

    @Override
    public Object getData() {
        return this.data;
    }

    @Override
    public ResolutionContextImpl getParent() {
        return null;
    }

    @Override
    public SectionBlock getExtendingBlock(String name) {
        if (this.extendingBlocks != null) {
            return this.extendingBlocks.get(name);
        }
        return null;
    }

    @Override
    public SectionBlock getCurrentExtendingBlock(String name) {
        return this.getExtendingBlock(name);
    }

    @Override
    public Object getAttribute(String key) {
        return this.templateInstance.getAttribute(key);
    }

    @Override
    public Template getTemplate() {
        return this.templateInstance.getTemplate();
    }

    @Override
    public Evaluator getEvaluator() {
        return this.evaluator;
    }

    TemplateInstance getTemplateInstance() {
        return this.templateInstance;
    }

    static class ChildResolutionContext
    implements ResolutionContext {
        private final ResolutionContext parent;
        private final Object data;
        private final Map<String, SectionBlock> extendingBlocks;
        private final Evaluator evaluator;

        public ChildResolutionContext(ResolutionContext parent, Object data, Map<String, SectionBlock> extendingBlocks) {
            this.parent = parent;
            this.data = data;
            this.extendingBlocks = extendingBlocks;
            this.evaluator = parent.getEvaluator();
        }

        @Override
        public CompletionStage<Object> evaluate(String expression) {
            return this.evaluate(ExpressionImpl.from(expression));
        }

        @Override
        public CompletionStage<Object> evaluate(Expression expression) {
            return this.evaluator.evaluate(expression, this);
        }

        @Override
        public ResolutionContext createChild(Object data, Map<String, SectionBlock> extendingBlocks) {
            return new ChildResolutionContext(this, data, extendingBlocks);
        }

        @Override
        public Object getData() {
            return this.data;
        }

        @Override
        public ResolutionContext getParent() {
            return this.parent;
        }

        @Override
        public SectionBlock getExtendingBlock(String name) {
            SectionBlock block;
            if (this.extendingBlocks != null && (block = this.extendingBlocks.get(name)) != null) {
                return block;
            }
            if (this.parent != null) {
                return this.parent.getExtendingBlock(name);
            }
            return null;
        }

        @Override
        public SectionBlock getCurrentExtendingBlock(String name) {
            if (this.extendingBlocks != null) {
                return this.extendingBlocks.get(name);
            }
            return null;
        }

        @Override
        public Object getAttribute(String key) {
            return this.parent.getAttribute(key);
        }

        @Override
        public Template getTemplate() {
            return this.parent.getTemplate();
        }

        @Override
        public Evaluator getEvaluator() {
            return this.evaluator;
        }

        TemplateInstance getTemplateInstance() {
            ResolutionContext resolutionContext = this.parent;
            if (resolutionContext instanceof ResolutionContextImpl) {
                ResolutionContextImpl rc = (ResolutionContextImpl)resolutionContext;
                return rc.getTemplateInstance();
            }
            resolutionContext = this.parent;
            if (resolutionContext instanceof ChildResolutionContext) {
                ChildResolutionContext child = (ChildResolutionContext)resolutionContext;
                return child.getTemplateInstance();
            }
            throw new IllegalStateException();
        }
    }
}

