/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.password.impl;

import java.nio.charset.Charset;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.InvalidParameterSpecException;
import java.security.spec.KeySpec;
import javax.security.sasl.SaslException;
import org.wildfly.security.password.Password;
import org.wildfly.security.password.PasswordFactorySpi;
import org.wildfly.security.password.impl.AbstractPasswordImpl;
import org.wildfly.security.password.impl.BCryptPasswordImpl;
import org.wildfly.security.password.impl.BSDUnixDESCryptPasswordImpl;
import org.wildfly.security.password.impl.ClearPasswordImpl;
import org.wildfly.security.password.impl.DigestPasswordImpl;
import org.wildfly.security.password.impl.ElytronMessages;
import org.wildfly.security.password.impl.MaskedPasswordImpl;
import org.wildfly.security.password.impl.OneTimePasswordImpl;
import org.wildfly.security.password.impl.SaltedSimpleDigestPasswordImpl;
import org.wildfly.security.password.impl.ScramDigestPasswordImpl;
import org.wildfly.security.password.impl.SimpleDigestPasswordImpl;
import org.wildfly.security.password.impl.SunUnixMD5CryptPasswordImpl;
import org.wildfly.security.password.impl.UnixDESCryptPasswordImpl;
import org.wildfly.security.password.impl.UnixMD5CryptPasswordImpl;
import org.wildfly.security.password.impl.UnixSHACryptPasswordImpl;
import org.wildfly.security.password.interfaces.BCryptPassword;
import org.wildfly.security.password.interfaces.BSDUnixDESCryptPassword;
import org.wildfly.security.password.interfaces.ClearPassword;
import org.wildfly.security.password.interfaces.DigestPassword;
import org.wildfly.security.password.interfaces.MaskedPassword;
import org.wildfly.security.password.interfaces.OneTimePassword;
import org.wildfly.security.password.interfaces.SaltedSimpleDigestPassword;
import org.wildfly.security.password.interfaces.ScramDigestPassword;
import org.wildfly.security.password.interfaces.SimpleDigestPassword;
import org.wildfly.security.password.interfaces.SunUnixMD5CryptPassword;
import org.wildfly.security.password.interfaces.UnixDESCryptPassword;
import org.wildfly.security.password.interfaces.UnixMD5CryptPassword;
import org.wildfly.security.password.interfaces.UnixSHACryptPassword;
import org.wildfly.security.password.spec.ClearPasswordSpec;
import org.wildfly.security.password.spec.DigestPasswordSpec;
import org.wildfly.security.password.spec.EncryptablePasswordSpec;
import org.wildfly.security.password.spec.HashPasswordSpec;
import org.wildfly.security.password.spec.IteratedPasswordAlgorithmSpec;
import org.wildfly.security.password.spec.IteratedSaltedHashPasswordSpec;
import org.wildfly.security.password.spec.IteratedSaltedPasswordAlgorithmSpec;
import org.wildfly.security.password.spec.MaskedPasswordAlgorithmSpec;
import org.wildfly.security.password.spec.MaskedPasswordSpec;
import org.wildfly.security.password.spec.OneTimePasswordAlgorithmSpec;
import org.wildfly.security.password.spec.OneTimePasswordSpec;
import org.wildfly.security.password.spec.SaltedHashPasswordSpec;
import org.wildfly.security.password.spec.SaltedPasswordAlgorithmSpec;

public final class PasswordFactorySpiImpl
extends PasswordFactorySpi {
    protected Password engineGeneratePassword(String algorithm, KeySpec keySpec) throws InvalidKeySpecException {
        switch (algorithm) {
            case "clear": {
                if (keySpec instanceof ClearPasswordSpec) {
                    return new ClearPasswordImpl((char[])((ClearPasswordSpec)keySpec).getEncodedPassword().clone());
                }
                if (!(keySpec instanceof EncryptablePasswordSpec)) break;
                return new ClearPasswordImpl((char[])((EncryptablePasswordSpec)keySpec).getPassword().clone());
            }
            case "bcrypt": {
                if (keySpec instanceof IteratedSaltedHashPasswordSpec) {
                    try {
                        return new BCryptPasswordImpl((IteratedSaltedHashPasswordSpec)keySpec);
                    }
                    catch (IllegalArgumentException | NullPointerException e) {
                        throw new InvalidKeySpecException(e);
                    }
                }
                if (keySpec instanceof SaltedHashPasswordSpec) {
                    try {
                        return new BCryptPasswordImpl((SaltedHashPasswordSpec)keySpec);
                    }
                    catch (IllegalArgumentException | NullPointerException e) {
                        throw new InvalidKeySpecException(e);
                    }
                }
                if (keySpec instanceof ClearPasswordSpec) {
                    try {
                        return new BCryptPasswordImpl((ClearPasswordSpec)keySpec);
                    }
                    catch (IllegalArgumentException | NullPointerException e) {
                        throw new InvalidKeySpecException(e);
                    }
                }
                if (!(keySpec instanceof EncryptablePasswordSpec)) break;
                try {
                    EncryptablePasswordSpec encryptableSpec = (EncryptablePasswordSpec)keySpec;
                    AlgorithmParameterSpec parameterSpec = encryptableSpec.getAlgorithmParameterSpec();
                    if (parameterSpec == null) {
                        return new BCryptPasswordImpl(encryptableSpec.getPassword(), encryptableSpec.getHashCharset());
                    }
                    if (parameterSpec instanceof SaltedPasswordAlgorithmSpec) {
                        return new BCryptPasswordImpl(encryptableSpec.getPassword(), (SaltedPasswordAlgorithmSpec)parameterSpec, encryptableSpec.getHashCharset());
                    }
                    if (parameterSpec instanceof IteratedSaltedPasswordAlgorithmSpec) {
                        return new BCryptPasswordImpl(encryptableSpec.getPassword(), (IteratedSaltedPasswordAlgorithmSpec)parameterSpec, encryptableSpec.getHashCharset());
                    }
                    if (parameterSpec instanceof IteratedPasswordAlgorithmSpec) {
                        return new BCryptPasswordImpl(encryptableSpec.getPassword(), (IteratedPasswordAlgorithmSpec)parameterSpec, encryptableSpec.getHashCharset());
                    }
                    break;
                }
                catch (IllegalArgumentException | NullPointerException e) {
                    throw new InvalidKeySpecException(e);
                }
            }
            case "crypt-md5": {
                if (keySpec instanceof SaltedHashPasswordSpec) {
                    try {
                        return new UnixMD5CryptPasswordImpl((SaltedHashPasswordSpec)keySpec);
                    }
                    catch (IllegalArgumentException | NullPointerException e) {
                        throw new InvalidKeySpecException(e);
                    }
                }
                if (keySpec instanceof ClearPasswordSpec) {
                    try {
                        return new UnixMD5CryptPasswordImpl((ClearPasswordSpec)keySpec);
                    }
                    catch (IllegalArgumentException | NullPointerException | NoSuchAlgorithmException e) {
                        throw new InvalidKeySpecException(e);
                    }
                }
                if (!(keySpec instanceof EncryptablePasswordSpec)) break;
                try {
                    EncryptablePasswordSpec encryptableSpec = (EncryptablePasswordSpec)keySpec;
                    AlgorithmParameterSpec parameterSpec = encryptableSpec.getAlgorithmParameterSpec();
                    if (parameterSpec == null) {
                        return new UnixMD5CryptPasswordImpl(encryptableSpec.getPassword(), encryptableSpec.getHashCharset());
                    }
                    if (parameterSpec instanceof SaltedPasswordAlgorithmSpec) {
                        return new UnixMD5CryptPasswordImpl(encryptableSpec.getPassword(), (SaltedPasswordAlgorithmSpec)parameterSpec, encryptableSpec.getHashCharset());
                    }
                    break;
                }
                catch (IllegalArgumentException | NoSuchAlgorithmException e) {
                    throw new InvalidKeySpecException(e);
                }
            }
            case "sun-crypt-md5": 
            case "sun-crypt-md5-bare-salt": {
                if (keySpec instanceof IteratedSaltedHashPasswordSpec) {
                    try {
                        return new SunUnixMD5CryptPasswordImpl(algorithm, (IteratedSaltedHashPasswordSpec)keySpec);
                    }
                    catch (IllegalArgumentException | NullPointerException e) {
                        throw new InvalidKeySpecException(e);
                    }
                }
                if (keySpec instanceof SaltedHashPasswordSpec) {
                    try {
                        return new SunUnixMD5CryptPasswordImpl(algorithm, (SaltedHashPasswordSpec)keySpec);
                    }
                    catch (IllegalArgumentException | NullPointerException e) {
                        throw new InvalidKeySpecException(e);
                    }
                }
                if (keySpec instanceof ClearPasswordSpec) {
                    try {
                        return new SunUnixMD5CryptPasswordImpl((ClearPasswordSpec)keySpec);
                    }
                    catch (IllegalArgumentException | NullPointerException | NoSuchAlgorithmException e) {
                        throw new InvalidKeySpecException(e);
                    }
                }
                if (!(keySpec instanceof EncryptablePasswordSpec)) break;
                try {
                    EncryptablePasswordSpec encryptableSpec = (EncryptablePasswordSpec)keySpec;
                    AlgorithmParameterSpec parameterSpec = encryptableSpec.getAlgorithmParameterSpec();
                    if (parameterSpec == null) {
                        return new SunUnixMD5CryptPasswordImpl(algorithm, encryptableSpec.getPassword(), encryptableSpec.getHashCharset());
                    }
                    if (parameterSpec instanceof SaltedPasswordAlgorithmSpec) {
                        return new SunUnixMD5CryptPasswordImpl(algorithm, encryptableSpec.getPassword(), (SaltedPasswordAlgorithmSpec)parameterSpec, encryptableSpec.getHashCharset());
                    }
                    if (parameterSpec instanceof IteratedSaltedPasswordAlgorithmSpec) {
                        return new SunUnixMD5CryptPasswordImpl(algorithm, encryptableSpec.getPassword(), (IteratedSaltedPasswordAlgorithmSpec)parameterSpec, encryptableSpec.getHashCharset());
                    }
                    if (parameterSpec instanceof IteratedPasswordAlgorithmSpec) {
                        return new SunUnixMD5CryptPasswordImpl(algorithm, encryptableSpec.getPassword(), (IteratedPasswordAlgorithmSpec)parameterSpec, encryptableSpec.getHashCharset());
                    }
                    break;
                }
                catch (IllegalArgumentException | NullPointerException | NoSuchAlgorithmException e) {
                    throw new InvalidKeySpecException(e);
                }
            }
            case "crypt-sha-256": 
            case "crypt-sha-512": {
                if (keySpec instanceof IteratedSaltedHashPasswordSpec) {
                    try {
                        return new UnixSHACryptPasswordImpl(algorithm, (IteratedSaltedHashPasswordSpec)keySpec);
                    }
                    catch (IllegalArgumentException | NullPointerException e) {
                        throw new InvalidKeySpecException(e);
                    }
                }
                if (keySpec instanceof SaltedHashPasswordSpec) {
                    try {
                        return new UnixSHACryptPasswordImpl(algorithm, (SaltedHashPasswordSpec)keySpec);
                    }
                    catch (IllegalArgumentException | NullPointerException e) {
                        throw new InvalidKeySpecException(e);
                    }
                }
                if (keySpec instanceof ClearPasswordSpec) {
                    try {
                        return new UnixSHACryptPasswordImpl(algorithm, (ClearPasswordSpec)keySpec);
                    }
                    catch (IllegalArgumentException | NullPointerException | NoSuchAlgorithmException e) {
                        throw new InvalidKeySpecException(e);
                    }
                }
                if (!(keySpec instanceof EncryptablePasswordSpec)) break;
                try {
                    EncryptablePasswordSpec encryptableSpec = (EncryptablePasswordSpec)keySpec;
                    AlgorithmParameterSpec parameterSpec = encryptableSpec.getAlgorithmParameterSpec();
                    if (parameterSpec == null) {
                        return new UnixSHACryptPasswordImpl(algorithm, encryptableSpec.getPassword(), encryptableSpec.getHashCharset());
                    }
                    if (parameterSpec instanceof IteratedPasswordAlgorithmSpec) {
                        return new UnixSHACryptPasswordImpl(algorithm, (IteratedPasswordAlgorithmSpec)parameterSpec, encryptableSpec.getPassword(), encryptableSpec.getHashCharset());
                    }
                    if (parameterSpec instanceof IteratedSaltedPasswordAlgorithmSpec) {
                        return new UnixSHACryptPasswordImpl(algorithm, (IteratedSaltedPasswordAlgorithmSpec)parameterSpec, encryptableSpec.getPassword(), encryptableSpec.getHashCharset());
                    }
                    if (parameterSpec instanceof SaltedPasswordAlgorithmSpec) {
                        return new UnixSHACryptPasswordImpl(algorithm, (SaltedPasswordAlgorithmSpec)parameterSpec, encryptableSpec.getPassword(), encryptableSpec.getHashCharset());
                    }
                    break;
                }
                catch (IllegalArgumentException | NullPointerException | NoSuchAlgorithmException e) {
                    throw new InvalidKeySpecException(e);
                }
            }
            case "digest-md5": 
            case "digest-sha": 
            case "digest-sha-256": 
            case "digest-sha-384": 
            case "digest-sha-512": 
            case "digest-sha-512-256": {
                if (keySpec instanceof DigestPasswordSpec) {
                    return new DigestPasswordImpl(algorithm, (DigestPasswordSpec)keySpec);
                }
                if (!(keySpec instanceof EncryptablePasswordSpec)) break;
                return new DigestPasswordImpl(algorithm, (EncryptablePasswordSpec)keySpec);
            }
            case "simple-digest-md2": 
            case "simple-digest-md5": 
            case "simple-digest-sha-1": 
            case "simple-digest-sha-256": 
            case "simple-digest-sha-384": 
            case "simple-digest-sha-512": {
                if (keySpec instanceof HashPasswordSpec) {
                    try {
                        return new SimpleDigestPasswordImpl(algorithm, (HashPasswordSpec)keySpec);
                    }
                    catch (IllegalArgumentException | NullPointerException e) {
                        throw new InvalidKeySpecException(e);
                    }
                }
                if (keySpec instanceof ClearPasswordSpec) {
                    try {
                        return new SimpleDigestPasswordImpl(algorithm, (ClearPasswordSpec)keySpec);
                    }
                    catch (IllegalArgumentException | NullPointerException e) {
                        throw new InvalidKeySpecException(e);
                    }
                }
                if (!(keySpec instanceof EncryptablePasswordSpec)) break;
                try {
                    EncryptablePasswordSpec encryptableSpec = (EncryptablePasswordSpec)keySpec;
                    AlgorithmParameterSpec parameterSpec = encryptableSpec.getAlgorithmParameterSpec();
                    if (parameterSpec == null) {
                        return new SimpleDigestPasswordImpl(algorithm, encryptableSpec.getPassword(), encryptableSpec.getHashCharset());
                    }
                    break;
                }
                catch (IllegalArgumentException | NullPointerException e) {
                    throw new InvalidKeySpecException(e);
                }
            }
            case "password-salt-digest-md5": 
            case "password-salt-digest-sha-1": 
            case "password-salt-digest-sha-256": 
            case "password-salt-digest-sha-384": 
            case "password-salt-digest-sha-512": 
            case "salt-password-digest-md5": 
            case "salt-password-digest-sha-1": 
            case "salt-password-digest-sha-256": 
            case "salt-password-digest-sha-384": 
            case "salt-password-digest-sha-512": {
                if (keySpec instanceof SaltedHashPasswordSpec) {
                    try {
                        return new SaltedSimpleDigestPasswordImpl(algorithm, (SaltedHashPasswordSpec)keySpec);
                    }
                    catch (IllegalArgumentException | NullPointerException e) {
                        throw new InvalidKeySpecException(e);
                    }
                }
                if (keySpec instanceof ClearPasswordSpec) {
                    try {
                        return new SaltedSimpleDigestPasswordImpl(algorithm, (ClearPasswordSpec)keySpec);
                    }
                    catch (IllegalArgumentException | NullPointerException e) {
                        throw new InvalidKeySpecException(e);
                    }
                }
                if (!(keySpec instanceof EncryptablePasswordSpec)) break;
                try {
                    EncryptablePasswordSpec encryptableSpec = (EncryptablePasswordSpec)keySpec;
                    AlgorithmParameterSpec parameterSpec = encryptableSpec.getAlgorithmParameterSpec();
                    if (parameterSpec == null) {
                        return new SaltedSimpleDigestPasswordImpl(algorithm, encryptableSpec.getPassword(), encryptableSpec.getHashCharset());
                    }
                    if (parameterSpec instanceof SaltedPasswordAlgorithmSpec) {
                        return new SaltedSimpleDigestPasswordImpl(algorithm, encryptableSpec.getPassword(), (SaltedPasswordAlgorithmSpec)parameterSpec, encryptableSpec.getHashCharset());
                    }
                    break;
                }
                catch (IllegalArgumentException | NullPointerException e) {
                    throw new InvalidKeySpecException(e);
                }
            }
            case "crypt-des": {
                if (keySpec instanceof SaltedHashPasswordSpec) {
                    try {
                        return new UnixDESCryptPasswordImpl((SaltedHashPasswordSpec)keySpec);
                    }
                    catch (IllegalArgumentException | InvalidKeyException | InvalidParameterSpecException e) {
                        throw new InvalidKeySpecException(e);
                    }
                }
                if (keySpec instanceof ClearPasswordSpec) {
                    try {
                        return new UnixDESCryptPasswordImpl((ClearPasswordSpec)keySpec);
                    }
                    catch (IllegalArgumentException | InvalidKeyException e) {
                        throw new InvalidKeySpecException(e);
                    }
                }
                if (!(keySpec instanceof EncryptablePasswordSpec)) break;
                try {
                    EncryptablePasswordSpec encryptableSpec = (EncryptablePasswordSpec)keySpec;
                    AlgorithmParameterSpec parameterSpec = encryptableSpec.getAlgorithmParameterSpec();
                    if (parameterSpec == null) {
                        return new UnixDESCryptPasswordImpl(encryptableSpec.getPassword(), encryptableSpec.getHashCharset());
                    }
                    if (parameterSpec instanceof SaltedPasswordAlgorithmSpec) {
                        return new UnixDESCryptPasswordImpl(encryptableSpec.getPassword(), (SaltedPasswordAlgorithmSpec)parameterSpec, encryptableSpec.getHashCharset());
                    }
                    break;
                }
                catch (IllegalArgumentException | InvalidKeyException | InvalidParameterSpecException e) {
                    throw new InvalidKeySpecException(e);
                }
            }
            case "bsd-crypt-des": {
                if (keySpec instanceof IteratedSaltedHashPasswordSpec) {
                    try {
                        return new BSDUnixDESCryptPasswordImpl((IteratedSaltedHashPasswordSpec)keySpec);
                    }
                    catch (IllegalArgumentException | InvalidParameterSpecException e) {
                        throw new InvalidKeySpecException(e);
                    }
                }
                if (keySpec instanceof SaltedHashPasswordSpec) {
                    try {
                        return new BSDUnixDESCryptPasswordImpl((SaltedHashPasswordSpec)keySpec);
                    }
                    catch (IllegalArgumentException | InvalidParameterSpecException e) {
                        throw new InvalidKeySpecException(e);
                    }
                }
                if (keySpec instanceof ClearPasswordSpec) {
                    try {
                        return new BSDUnixDESCryptPasswordImpl((ClearPasswordSpec)keySpec);
                    }
                    catch (IllegalArgumentException e) {
                        throw new InvalidKeySpecException(e);
                    }
                }
                if (!(keySpec instanceof EncryptablePasswordSpec)) break;
                try {
                    EncryptablePasswordSpec encryptableSpec = (EncryptablePasswordSpec)keySpec;
                    AlgorithmParameterSpec parameterSpec = encryptableSpec.getAlgorithmParameterSpec();
                    if (parameterSpec == null) {
                        return new BSDUnixDESCryptPasswordImpl(encryptableSpec.getPassword(), encryptableSpec.getHashCharset());
                    }
                    if (parameterSpec instanceof SaltedPasswordAlgorithmSpec) {
                        return new BSDUnixDESCryptPasswordImpl(encryptableSpec.getPassword(), (SaltedPasswordAlgorithmSpec)parameterSpec, encryptableSpec.getHashCharset());
                    }
                    if (parameterSpec instanceof IteratedSaltedPasswordAlgorithmSpec) {
                        return new BSDUnixDESCryptPasswordImpl(encryptableSpec.getPassword(), (IteratedSaltedPasswordAlgorithmSpec)parameterSpec, encryptableSpec.getHashCharset());
                    }
                    if (parameterSpec instanceof IteratedPasswordAlgorithmSpec) {
                        return new BSDUnixDESCryptPasswordImpl(encryptableSpec.getPassword(), (IteratedPasswordAlgorithmSpec)parameterSpec, encryptableSpec.getHashCharset());
                    }
                    break;
                }
                catch (IllegalArgumentException | NullPointerException | InvalidParameterSpecException e) {
                    throw new InvalidKeySpecException(e);
                }
            }
            case "scram-sha-1": 
            case "scram-sha-256": 
            case "scram-sha-384": 
            case "scram-sha-512": {
                if (keySpec instanceof IteratedSaltedHashPasswordSpec) {
                    try {
                        return new ScramDigestPasswordImpl(algorithm, (IteratedSaltedHashPasswordSpec)keySpec);
                    }
                    catch (IllegalArgumentException | NullPointerException e) {
                        throw new InvalidKeySpecException(e);
                    }
                }
                if (keySpec instanceof SaltedHashPasswordSpec) {
                    try {
                        return new ScramDigestPasswordImpl(algorithm, (SaltedHashPasswordSpec)keySpec);
                    }
                    catch (IllegalArgumentException | NullPointerException e) {
                        throw new InvalidKeySpecException(e);
                    }
                }
                if (keySpec instanceof ClearPasswordSpec) {
                    try {
                        return new ScramDigestPasswordImpl(algorithm, (ClearPasswordSpec)keySpec);
                    }
                    catch (IllegalArgumentException | NullPointerException | InvalidKeyException | NoSuchAlgorithmException e) {
                        throw new InvalidKeySpecException(e);
                    }
                }
                if (!(keySpec instanceof EncryptablePasswordSpec)) break;
                try {
                    EncryptablePasswordSpec encryptableSpec = (EncryptablePasswordSpec)keySpec;
                    AlgorithmParameterSpec parameterSpec = encryptableSpec.getAlgorithmParameterSpec();
                    if (parameterSpec == null) {
                        return new ScramDigestPasswordImpl(algorithm, encryptableSpec.getPassword(), encryptableSpec.getHashCharset());
                    }
                    if (parameterSpec instanceof SaltedPasswordAlgorithmSpec) {
                        return new ScramDigestPasswordImpl(algorithm, encryptableSpec.getPassword(), (SaltedPasswordAlgorithmSpec)parameterSpec, encryptableSpec.getHashCharset());
                    }
                    if (parameterSpec instanceof IteratedSaltedPasswordAlgorithmSpec) {
                        return new ScramDigestPasswordImpl(algorithm, encryptableSpec.getPassword(), (IteratedSaltedPasswordAlgorithmSpec)parameterSpec, encryptableSpec.getHashCharset());
                    }
                    if (parameterSpec instanceof IteratedPasswordAlgorithmSpec) {
                        return new ScramDigestPasswordImpl(algorithm, encryptableSpec.getPassword(), (IteratedPasswordAlgorithmSpec)parameterSpec, encryptableSpec.getHashCharset());
                    }
                    break;
                }
                catch (IllegalArgumentException | NullPointerException | InvalidKeyException | NoSuchAlgorithmException e) {
                    throw new InvalidKeySpecException(e);
                }
            }
            case "otp-md5": 
            case "otp-sha1": 
            case "otp-sha256": 
            case "otp-sha384": 
            case "otp-sha512": {
                if (keySpec instanceof OneTimePasswordSpec) {
                    return new OneTimePasswordImpl(algorithm, (OneTimePasswordSpec)keySpec);
                }
                if (!(keySpec instanceof EncryptablePasswordSpec)) break;
                EncryptablePasswordSpec encryptableSpec = (EncryptablePasswordSpec)keySpec;
                AlgorithmParameterSpec parameterSpec = encryptableSpec.getAlgorithmParameterSpec();
                try {
                    if (parameterSpec instanceof OneTimePasswordAlgorithmSpec) {
                        return new OneTimePasswordImpl(algorithm, encryptableSpec.getPassword(), (OneTimePasswordAlgorithmSpec)parameterSpec);
                    }
                    break;
                }
                catch (SaslException e) {
                    throw new InvalidKeySpecException(e);
                }
            }
            default: {
                if (!MaskedPassword.isMaskedAlgorithm((String)algorithm)) break;
                if (keySpec instanceof MaskedPasswordSpec) {
                    return new MaskedPasswordImpl(algorithm, (MaskedPasswordSpec)keySpec);
                }
                if (keySpec instanceof EncryptablePasswordSpec) {
                    EncryptablePasswordSpec encryptableSpec = (EncryptablePasswordSpec)keySpec;
                    AlgorithmParameterSpec parameterSpec = encryptableSpec.getAlgorithmParameterSpec();
                    if (parameterSpec == null) {
                        return new MaskedPasswordImpl(algorithm, encryptableSpec.getPassword());
                    }
                    if (parameterSpec instanceof MaskedPasswordAlgorithmSpec) {
                        return new MaskedPasswordImpl(algorithm, encryptableSpec.getPassword(), (MaskedPasswordAlgorithmSpec)parameterSpec);
                    }
                    if (parameterSpec instanceof IteratedSaltedPasswordAlgorithmSpec) {
                        return new MaskedPasswordImpl(algorithm, encryptableSpec.getPassword(), (IteratedSaltedPasswordAlgorithmSpec)parameterSpec);
                    }
                    if (parameterSpec instanceof SaltedPasswordAlgorithmSpec) {
                        return new MaskedPasswordImpl(algorithm, encryptableSpec.getPassword(), (SaltedPasswordAlgorithmSpec)parameterSpec);
                    }
                    if (!(parameterSpec instanceof IteratedPasswordAlgorithmSpec)) break;
                    return new MaskedPasswordImpl(algorithm, encryptableSpec.getPassword(), (IteratedPasswordAlgorithmSpec)parameterSpec);
                }
                if (!(keySpec instanceof ClearPasswordSpec)) break;
                return new MaskedPasswordImpl(algorithm, (ClearPasswordSpec)keySpec);
            }
        }
        throw ElytronMessages.log.invalidKeySpecUnknownAlgorithmOrIncompatiblePasswordSpec(algorithm, keySpec == null ? null : keySpec.getClass().getSimpleName());
    }

    protected <S extends KeySpec> S engineGetKeySpec(String algorithm, Password password, Class<S> keySpecType) throws InvalidKeySpecException {
        AbstractPasswordImpl abstractPassword;
        if (password instanceof AbstractPasswordImpl && algorithm.equals((abstractPassword = (AbstractPasswordImpl)password).getAlgorithm())) {
            return abstractPassword.getKeySpec(keySpecType);
        }
        throw new InvalidKeySpecException();
    }

    protected boolean engineIsTranslatablePassword(String algorithm, Password password) {
        AbstractPasswordImpl abstractPassword;
        if (password instanceof AbstractPasswordImpl && algorithm.equals((abstractPassword = (AbstractPasswordImpl)password).getAlgorithm())) {
            return true;
        }
        switch (algorithm) {
            case "clear": {
                return password instanceof ClearPassword;
            }
            case "bcrypt": {
                return password instanceof BCryptPassword;
            }
            case "crypt-md5": {
                return password instanceof UnixMD5CryptPassword;
            }
            case "sun-crypt-md5": 
            case "sun-crypt-md5-bare-salt": {
                return password instanceof SunUnixMD5CryptPassword && algorithm.equals(password.getAlgorithm());
            }
            case "crypt-sha-256": 
            case "crypt-sha-512": {
                return password instanceof UnixSHACryptPassword && algorithm.equals(password.getAlgorithm());
            }
            case "digest-md5": 
            case "digest-sha": 
            case "digest-sha-256": 
            case "digest-sha-384": 
            case "digest-sha-512": {
                return password instanceof DigestPassword && algorithm.equals(password.getAlgorithm());
            }
            case "simple-digest-md2": 
            case "simple-digest-md5": 
            case "simple-digest-sha-1": 
            case "simple-digest-sha-256": 
            case "simple-digest-sha-384": 
            case "simple-digest-sha-512": {
                return password instanceof SimpleDigestPassword && algorithm.equals(password.getAlgorithm());
            }
            case "password-salt-digest-md5": 
            case "password-salt-digest-sha-1": 
            case "password-salt-digest-sha-256": 
            case "password-salt-digest-sha-384": 
            case "password-salt-digest-sha-512": 
            case "salt-password-digest-md5": 
            case "salt-password-digest-sha-1": 
            case "salt-password-digest-sha-256": 
            case "salt-password-digest-sha-384": 
            case "salt-password-digest-sha-512": {
                return password instanceof SaltedSimpleDigestPassword && algorithm.equals(password.getAlgorithm());
            }
            case "crypt-des": {
                return password instanceof UnixDESCryptPassword;
            }
            case "bsd-crypt-des": {
                return password instanceof BSDUnixDESCryptPassword;
            }
            case "scram-sha-1": 
            case "scram-sha-256": 
            case "scram-sha-384": 
            case "scram-sha-512": {
                return password instanceof ScramDigestPassword && algorithm.equals(password.getAlgorithm());
            }
            case "otp-md5": 
            case "otp-sha1": 
            case "otp-sha256": 
            case "otp-sha384": 
            case "otp-sha512": {
                return password instanceof OneTimePassword && algorithm.equals(password.getAlgorithm());
            }
        }
        return MaskedPassword.isMaskedAlgorithm((String)algorithm) && password instanceof MaskedPassword && algorithm.equals(password.getAlgorithm());
    }

    protected Password engineTranslatePassword(String algorithm, Password password) throws InvalidKeyException {
        AbstractPasswordImpl abstractPassword;
        if (password instanceof AbstractPasswordImpl && algorithm.equals((abstractPassword = (AbstractPasswordImpl)password).getAlgorithm())) {
            return abstractPassword;
        }
        switch (algorithm) {
            case "clear": {
                if (password instanceof ClearPasswordImpl) {
                    return password;
                }
                if (!(password instanceof ClearPassword)) break;
                return new ClearPasswordImpl((ClearPassword)password);
            }
            case "bcrypt": {
                if (password instanceof BCryptPasswordImpl) {
                    return password;
                }
                if (!(password instanceof BCryptPassword)) break;
                return new BCryptPasswordImpl((BCryptPassword)password);
            }
            case "crypt-md5": {
                if (password instanceof UnixMD5CryptPasswordImpl) {
                    return password;
                }
                if (!(password instanceof UnixMD5CryptPassword)) break;
                return new UnixMD5CryptPasswordImpl((UnixMD5CryptPassword)password);
            }
            case "sun-crypt-md5": 
            case "sun-crypt-md5-bare-salt": {
                if (password instanceof SunUnixMD5CryptPasswordImpl && algorithm.equals(password.getAlgorithm())) {
                    return password;
                }
                if (!(password instanceof SunUnixMD5CryptPassword) || !algorithm.equals(password.getAlgorithm())) break;
                return new SunUnixMD5CryptPasswordImpl((SunUnixMD5CryptPassword)password);
            }
            case "crypt-sha-256": 
            case "crypt-sha-512": {
                if (password instanceof UnixSHACryptPasswordImpl && algorithm.equals(password.getAlgorithm())) {
                    return password;
                }
                if (!(password instanceof UnixSHACryptPassword) || !algorithm.equals(password.getAlgorithm())) break;
                return new UnixSHACryptPasswordImpl((UnixSHACryptPassword)password);
            }
            case "digest-md5": 
            case "digest-sha": 
            case "digest-sha-256": 
            case "digest-sha-384": 
            case "digest-sha-512": 
            case "digest-sha-512-256": {
                if (password instanceof DigestPasswordImpl && algorithm.equals(password.getAlgorithm())) {
                    return password;
                }
                if (!(password instanceof DigestPassword) || !algorithm.equals(password.getAlgorithm())) break;
                return new SimpleDigestPasswordImpl((SimpleDigestPassword)password);
            }
            case "simple-digest-md2": 
            case "simple-digest-md5": 
            case "simple-digest-sha-1": 
            case "simple-digest-sha-256": 
            case "simple-digest-sha-384": 
            case "simple-digest-sha-512": {
                if (password instanceof SimpleDigestPasswordImpl && algorithm.equals(password.getAlgorithm())) {
                    return password;
                }
                if (!(password instanceof SimpleDigestPassword) || !algorithm.equals(password.getAlgorithm())) break;
                return new SimpleDigestPasswordImpl((SimpleDigestPassword)password);
            }
            case "password-salt-digest-md5": 
            case "password-salt-digest-sha-1": 
            case "password-salt-digest-sha-256": 
            case "password-salt-digest-sha-384": 
            case "password-salt-digest-sha-512": 
            case "salt-password-digest-md5": 
            case "salt-password-digest-sha-1": 
            case "salt-password-digest-sha-256": 
            case "salt-password-digest-sha-384": 
            case "salt-password-digest-sha-512": {
                if (password instanceof SaltedSimpleDigestPasswordImpl && algorithm.equals(password.getAlgorithm())) {
                    return password;
                }
                if (!(password instanceof SaltedSimpleDigestPassword) || !algorithm.equals(password.getAlgorithm())) break;
                return new SaltedSimpleDigestPasswordImpl((SaltedSimpleDigestPassword)password);
            }
            case "crypt-des": {
                if (password instanceof UnixDESCryptPasswordImpl) {
                    return password;
                }
                if (!(password instanceof UnixDESCryptPassword)) break;
                return new UnixDESCryptPasswordImpl((UnixDESCryptPassword)password);
            }
            case "bsd-crypt-des": {
                if (password instanceof BSDUnixDESCryptPasswordImpl) {
                    return password;
                }
                if (!(password instanceof BSDUnixDESCryptPassword)) break;
                return new BSDUnixDESCryptPasswordImpl((BSDUnixDESCryptPassword)password);
            }
            case "scram-sha-1": 
            case "scram-sha-256": 
            case "scram-sha-384": 
            case "scram-sha-512": {
                if (password instanceof ScramDigestPasswordImpl && algorithm.equals(password.getAlgorithm())) {
                    return password;
                }
                if (!(password instanceof ScramDigestPassword) || !algorithm.equals(password.getAlgorithm())) break;
                return new ScramDigestPasswordImpl((ScramDigestPassword)password);
            }
            case "otp-md5": 
            case "otp-sha1": 
            case "otp-sha256": 
            case "otp-sha384": 
            case "otp-sha512": {
                if (password instanceof OneTimePasswordImpl && algorithm.equals(password.getAlgorithm())) {
                    return password;
                }
                if (!(password instanceof OneTimePassword) || !algorithm.equals(password.getAlgorithm())) break;
                return new OneTimePasswordImpl((OneTimePassword)password);
            }
            default: {
                if (!MaskedPassword.isMaskedAlgorithm((String)algorithm)) break;
                if (password instanceof MaskedPasswordImpl && algorithm.equals(password.getAlgorithm())) {
                    return password;
                }
                if (!(password instanceof MaskedPassword) || !algorithm.equals(password.getAlgorithm())) break;
                try {
                    return new MaskedPasswordImpl((MaskedPassword)password);
                }
                catch (InvalidKeySpecException e) {
                    throw new InvalidKeyException(e);
                }
            }
        }
        throw ElytronMessages.log.invalidKeyUnknownUnknownPasswordTypeOrAlgorithm();
    }

    protected boolean engineVerify(String algorithm, Password password, char[] guess) throws InvalidKeyException {
        AbstractPasswordImpl abstractPassword;
        if (password instanceof AbstractPasswordImpl && algorithm.equals((abstractPassword = (AbstractPasswordImpl)password).getAlgorithm())) {
            return abstractPassword.verify(guess);
        }
        throw new InvalidKeyException();
    }

    protected boolean engineVerify(String algorithm, Password password, char[] guess, Charset hashCharset) throws InvalidKeyException {
        AbstractPasswordImpl abstractPassword;
        if (password instanceof AbstractPasswordImpl && algorithm.equals((abstractPassword = (AbstractPasswordImpl)password).getAlgorithm())) {
            return abstractPassword.verify(guess, hashCharset);
        }
        throw new InvalidKeyException();
    }

    protected <S extends KeySpec> boolean engineConvertibleToKeySpec(String algorithm, Password password, Class<S> keySpecType) {
        AbstractPasswordImpl abstractPassword;
        if (password instanceof AbstractPasswordImpl && algorithm.equals((abstractPassword = (AbstractPasswordImpl)password).getAlgorithm())) {
            return abstractPassword.convertibleTo(keySpecType);
        }
        return false;
    }

    protected Password engineTransform(String algorithm, Password password, AlgorithmParameterSpec parameterSpec) throws InvalidKeyException, InvalidAlgorithmParameterException {
        AbstractPasswordImpl abstractPassword;
        if (password instanceof AbstractPasswordImpl && algorithm.equals((abstractPassword = (AbstractPasswordImpl)password).getAlgorithm())) {
            return abstractPassword.translate(parameterSpec);
        }
        throw new InvalidKeyException();
    }
}

