/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.graph.embeddable.internal;

import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.internal.util.NullnessUtil;
import org.hibernate.metamodel.mapping.EmbeddableMappingType;
import org.hibernate.metamodel.mapping.EmbeddableValuedModelPart;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.SqlAstJoinType;
import org.hibernate.sql.ast.spi.FromClauseAccess;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableGroupJoin;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.predicate.NullnessPredicate;
import org.hibernate.sql.results.graph.AbstractFetchParent;
import org.hibernate.sql.results.graph.AssemblerCreationState;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultAssembler;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.Fetch;
import org.hibernate.sql.results.graph.Initializer;
import org.hibernate.sql.results.graph.InitializerParent;
import org.hibernate.sql.results.graph.InitializerProducer;
import org.hibernate.sql.results.graph.basic.BasicFetch;
import org.hibernate.sql.results.graph.embeddable.EmbeddableResult;
import org.hibernate.sql.results.graph.embeddable.EmbeddableResultGraphNode;
import org.hibernate.sql.results.graph.embeddable.internal.EmbeddableAssembler;
import org.hibernate.sql.results.graph.embeddable.internal.EmbeddableInitializerImpl;
import org.hibernate.sql.results.graph.internal.ImmutableFetchList;
import org.hibernate.type.BasicType;
import org.hibernate.type.descriptor.java.JavaType;

public class EmbeddableResultImpl<T>
extends AbstractFetchParent
implements EmbeddableResultGraphNode,
DomainResult<T>,
EmbeddableResult<T>,
InitializerProducer<EmbeddableResultImpl<T>> {
    private final String resultVariable;
    private final boolean containsAnyNonScalars;
    private final EmbeddableMappingType fetchContainer;
    private final BasicFetch<?> discriminatorFetch;
    private final @Nullable DomainResult<Boolean> nullIndicatorResult;

    public EmbeddableResultImpl(NavigablePath navigablePath, EmbeddableValuedModelPart modelPart, String resultVariable, DomainResultCreationState creationState) {
        super(navigablePath.append("{embeddable_result}"));
        this.fetchContainer = modelPart.getEmbeddableTypeDescriptor();
        this.resultVariable = resultVariable;
        FromClauseAccess fromClauseAccess = creationState.getSqlAstCreationState().getFromClauseAccess();
        TableGroup embeddableTableGroup = fromClauseAccess.resolveTableGroup(this.getNavigablePath(), np -> {
            EmbeddableValuedModelPart embeddedValueMapping = modelPart.getEmbeddableTypeDescriptor().getEmbeddedValueMapping();
            TableGroup tableGroup = fromClauseAccess.findTableGroup(NullnessUtil.castNonNull(np.getParent()).getParent());
            TableGroupJoin tableGroupJoin = embeddedValueMapping.createTableGroupJoin((NavigablePath)np, tableGroup, resultVariable, null, SqlAstJoinType.INNER, true, false, creationState.getSqlAstCreationState());
            tableGroup.addTableGroupJoin(tableGroupJoin);
            return tableGroupJoin.getJoinedGroup();
        });
        this.discriminatorFetch = creationState.visitEmbeddableDiscriminatorFetch(this, false);
        if (this.fetchContainer.getAggregateMapping() != null) {
            TableReference tableReference = embeddableTableGroup.resolveTableReference(this.fetchContainer.getAggregateMapping().getContainingTableExpression());
            Expression aggregateExpression = creationState.getSqlAstCreationState().getSqlExpressionResolver().resolveSqlExpression(tableReference, this.fetchContainer.getAggregateMapping());
            BasicType<Boolean> booleanType = creationState.getSqlAstCreationState().getCreationContext().getSessionFactory().getTypeConfiguration().getBasicTypeForJavaType(Boolean.class);
            this.nullIndicatorResult = new NullnessPredicate(aggregateExpression, false, booleanType).createDomainResult(null, creationState);
        } else {
            this.nullIndicatorResult = null;
        }
        this.afterInitialize(this, creationState);
        this.containsAnyNonScalars = EmbeddableResultImpl.determineIfContainedAnyScalars(this.getFetches());
    }

    private static boolean determineIfContainedAnyScalars(ImmutableFetchList fetches) {
        for (Fetch fetch : fetches) {
            if (!fetch.containsAnyNonScalarResults()) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getResultVariable() {
        return this.resultVariable;
    }

    @Override
    public boolean containsAnyNonScalarResults() {
        return this.containsAnyNonScalars;
    }

    @Override
    public EmbeddableMappingType getFetchContainer() {
        return this.fetchContainer;
    }

    @Override
    public JavaType<?> getResultJavaType() {
        return this.getReferencedMappingType().getJavaType();
    }

    @Override
    public EmbeddableMappingType getReferencedMappingType() {
        return this.getFetchContainer();
    }

    @Override
    public EmbeddableValuedModelPart getReferencedMappingContainer() {
        return this.getFetchContainer().getEmbeddedValueMapping();
    }

    @Override
    public DomainResultAssembler<T> createResultAssembler(InitializerParent<?> parent, AssemblerCreationState creationState) {
        return new EmbeddableAssembler(creationState.resolveInitializer(this, parent, this).asEmbeddableInitializer());
    }

    @Override
    public Initializer<?> createInitializer(EmbeddableResultImpl<T> resultGraphNode, InitializerParent<?> parent, AssemblerCreationState creationState) {
        return resultGraphNode.createInitializer(parent, creationState);
    }

    @Override
    public Initializer<?> createInitializer(InitializerParent<?> parent, AssemblerCreationState creationState) {
        return new EmbeddableInitializerImpl(this, this.discriminatorFetch, this.nullIndicatorResult, parent, creationState, true);
    }
}

