/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.federation.kerberos;

public class KerberosPrincipal {
    private final String kerberosPrincipal;
    private final String prefix;
    private final String realm;

    public KerberosPrincipal(String kerberosPrincipal) {
        String[] parts = kerberosPrincipal.split("@");
        if (parts.length != 2) {
            throw new IllegalArgumentException("Kerberos principal '" + kerberosPrincipal + "' not valid");
        }
        this.prefix = parts[0];
        this.realm = parts[1].toUpperCase();
        this.kerberosPrincipal = this.prefix + "@" + this.realm;
    }

    public String getKerberosPrincipal() {
        return this.kerberosPrincipal;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getRealm() {
        return this.realm;
    }

    public String toString() {
        return this.kerberosPrincipal;
    }
}

