/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.net.URI;
import java.text.MessageFormat;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.stream.Stream;
import org.eclipse.microprofile.openapi.annotations.Operation;
import org.eclipse.microprofile.openapi.annotations.extensions.Extension;
import org.eclipse.microprofile.openapi.annotations.parameters.Parameter;
import org.eclipse.microprofile.openapi.annotations.responses.APIResponse;
import org.eclipse.microprofile.openapi.annotations.tags.Tag;
import org.jboss.logging.Logger;
import org.jboss.resteasy.reactive.NoCache;
import org.keycloak.events.admin.OperationType;
import org.keycloak.events.admin.ResourceType;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.ProtocolMapperContainerModel;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.models.utils.RepresentationToModel;
import org.keycloak.protocol.ProtocolMapper;
import org.keycloak.protocol.ProtocolMapperConfigException;
import org.keycloak.protocol.ProtocolMapperUtils;
import org.keycloak.representations.idm.ProtocolMapperRepresentation;
import org.keycloak.services.ErrorResponse;
import org.keycloak.services.ErrorResponseException;
import org.keycloak.services.resources.admin.AdminEventBuilder;
import org.keycloak.services.resources.admin.AdminRoot;
import org.keycloak.services.resources.admin.fgap.AdminPermissionEvaluator;

@Extension(name="x-smallrye-profile-admin", value="")
public class ProtocolMappersResource {
    protected static final Logger logger = Logger.getLogger(ProtocolMappersResource.class);
    protected final RealmModel realm;
    protected final ProtocolMapperContainerModel client;
    protected final AdminPermissionEvaluator auth;
    protected final AdminPermissionEvaluator.RequirePermissionCheck managePermission;
    protected final AdminPermissionEvaluator.RequirePermissionCheck viewPermission;
    protected final AdminEventBuilder adminEvent;
    protected final KeycloakSession session;

    public ProtocolMappersResource(KeycloakSession session, ProtocolMapperContainerModel client, AdminPermissionEvaluator auth, AdminEventBuilder adminEvent, AdminPermissionEvaluator.RequirePermissionCheck managePermission, AdminPermissionEvaluator.RequirePermissionCheck viewPermission) {
        this.session = session;
        this.realm = session.getContext().getRealm();
        this.auth = auth;
        this.client = client;
        this.adminEvent = adminEvent.resource(ResourceType.PROTOCOL_MAPPER);
        this.managePermission = managePermission;
        this.viewPermission = viewPermission;
    }

    @GET
    @NoCache
    @Path(value="protocol/{protocol}")
    @Produces(value={"application/json"})
    @Tag(name="Protocol Mappers")
    @Operation(summary="Get mappers by name for a specific protocol")
    public Stream<ProtocolMapperRepresentation> getMappersPerProtocol(@PathParam(value="protocol") String protocol) {
        this.viewPermission.require();
        return this.client.getProtocolMappersStream().filter(mapper -> ProtocolMapperUtils.isEnabled(this.session, mapper) && Objects.equals(mapper.getProtocol(), protocol)).map(this::toEffectiveProtocolMapperRep);
    }

    @Path(value="models")
    @POST
    @NoCache
    @Consumes(value={"application/json"})
    @Tag(name="Protocol Mappers")
    @Operation(summary="Create a mapper")
    public Response createMapper(ProtocolMapperRepresentation rep) {
        this.managePermission.require();
        ProtocolMapperModel model = null;
        try {
            model = RepresentationToModel.toModel((ProtocolMapperRepresentation)rep);
            this.validateModel(model);
            model = this.client.addProtocolMapper(model);
            this.adminEvent.operation(OperationType.CREATE).resourcePath((UriInfo)this.session.getContext().getUri(), model.getId()).representation(rep).success();
        }
        catch (ModelDuplicateException e) {
            throw ErrorResponse.exists("Protocol mapper exists with same name");
        }
        return Response.created((URI)this.session.getContext().getUri().getAbsolutePathBuilder().path(model.getId()).build(new Object[0])).build();
    }

    @Path(value="add-models")
    @POST
    @NoCache
    @Consumes(value={"application/json"})
    @Tag(name="Protocol Mappers")
    @Operation(summary="Create multiple mappers")
    @APIResponse(responseCode="204", description="No Content")
    public void createMapper(List<ProtocolMapperRepresentation> reps) {
        this.managePermission.require();
        ProtocolMapperModel model = null;
        for (ProtocolMapperRepresentation rep : reps) {
            model = RepresentationToModel.toModel((ProtocolMapperRepresentation)rep);
            this.validateModel(model);
            model = this.client.addProtocolMapper(model);
        }
        this.adminEvent.operation(OperationType.CREATE).resourcePath((UriInfo)this.session.getContext().getUri()).representation(reps).success();
    }

    @GET
    @NoCache
    @Path(value="models")
    @Produces(value={"application/json"})
    @Tag(name="Protocol Mappers")
    @Operation(summary="Get mappers")
    public Stream<ProtocolMapperRepresentation> getMappers() {
        this.viewPermission.require();
        return this.client.getProtocolMappersStream().filter(mapper -> ProtocolMapperUtils.isEnabled(this.session, mapper)).map(this::toEffectiveProtocolMapperRep);
    }

    @GET
    @NoCache
    @Path(value="models/{id}")
    @Produces(value={"application/json"})
    @Tag(name="Protocol Mappers")
    @Operation(summary="Get mapper by id")
    public ProtocolMapperRepresentation getMapperById(@Parameter(description="Mapper id") @PathParam(value="id") String id) {
        this.viewPermission.require();
        ProtocolMapperModel model = this.client.getProtocolMapperById(id);
        if (model == null) {
            throw new NotFoundException("Model not found");
        }
        return this.toEffectiveProtocolMapperRep(model);
    }

    private ProtocolMapperRepresentation toEffectiveProtocolMapperRep(ProtocolMapperModel model) {
        ProtocolMapper mapper = (ProtocolMapper)this.session.getKeycloakSessionFactory().getProviderFactory(ProtocolMapper.class, model.getProtocolMapper());
        if (mapper == null) {
            logger.warnf("Protocol mapper provider '%s' not found. Configured on mapper with ID '%s'", (Object)model.getProtocolMapper(), (Object)model.getId());
            throw new NotFoundException("Protocol mapper provider not found");
        }
        model = mapper.getEffectiveModel(this.session, this.realm, model);
        return ModelToRepresentation.toRepresentation((ProtocolMapperModel)model);
    }

    @PUT
    @NoCache
    @Path(value="models/{id}")
    @Consumes(value={"application/json"})
    @Tag(name="Protocol Mappers")
    @Operation(summary="Update the mapper")
    public void update(@Parameter(description="Mapper id") @PathParam(value="id") String id, ProtocolMapperRepresentation rep) {
        this.managePermission.require();
        ProtocolMapperModel model = this.client.getProtocolMapperById(id);
        if (model == null) {
            throw new NotFoundException("Model not found");
        }
        model = RepresentationToModel.toModel((ProtocolMapperRepresentation)rep);
        this.validateModel(model);
        this.client.updateProtocolMapper(model);
        this.adminEvent.operation(OperationType.UPDATE).resourcePath((UriInfo)this.session.getContext().getUri()).representation(rep).success();
    }

    @DELETE
    @NoCache
    @Path(value="models/{id}")
    @Tag(name="Protocol Mappers")
    @Operation(summary="Delete the mapper")
    public void delete(@Parameter(description="Mapper id") @PathParam(value="id") String id) {
        this.managePermission.require();
        ProtocolMapperModel model = this.client.getProtocolMapperById(id);
        if (model == null) {
            throw new NotFoundException("Model not found");
        }
        this.client.removeProtocolMapper(model);
        this.adminEvent.operation(OperationType.DELETE).resourcePath((UriInfo)this.session.getContext().getUri()).success();
    }

    private void validateModel(ProtocolMapperModel model) {
        try {
            ProtocolMapper mapper = (ProtocolMapper)this.session.getKeycloakSessionFactory().getProviderFactory(ProtocolMapper.class, model.getProtocolMapper());
            if (mapper == null) {
                throw new NotFoundException("ProtocolMapper provider not found");
            }
            mapper.validateConfig(this.session, this.realm, this.client, model);
        }
        catch (ProtocolMapperConfigException ex) {
            logger.error((Object)ex.getMessage());
            Properties messages = AdminRoot.getMessages(this.session, this.realm, this.auth.adminAuth().getToken().getLocale());
            throw new ErrorResponseException(ex.getMessage(), MessageFormat.format(messages.getProperty(ex.getMessageKey(), ex.getMessage()), ex.getParameters()), Response.Status.BAD_REQUEST);
        }
    }
}

