/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin.fgap;

import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.services.resources.admin.AdminAuth;
import org.keycloak.services.resources.admin.fgap.ClientPermissions;
import org.keycloak.services.resources.admin.fgap.ClientPermissionsV2;
import org.keycloak.services.resources.admin.fgap.GroupPermissions;
import org.keycloak.services.resources.admin.fgap.GroupPermissionsV2;
import org.keycloak.services.resources.admin.fgap.MgmtPermissions;
import org.keycloak.services.resources.admin.fgap.RealmPermissions;
import org.keycloak.services.resources.admin.fgap.RealmPermissionsV2;
import org.keycloak.services.resources.admin.fgap.RolePermissions;
import org.keycloak.services.resources.admin.fgap.RolePermissionsV2;
import org.keycloak.services.resources.admin.fgap.UserPermissions;
import org.keycloak.services.resources.admin.fgap.UserPermissionsV2;

class MgmtPermissionsV2
extends MgmtPermissions {
    private ClientPermissionsV2 clientPermissions;
    private GroupPermissionsV2 groupPermissions;
    private RolePermissionsV2 rolePermissions;
    private UserPermissionsV2 userPermissions;
    private RealmPermissionsV2 realmPermissions;

    public MgmtPermissionsV2(KeycloakSession session, RealmModel realm) {
        super(session, realm);
    }

    public MgmtPermissionsV2(KeycloakSession session, RealmModel realm, AdminAuth auth) {
        super(session, realm, auth);
    }

    public MgmtPermissionsV2(KeycloakSession session, AdminAuth auth) {
        super(session, auth);
    }

    public MgmtPermissionsV2(KeycloakSession session, RealmModel adminsRealm, UserModel admin) {
        super(session, adminsRealm, admin);
    }

    @Override
    public ClientModel getRealmPermissionsClient() {
        return this.realm.getAdminPermissionsClient();
    }

    @Override
    public RealmPermissions realm() {
        if (this.realmPermissions != null) {
            return this.realmPermissions;
        }
        this.realmPermissions = new RealmPermissionsV2(this);
        return this.realmPermissions;
    }

    @Override
    public GroupPermissions groups() {
        if (this.groupPermissions != null) {
            return this.groupPermissions;
        }
        this.groupPermissions = new GroupPermissionsV2(this.session, this.authz, this);
        return this.groupPermissions;
    }

    @Override
    public RolePermissions roles() {
        if (this.rolePermissions != null) {
            return this.rolePermissions;
        }
        this.rolePermissions = new RolePermissionsV2(this.session, this.realm, this.authz, this);
        return this.rolePermissions;
    }

    @Override
    public UserPermissions users() {
        if (this.userPermissions != null) {
            return this.userPermissions;
        }
        this.userPermissions = new UserPermissionsV2(this.session, this.authz, this);
        return this.userPermissions;
    }

    @Override
    public ClientPermissions clients() {
        if (this.clientPermissions != null) {
            return this.clientPermissions;
        }
        this.clientPermissions = new ClientPermissionsV2(this.session, this.realm, this.authz, this);
        return this.clientPermissions;
    }
}

