/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.saml;

import java.io.Serializable;
import java.security.Principal;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.keycloak.common.util.MultivaluedHashMap;

public class SamlPrincipal
implements Serializable,
Principal {
    private MultivaluedHashMap<String, String> attributes = new MultivaluedHashMap();
    private MultivaluedHashMap<String, String> friendlyAttributes = new MultivaluedHashMap();
    private String name;
    private String samlSubject;
    private String nameIDFormat;

    public SamlPrincipal(String name, String samlSubject, String nameIDFormat, MultivaluedHashMap<String, String> attributes, MultivaluedHashMap<String, String> friendlyAttributes) {
        this.name = name;
        this.attributes = attributes;
        this.friendlyAttributes = friendlyAttributes;
        this.samlSubject = samlSubject;
        this.nameIDFormat = nameIDFormat;
    }

    public SamlPrincipal() {
    }

    public String getSamlSubject() {
        return this.samlSubject;
    }

    public String getNameIDFormat() {
        return this.nameIDFormat;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public List<String> getAttributes(String name) {
        List list = (List)this.attributes.get((Object)name);
        if (list != null) {
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    public List<String> getFriendlyAttributes(String friendlyName) {
        List list = (List)this.friendlyAttributes.get((Object)this.name);
        if (list != null) {
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    public String getAttribute(String name) {
        return (String)this.attributes.getFirst((Object)name);
    }

    public String getFriendlyAttribute(String friendlyName) {
        return (String)this.friendlyAttributes.getFirst((Object)friendlyName);
    }

    public Set<String> getAttributeNames() {
        return Collections.unmodifiableSet(this.attributes.keySet());
    }

    public Set<String> getFriendlyNames() {
        return Collections.unmodifiableSet(this.friendlyAttributes.keySet());
    }
}

