/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.saml;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceLoader;
import org.jboss.logging.Logger;
import org.keycloak.adapters.saml.RoleMappingsProvider;
import org.keycloak.adapters.saml.SamlDeployment;
import org.keycloak.adapters.saml.config.SP;
import org.keycloak.adapters.saml.config.parsers.ResourceLoader;

public class RoleMappingsProviderUtils {
    private static final Logger logger = Logger.getLogger(RoleMappingsProviderUtils.class);

    public static RoleMappingsProvider bootstrapRoleMappingsProvider(SamlDeployment deployment, ResourceLoader loader, SP.RoleMappingsProviderConfig providerConfig) {
        if (providerConfig == null || providerConfig.getId() == null) {
            return null;
        }
        String providerId = providerConfig.getId();
        HashMap<String, RoleMappingsProvider> roleMappingsProviders = new HashMap<String, RoleMappingsProvider>();
        RoleMappingsProviderUtils.loadProviders(roleMappingsProviders, RoleMappingsProviderUtils.class.getClassLoader());
        RoleMappingsProviderUtils.loadProviders(roleMappingsProviders, Thread.currentThread().getContextClassLoader());
        RoleMappingsProvider provider = (RoleMappingsProvider)roleMappingsProviders.get(providerId);
        if (provider == null) {
            throw new RuntimeException("Couldn't find RoleMappingsProvider implementation class with id: " + providerId + ". Loaded role mappings providers: " + String.valueOf(roleMappingsProviders.keySet()));
        }
        provider.init(deployment, loader, providerConfig != null ? providerConfig.getConfiguration() : new Properties());
        return provider;
    }

    private static void loadProviders(Map<String, RoleMappingsProvider> providers, ClassLoader classLoader) {
        for (RoleMappingsProvider provider : ServiceLoader.load(RoleMappingsProvider.class, classLoader)) {
            logger.debugf("Loaded RoleMappingsProvider %s", (Object)provider.getId());
            providers.put(provider.getId(), provider);
        }
    }
}

