/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.saml.config.parsers;

import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.keycloak.adapters.saml.config.parsers.KeycloakSamlAdapterV1Parser;
import org.keycloak.adapters.saml.config.parsers.KeycloakSamlAdapterV1QNames;
import org.keycloak.saml.common.exceptions.ParsingException;
import org.keycloak.saml.common.parsers.AbstractParser;
import org.keycloak.saml.common.parsers.StaxParser;
import org.keycloak.saml.common.util.StaxParserUtil;

public class KeycloakSamlAdapterParser
extends AbstractParser {
    private static final Map<QName, ParserFactory> PARSERS = new HashMap<QName, ParserFactory>();
    private static final QName ALTERNATE_KEYCLOAK_SAML_ADAPTER_V1 = new QName(KeycloakSamlAdapterV1QNames.KEYCLOAK_SAML_ADAPTER.getQName().getLocalPart());
    private static final KeycloakSamlAdapterParser INSTANCE;

    public static KeycloakSamlAdapterParser getInstance() {
        return INSTANCE;
    }

    protected KeycloakSamlAdapterParser() {
    }

    public Object parse(XMLEventReader xmlEventReader) throws ParsingException {
        while (xmlEventReader.hasNext()) {
            XMLEvent xmlEvent = StaxParserUtil.peek((XMLEventReader)xmlEventReader);
            if (xmlEvent instanceof StartElement) {
                StartElement startElement = (StartElement)xmlEvent;
                QName name = startElement.getName();
                ParserFactory pf = PARSERS.get(name);
                if (pf == null) {
                    throw logger.parserException((Throwable)new RuntimeException("PL00064: Parser: Unknown Start Element: " + String.valueOf(name) + "::location=" + String.valueOf(startElement.getLocation())));
                }
                return pf.create().parse(xmlEventReader);
            }
            StaxParserUtil.getNextEvent((XMLEventReader)xmlEventReader);
        }
        throw new RuntimeException("PL00067: Parsing has failed:SAML Parsing has failed");
    }

    static {
        PARSERS.put(KeycloakSamlAdapterV1QNames.KEYCLOAK_SAML_ADAPTER.getQName(), new ParserFactory(){

            @Override
            public StaxParser create() {
                return KeycloakSamlAdapterV1Parser.getInstance();
            }
        });
        PARSERS.put(ALTERNATE_KEYCLOAK_SAML_ADAPTER_V1, new ParserFactory(){

            @Override
            public StaxParser create() {
                return KeycloakSamlAdapterV1Parser.getInstance();
            }
        });
        INSTANCE = new KeycloakSamlAdapterParser();
    }

    private static interface ParserFactory {
        public StaxParser create();
    }
}

