/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.saml;

import java.io.IOException;
import java.security.Principal;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpSession;
import org.apache.catalina.Manager;
import org.apache.catalina.Session;
import org.apache.catalina.connector.Request;
import org.apache.catalina.realm.GenericPrincipal;
import org.jboss.logging.Logger;
import org.keycloak.adapters.saml.AbstractSamlAuthenticatorValve;
import org.keycloak.adapters.saml.SamlDeployment;
import org.keycloak.adapters.saml.SamlSession;
import org.keycloak.adapters.saml.SamlSessionStore;
import org.keycloak.adapters.saml.SamlUtil;
import org.keycloak.adapters.spi.HttpFacade;
import org.keycloak.adapters.spi.SessionIdMapper;
import org.keycloak.adapters.spi.SessionIdMapperUpdater;
import org.keycloak.adapters.tomcat.CatalinaUserSessionManagement;
import org.keycloak.adapters.tomcat.PrincipalFactory;
import org.keycloak.common.util.KeycloakUriBuilder;

public class CatalinaSamlSessionStore
implements SamlSessionStore {
    protected static Logger log = Logger.getLogger(SamlSessionStore.class);
    public static final String SAML_REDIRECT_URI = "SAML_REDIRECT_URI";
    private final CatalinaUserSessionManagement sessionManagement;
    protected final PrincipalFactory principalFactory;
    private final SessionIdMapper idMapper;
    private final SessionIdMapperUpdater idMapperUpdater;
    protected final Request request;
    protected final AbstractSamlAuthenticatorValve valve;
    protected final HttpFacade facade;
    protected final SamlDeployment deployment;

    public CatalinaSamlSessionStore(CatalinaUserSessionManagement sessionManagement, PrincipalFactory principalFactory, SessionIdMapper idMapper, SessionIdMapperUpdater idMapperUpdater, Request request, AbstractSamlAuthenticatorValve valve, HttpFacade facade, SamlDeployment deployment) {
        this.sessionManagement = sessionManagement;
        this.principalFactory = principalFactory;
        this.idMapper = idMapper;
        this.idMapperUpdater = idMapperUpdater;
        this.request = request;
        this.valve = valve;
        this.facade = facade;
        this.deployment = deployment;
    }

    public void setCurrentAction(SamlSessionStore.CurrentAction action) {
        if (action == SamlSessionStore.CurrentAction.NONE && this.request.getSession(false) == null) {
            return;
        }
        this.request.getSession().setAttribute("SAML_CURRENT_ACTION", (Object)action);
    }

    public boolean isLoggingIn() {
        HttpSession session = this.request.getSession(false);
        if (session == null) {
            return false;
        }
        SamlSessionStore.CurrentAction action = (SamlSessionStore.CurrentAction)session.getAttribute("SAML_CURRENT_ACTION");
        return action == SamlSessionStore.CurrentAction.LOGGING_IN;
    }

    public boolean isLoggingOut() {
        HttpSession session = this.request.getSession(false);
        if (session == null) {
            return false;
        }
        SamlSessionStore.CurrentAction action = (SamlSessionStore.CurrentAction)session.getAttribute("SAML_CURRENT_ACTION");
        return action == SamlSessionStore.CurrentAction.LOGGING_OUT;
    }

    public void logoutAccount() {
        Session sessionInternal = this.request.getSessionInternal(false);
        if (sessionInternal == null) {
            return;
        }
        HttpSession session = sessionInternal.getSession();
        LinkedList<String> ids = new LinkedList<String>();
        if (session != null) {
            SamlSession samlSession = (SamlSession)session.getAttribute(SamlSession.class.getName());
            if (samlSession != null) {
                if (samlSession.getSessionIndex() != null) {
                    ids.add(session.getId());
                    this.idMapperUpdater.removeSession(this.idMapper, session.getId());
                }
                session.removeAttribute(SamlSession.class.getName());
            }
            session.removeAttribute(SAML_REDIRECT_URI);
        }
        sessionInternal.setPrincipal(null);
        sessionInternal.setAuthType(null);
        this.logoutSessionIds(ids);
    }

    public void logoutByPrincipal(String principal) {
        Set sessions = this.idMapper.getUserSessions(principal);
        if (sessions != null) {
            LinkedList<String> ids = new LinkedList<String>();
            ids.addAll(sessions);
            this.logoutSessionIds(ids);
            for (String id : ids) {
                this.idMapperUpdater.removeSession(this.idMapper, id);
            }
        }
    }

    public void logoutBySsoId(List<String> ssoIds) {
        if (ssoIds == null) {
            return;
        }
        LinkedList<String> sessionIds = new LinkedList<String>();
        for (String id : ssoIds) {
            String sessionId = this.idMapper.getSessionFromSSO(id);
            if (sessionId == null) continue;
            sessionIds.add(sessionId);
            this.idMapperUpdater.removeSession(this.idMapper, sessionId);
        }
        this.logoutSessionIds(sessionIds);
    }

    protected void logoutSessionIds(List<String> sessionIds) {
        if (sessionIds == null || sessionIds.isEmpty()) {
            return;
        }
        Manager sessionManager = this.request.getContext().getManager();
        this.sessionManagement.logoutHttpSessions(sessionManager, sessionIds);
    }

    public boolean isLoggedIn() {
        Session session = this.request.getSessionInternal(false);
        if (session == null) {
            log.debug((Object)"session was null, returning null");
            return false;
        }
        SamlSession samlSession = SamlUtil.validateSamlSession((Object)session.getSession().getAttribute(SamlSession.class.getName()), (SamlDeployment)this.deployment);
        if (samlSession == null) {
            return false;
        }
        GenericPrincipal principal = (GenericPrincipal)session.getPrincipal();
        if (principal == null) {
            principal = this.principalFactory.createPrincipal(this.request.getContext().getRealm(), (Principal)samlSession.getPrincipal(), samlSession.getRoles());
            session.setPrincipal((Principal)principal);
            session.setAuthType("KEYCLOAK-SAML");
        } else if (samlSession.getPrincipal().getName().equals(principal.getName())) {
            if (!principal.getUserPrincipal().getName().equals(samlSession.getPrincipal().getName())) {
                throw new RuntimeException("Unknown State");
            }
            log.debug((Object)"************principal already in");
            if (log.isDebugEnabled()) {
                for (String role : principal.getRoles()) {
                    log.debug((Object)("principal role: " + role));
                }
            }
        }
        this.request.setUserPrincipal((Principal)principal);
        this.request.setAuthType("KEYCLOAK-SAML");
        this.restoreRequest();
        return true;
    }

    public void saveAccount(SamlSession account) {
        Session session = this.request.getSessionInternal(true);
        session.getSession().setAttribute(SamlSession.class.getName(), (Object)account);
        GenericPrincipal principal = (GenericPrincipal)session.getPrincipal();
        if (principal == null) {
            principal = this.principalFactory.createPrincipal(this.request.getContext().getRealm(), (Principal)account.getPrincipal(), account.getRoles());
            session.setPrincipal((Principal)principal);
            session.setAuthType("KEYCLOAK-SAML");
        }
        this.request.setUserPrincipal((Principal)principal);
        this.request.setAuthType("KEYCLOAK-SAML");
        String newId = this.changeSessionId(session);
        this.idMapperUpdater.map(this.idMapper, account.getSessionIndex(), account.getPrincipal().getSamlSubject(), newId);
    }

    protected String changeSessionId(Session session) {
        return session.getId();
    }

    public SamlSession getAccount() {
        HttpSession session = this.getSession(true);
        return (SamlSession)session.getAttribute(SamlSession.class.getName());
    }

    public String getRedirectUri() {
        String redirect = (String)this.getSession(true).getAttribute(SAML_REDIRECT_URI);
        if (redirect == null) {
            String contextPath = this.request.getContextPath();
            String baseUri = KeycloakUriBuilder.fromUri((String)this.request.getRequestURL().toString()).replacePath(contextPath).build(new Object[0]).toString();
            return SamlUtil.getRedirectTo((HttpFacade)this.facade, (String)contextPath, (String)baseUri);
        }
        return redirect;
    }

    public void saveRequest() {
        try {
            this.valve.keycloakSaveRequest(this.request);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.getSession(true).setAttribute(SAML_REDIRECT_URI, (Object)this.facade.getRequest().getURI());
    }

    public boolean restoreRequest() {
        this.getSession(true).removeAttribute(SAML_REDIRECT_URI);
        return this.valve.keycloakRestoreRequest(this.request);
    }

    protected HttpSession getSession(boolean create) {
        Session session = this.request.getSessionInternal(create);
        if (session == null) {
            return null;
        }
        return session.getSession();
    }
}

