/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.saml.jbossweb.infinispan;

import java.util.List;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.ServletContext;
import org.apache.catalina.Context;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.loaders.CacheLoaderManager;
import org.infinispan.loaders.remote.RemoteCacheStore;
import org.infinispan.manager.EmbeddedCacheManager;
import org.jboss.logging.Logger;
import org.keycloak.adapters.saml.jbossweb.infinispan.SsoCacheSessionIdMapperUpdater;
import org.keycloak.adapters.saml.jbossweb.infinispan.SsoSessionCacheListener;
import org.keycloak.adapters.spi.SessionIdMapper;
import org.keycloak.adapters.spi.SessionIdMapperUpdater;

public class InfinispanSessionCacheIdMapperUpdater {
    private static final Logger LOG = Logger.getLogger(InfinispanSessionCacheIdMapperUpdater.class);
    public static final String DEFAULT_CACHE_CONTAINER_JNDI_NAME = "java:jboss/infinispan/container";

    public static SessionIdMapperUpdater addTokenStoreUpdaters(Context context, SessionIdMapper mapper, SessionIdMapperUpdater previousIdMapperUpdater) {
        ServletContext servletContext = context.getServletContext();
        String containerName = servletContext == null ? null : servletContext.getInitParameter("org.keycloak.saml.replication.container");
        String cacheName = servletContext == null ? null : servletContext.getInitParameter("org.keycloak.saml.replication.cache.sso");
        String host = context.getParent() == null ? "" : context.getParent().getName();
        String contextPath = context.getPath();
        if ("/".equals(contextPath)) {
            contextPath = "/ROOT";
        }
        String deploymentSessionCacheName = host + contextPath;
        if (containerName == null || cacheName == null || deploymentSessionCacheName == null) {
            LOG.warnv("Cannot determine parameters of SSO cache for deployment {0}.", (Object)(host + contextPath));
            return previousIdMapperUpdater;
        }
        String cacheContainerLookup = "java:jboss/infinispan/container/" + containerName;
        try {
            EmbeddedCacheManager cacheManager = (EmbeddedCacheManager)new InitialContext().lookup(cacheContainerLookup);
            Configuration ssoCacheConfiguration = cacheManager.getCacheConfiguration(cacheName);
            if (ssoCacheConfiguration == null) {
                Configuration cacheConfiguration = cacheManager.getCacheConfiguration(deploymentSessionCacheName);
                if (cacheConfiguration == null) {
                    LOG.debugv("Using default configuration for SSO cache {0}.{1}.", (Object)containerName, (Object)cacheName);
                    ssoCacheConfiguration = cacheManager.getDefaultCacheConfiguration();
                } else {
                    LOG.debugv("Using distributed HTTP session cache configuration for SSO cache {0}.{1}, configuration taken from cache {2}", (Object)containerName, (Object)cacheName, (Object)deploymentSessionCacheName);
                    ssoCacheConfiguration = cacheConfiguration;
                    cacheManager.defineConfiguration(cacheName, ssoCacheConfiguration);
                }
            } else {
                LOG.debugv("Using custom configuration of SSO cache {0}.{1}.", (Object)containerName, (Object)cacheName);
            }
            CacheMode ssoCacheMode = ssoCacheConfiguration.clustering().cacheMode();
            if (ssoCacheMode != CacheMode.REPL_ASYNC && ssoCacheMode != CacheMode.REPL_SYNC) {
                LOG.warnv("SSO cache mode is {0}, it is recommended to use replicated mode instead.", (Object)ssoCacheConfiguration.clustering().cacheModeString());
            }
            Cache ssoCache = cacheManager.getCache(cacheName, true);
            SsoSessionCacheListener listener = new SsoSessionCacheListener((Cache<String, String[]>)ssoCache, mapper);
            ssoCache.addListener((Object)listener);
            InfinispanSessionCacheIdMapperUpdater.warnIfRemoteStoreIsUsed((Cache<String, String[]>)ssoCache);
            LOG.debugv("Added distributed SSO session cache, lookup={0}, cache name={1}", (Object)cacheContainerLookup, (Object)cacheName);
            SsoCacheSessionIdMapperUpdater updater = new SsoCacheSessionIdMapperUpdater((Cache<String, String[]>)ssoCache, previousIdMapperUpdater);
            return updater;
        }
        catch (NamingException ex) {
            LOG.warnv("Failed to obtain distributed session cache container, lookup={0}", (Object)cacheContainerLookup);
            return previousIdMapperUpdater;
        }
    }

    private static void warnIfRemoteStoreIsUsed(Cache<String, String[]> ssoCache) {
        List<RemoteCacheStore> stores = InfinispanSessionCacheIdMapperUpdater.getRemoteStores(ssoCache);
        if (stores == null || stores.isEmpty()) {
            return;
        }
        LOG.warnv("Unable to listen for events on remote stores configured for cache {0} (unsupported in this Infinispan limitations), logouts will not be propagated.", (Object)ssoCache.getName());
    }

    public static List<RemoteCacheStore> getRemoteStores(Cache ssoCache) {
        return ((CacheLoaderManager)ssoCache.getAdvancedCache().getComponentRegistry().getComponent(CacheLoaderManager.class)).getCacheLoaders(RemoteCacheStore.class);
    }
}

