/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.saml.config.parsers;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.keycloak.adapters.saml.config.Key;
import org.keycloak.adapters.saml.config.parsers.SPXmlParser;
import org.keycloak.saml.common.exceptions.ParsingException;
import org.keycloak.saml.common.parsers.AbstractParser;
import org.keycloak.saml.common.util.StaxParserUtil;

public class KeyXmlParser
extends AbstractParser {
    public Object parse(XMLEventReader xmlEventReader) throws ParsingException {
        XMLEvent xmlEvent;
        StartElement startElement = StaxParserUtil.getNextStartElement((XMLEventReader)xmlEventReader);
        StaxParserUtil.validate((StartElement)startElement, (String)"Key");
        Key key = new Key();
        key.setSigning(SPXmlParser.getBooleanAttributeValue(startElement, "signing"));
        key.setEncryption(SPXmlParser.getBooleanAttributeValue(startElement, "encryption"));
        while (xmlEventReader.hasNext() && (xmlEvent = StaxParserUtil.peek((XMLEventReader)xmlEventReader)) != null) {
            StartElement element;
            if (xmlEvent instanceof EndElement) {
                EndElement endElement = (EndElement)StaxParserUtil.getNextEvent((XMLEventReader)xmlEventReader);
                String endElementName = StaxParserUtil.getEndElementName((EndElement)endElement);
                if (endElementName.equals("Key")) break;
                throw logger.parserUnknownEndElement(endElementName);
            }
            startElement = StaxParserUtil.peekNextStartElement((XMLEventReader)xmlEventReader);
            if (startElement == null) break;
            String tag = StaxParserUtil.getStartElementName((StartElement)startElement);
            if (tag.equals("KeyStore")) {
                key.setKeystore(this.parseKeyStore(xmlEventReader));
                continue;
            }
            if (tag.equals("CertificatePem")) {
                element = StaxParserUtil.getNextStartElement((XMLEventReader)xmlEventReader);
                key.setCertificatePem(SPXmlParser.getElementText(xmlEventReader));
                continue;
            }
            if (tag.equals("PublicKeyPem")) {
                element = StaxParserUtil.getNextStartElement((XMLEventReader)xmlEventReader);
                key.setPublicKeyPem(SPXmlParser.getElementText(xmlEventReader));
                continue;
            }
            if (tag.equals("PrivateKeyPem")) {
                element = StaxParserUtil.getNextStartElement((XMLEventReader)xmlEventReader);
                key.setPrivateKeyPem(SPXmlParser.getElementText(xmlEventReader));
                continue;
            }
            StaxParserUtil.bypassElementBlock((XMLEventReader)xmlEventReader, (String)tag);
        }
        return key;
    }

    protected Key.KeyStoreConfig parseKeyStore(XMLEventReader xmlEventReader) throws ParsingException {
        XMLEvent xmlEvent;
        StartElement startElement = StaxParserUtil.getNextStartElement((XMLEventReader)xmlEventReader);
        StaxParserUtil.validate((StartElement)startElement, (String)"KeyStore");
        Key.KeyStoreConfig keyStore = new Key.KeyStoreConfig();
        keyStore.setType(SPXmlParser.getAttributeValue(startElement, "type"));
        keyStore.setAlias(SPXmlParser.getAttributeValue(startElement, "alias"));
        keyStore.setFile(SPXmlParser.getAttributeValue(startElement, "file"));
        keyStore.setResource(SPXmlParser.getAttributeValue(startElement, "resource"));
        if (keyStore.getFile() == null && keyStore.getResource() == null) {
            throw new ParsingException("KeyStore element must have the url or classpath attribute set");
        }
        keyStore.setPassword(SPXmlParser.getAttributeValue(startElement, "password"));
        if (keyStore.getPassword() == null) {
            throw new ParsingException("KeyStore element must have the password attribute set");
        }
        while (xmlEventReader.hasNext() && (xmlEvent = StaxParserUtil.peek((XMLEventReader)xmlEventReader)) != null) {
            StartElement element;
            if (xmlEvent instanceof EndElement) {
                EndElement endElement = (EndElement)StaxParserUtil.getNextEvent((XMLEventReader)xmlEventReader);
                String endElementName = StaxParserUtil.getEndElementName((EndElement)endElement);
                if (!endElementName.equals("KeyStore")) continue;
                break;
            }
            startElement = StaxParserUtil.peekNextStartElement((XMLEventReader)xmlEventReader);
            if (startElement == null) break;
            String tag = StaxParserUtil.getStartElementName((StartElement)startElement);
            if (tag.equals("Certificate")) {
                element = StaxParserUtil.getNextStartElement((XMLEventReader)xmlEventReader);
                keyStore.setCertificateAlias(SPXmlParser.getAttributeValue(element, "alias"));
                if (keyStore.getCertificateAlias() != null) continue;
                throw new ParsingException("KeyStore Certificate element must have the alias attribute set");
            }
            if (tag.equals("PrivateKey")) {
                element = StaxParserUtil.getNextStartElement((XMLEventReader)xmlEventReader);
                keyStore.setPrivateKeyAlias(SPXmlParser.getAttributeValue(element, "alias"));
                if (keyStore.getPrivateKeyAlias() == null) {
                    throw new ParsingException("KeyStore PrivateKey element must have the alias attribute set");
                }
                keyStore.setPrivateKeyPassword(SPXmlParser.getAttributeValue(element, "password"));
                if (keyStore.getPrivateKeyPassword() != null) continue;
                throw new ParsingException("KeyStore PrivateKey element must have the password attribute set");
            }
            StaxParserUtil.bypassElementBlock((XMLEventReader)xmlEventReader, (String)tag);
        }
        return keyStore;
    }

    public boolean supports(QName qname) {
        return false;
    }
}

