/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.saml;

import java.util.Objects;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.keycloak.adapters.saml.SamlSession;
import org.keycloak.adapters.spi.SessionIdMapper;

public class IdMapperUpdaterSessionListener
implements HttpSessionListener,
HttpSessionAttributeListener {
    private final SessionIdMapper idMapper;

    public IdMapperUpdaterSessionListener(SessionIdMapper idMapper) {
        this.idMapper = idMapper;
    }

    public void sessionCreated(HttpSessionEvent hse) {
        HttpSession session = hse.getSession();
        Object value = session.getAttribute(SamlSession.class.getName());
        this.map(session.getId(), value);
    }

    public void sessionDestroyed(HttpSessionEvent hse) {
        HttpSession session = hse.getSession();
        this.unmap(session.getId(), session.getAttribute(SamlSession.class.getName()));
    }

    public void attributeAdded(HttpSessionBindingEvent hsbe) {
        HttpSession session = hsbe.getSession();
        if (Objects.equals(hsbe.getName(), SamlSession.class.getName())) {
            this.map(session.getId(), hsbe.getValue());
        }
    }

    public void attributeRemoved(HttpSessionBindingEvent hsbe) {
        HttpSession session = hsbe.getSession();
        if (Objects.equals(hsbe.getName(), SamlSession.class.getName())) {
            this.unmap(session.getId(), hsbe.getValue());
        }
    }

    public void attributeReplaced(HttpSessionBindingEvent hsbe) {
        HttpSession session = hsbe.getSession();
        if (Objects.equals(hsbe.getName(), SamlSession.class.getName())) {
            this.unmap(session.getId(), hsbe.getValue());
            this.map(session.getId(), session.getAttribute(SamlSession.class.getName()));
        }
    }

    private void map(String sessionId, Object value) {
        if (!(value instanceof SamlSession) || sessionId == null) {
            return;
        }
        SamlSession account = (SamlSession)value;
        this.idMapper.map(account.getSessionIndex(), account.getPrincipal().getSamlSubject(), sessionId);
    }

    private void unmap(String sessionId, Object value) {
        if (!(value instanceof SamlSession) || sessionId == null) {
            return;
        }
        SamlSession samlSession = (SamlSession)value;
        if (samlSession.getSessionIndex() != null) {
            this.idMapper.removeSession(sessionId);
        }
    }
}

