/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.saml.processing.core.parsers.saml;

import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import org.keycloak.dom.saml.v1.protocol.SAML11AttributeQueryType;
import org.keycloak.dom.saml.v1.protocol.SAML11QueryAbstractType;
import org.keycloak.dom.saml.v1.protocol.SAML11RequestType;
import org.keycloak.saml.common.PicketLinkLogger;
import org.keycloak.saml.common.PicketLinkLoggerFactory;
import org.keycloak.saml.common.constants.JBossSAMLConstants;
import org.keycloak.saml.common.constants.JBossSAMLURIConstants;
import org.keycloak.saml.common.exceptions.ParsingException;
import org.keycloak.saml.common.parsers.ParserNamespaceSupport;
import org.keycloak.saml.common.util.StaxParserUtil;
import org.keycloak.saml.processing.core.parsers.util.SAML11ParserUtil;
import org.keycloak.saml.processing.core.saml.v2.util.XMLTimeUtil;

public class SAML11RequestParser
implements ParserNamespaceSupport {
    private static final PicketLinkLogger logger = PicketLinkLoggerFactory.getLogger();

    protected SAML11RequestType parseRequiredAttributes(StartElement startElement) throws ParsingException {
        Attribute idAttr = startElement.getAttributeByName(new QName("RequestID"));
        if (idAttr == null) {
            throw logger.parserRequiredAttribute("RequestID");
        }
        String id = StaxParserUtil.getAttributeValue(idAttr);
        Attribute issueInstantAttr = startElement.getAttributeByName(new QName("IssueInstant"));
        if (issueInstantAttr == null) {
            throw logger.parserRequiredAttribute("IssueInstant");
        }
        XMLGregorianCalendar issueInstant = XMLTimeUtil.parse(StaxParserUtil.getAttributeValue(issueInstantAttr));
        return new SAML11RequestType(id, issueInstant);
    }

    @Override
    public Object parse(XMLEventReader xmlEventReader) throws ParsingException {
        StartElement startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
        StaxParserUtil.validate(startElement, "Request");
        SAML11RequestType request = this.parseRequiredAttributes(startElement);
        while (xmlEventReader.hasNext() && (startElement = StaxParserUtil.peekNextStartElement(xmlEventReader)) != null) {
            SAML11AttributeQueryType query;
            String elementName = StaxParserUtil.getStartElementName(startElement);
            if ("AttributeQuery".equals(elementName)) {
                startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
                query = SAML11ParserUtil.parseSAML11AttributeQuery(xmlEventReader);
                request.setQuery((SAML11QueryAbstractType)query);
                continue;
            }
            if ("AuthenticationQuery".equals(elementName)) {
                startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
                query = SAML11ParserUtil.parseSAML11AuthenticationQuery(xmlEventReader);
                request.setQuery((SAML11QueryAbstractType)query);
                continue;
            }
            if ("AssertionArtifact".equals(elementName)) {
                startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
                request.addAssertionArtifact(StaxParserUtil.getElementText(xmlEventReader));
                continue;
            }
            if ("AuthorizationDecisionQuery".equals(elementName)) {
                startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
                query = SAML11ParserUtil.parseSAML11AuthorizationDecisionQueryType(xmlEventReader);
                request.setQuery((SAML11QueryAbstractType)query);
                continue;
            }
            if (elementName.equals(JBossSAMLConstants.SIGNATURE.get())) {
                request.setSignature(StaxParserUtil.getDOMElement(xmlEventReader));
                continue;
            }
            if ("AssertionIDReference".equals(elementName)) {
                startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
                request.addAssertionIDRef(StaxParserUtil.getElementText(xmlEventReader));
                continue;
            }
            throw logger.parserUnknownStartElement(elementName, startElement.getLocation());
        }
        return request;
    }

    @Override
    public boolean supports(QName qname) {
        return JBossSAMLURIConstants.PROTOCOL_NSURI.get().equals(qname.getNamespaceURI());
    }
}

