/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.saml.config.parsers;

import java.util.HashSet;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.keycloak.adapters.saml.config.IDP;
import org.keycloak.adapters.saml.config.SP;
import org.keycloak.adapters.saml.config.parsers.IDPXmlParser;
import org.keycloak.adapters.saml.config.parsers.KeysXmlParser;
import org.keycloak.common.util.StringPropertyReplacer;
import org.keycloak.saml.common.exceptions.ParsingException;
import org.keycloak.saml.common.parsers.AbstractParser;
import org.keycloak.saml.common.util.StaxParserUtil;

public class SPXmlParser
extends AbstractParser {
    public static String getAttributeValue(StartElement startElement, String tag) {
        String str = StaxParserUtil.getAttributeValue((StartElement)startElement, (String)tag);
        if (str != null) {
            return StringPropertyReplacer.replaceProperties((String)str);
        }
        return str;
    }

    public static int getIntegerAttributeValue(StartElement startElement, String tag, int defaultValue) {
        String result = SPXmlParser.getAttributeValue(startElement, tag);
        if (result == null) {
            return defaultValue;
        }
        return Integer.valueOf(result);
    }

    public static boolean getBooleanAttributeValue(StartElement startElement, String tag, boolean defaultValue) {
        String result = SPXmlParser.getAttributeValue(startElement, tag);
        if (result == null) {
            return defaultValue;
        }
        return Boolean.valueOf(result);
    }

    public static boolean getBooleanAttributeValue(StartElement startElement, String tag) {
        return SPXmlParser.getBooleanAttributeValue(startElement, tag, false);
    }

    public static String getElementText(XMLEventReader xmlEventReader) throws ParsingException {
        String result = StaxParserUtil.getElementText((XMLEventReader)xmlEventReader);
        if (result != null) {
            result = StringPropertyReplacer.replaceProperties((String)result);
        }
        return result;
    }

    public Object parse(XMLEventReader xmlEventReader) throws ParsingException {
        XMLEvent xmlEvent;
        StartElement startElement = StaxParserUtil.getNextStartElement((XMLEventReader)xmlEventReader);
        StaxParserUtil.validate((StartElement)startElement, (String)"SP");
        SP sp = new SP();
        String entityID = SPXmlParser.getAttributeValue(startElement, "entityID");
        if (entityID == null) {
            throw new ParsingException("entityID must be set on SP");
        }
        sp.setEntityID(entityID);
        sp.setSslPolicy(SPXmlParser.getAttributeValue(startElement, "sslPolicy"));
        sp.setLogoutPage(SPXmlParser.getAttributeValue(startElement, "logoutPage"));
        sp.setNameIDPolicyFormat(SPXmlParser.getAttributeValue(startElement, "nameIDPolicyFormat"));
        sp.setForceAuthentication(SPXmlParser.getBooleanAttributeValue(startElement, "forceAuthentication"));
        sp.setIsPassive(SPXmlParser.getBooleanAttributeValue(startElement, "isPassive"));
        sp.setAutodetectBearerOnly(SPXmlParser.getBooleanAttributeValue(startElement, "autodetectBearerOnly"));
        sp.setTurnOffChangeSessionIdOnLogin(SPXmlParser.getBooleanAttributeValue(startElement, "turnOffChangeSessionIdOnLogin"));
        while (xmlEventReader.hasNext() && (xmlEvent = StaxParserUtil.peek((XMLEventReader)xmlEventReader)) != null) {
            AbstractParser parser;
            if (xmlEvent instanceof EndElement) {
                EndElement endElement = (EndElement)StaxParserUtil.getNextEvent((XMLEventReader)xmlEventReader);
                String endElementName = StaxParserUtil.getEndElementName((EndElement)endElement);
                if (!endElementName.equals("SP")) continue;
                break;
            }
            startElement = StaxParserUtil.peekNextStartElement((XMLEventReader)xmlEventReader);
            if (startElement == null) break;
            String tag = StaxParserUtil.getStartElementName((StartElement)startElement);
            if (tag.equals("Keys")) {
                parser = new KeysXmlParser();
                List keys = (List)parser.parse(xmlEventReader);
                sp.setKeys(keys);
                continue;
            }
            if (tag.equals("PrincipalNameMapping")) {
                StartElement element = StaxParserUtil.getNextStartElement((XMLEventReader)xmlEventReader);
                String policy = SPXmlParser.getAttributeValue(element, "policy");
                if (policy == null) {
                    throw new ParsingException("PrincipalNameMapping element must have the policy attribute set");
                }
                String attribute = SPXmlParser.getAttributeValue(element, "attribute");
                SP.PrincipalNameMapping mapping = new SP.PrincipalNameMapping();
                mapping.setPolicy(policy);
                mapping.setAttributeName(attribute);
                sp.setPrincipalNameMapping(mapping);
                continue;
            }
            if (tag.equals("RoleIdentifiers")) {
                this.parseRoleMapping(xmlEventReader, sp);
                continue;
            }
            if (tag.equals("IDP")) {
                parser = new IDPXmlParser();
                IDP idp = (IDP)parser.parse(xmlEventReader);
                sp.setIdp(idp);
                continue;
            }
            StaxParserUtil.bypassElementBlock((XMLEventReader)xmlEventReader, (String)tag);
        }
        return sp;
    }

    protected void parseRoleMapping(XMLEventReader xmlEventReader, SP sp) throws ParsingException {
        XMLEvent xmlEvent;
        StartElement startElement = StaxParserUtil.getNextStartElement((XMLEventReader)xmlEventReader);
        StaxParserUtil.validate((StartElement)startElement, (String)"RoleIdentifiers");
        HashSet<String> roleAttributes = new HashSet<String>();
        while (xmlEventReader.hasNext() && (xmlEvent = StaxParserUtil.peek((XMLEventReader)xmlEventReader)) != null) {
            if (xmlEvent instanceof EndElement) {
                EndElement endElement = (EndElement)StaxParserUtil.getNextEvent((XMLEventReader)xmlEventReader);
                String endElementName = StaxParserUtil.getEndElementName((EndElement)endElement);
                if (!endElementName.equals("RoleIdentifiers")) continue;
                break;
            }
            startElement = StaxParserUtil.peekNextStartElement((XMLEventReader)xmlEventReader);
            if (startElement == null) break;
            String tag = StaxParserUtil.getStartElementName((StartElement)startElement);
            if (tag.equals("Attribute")) {
                StartElement element = StaxParserUtil.getNextStartElement((XMLEventReader)xmlEventReader);
                String attributeValue = SPXmlParser.getAttributeValue(element, "name");
                if (attributeValue == null) {
                    throw new ParsingException("RoleMapping Attribute element must have the name attribute set");
                }
                roleAttributes.add(attributeValue);
                continue;
            }
            StaxParserUtil.bypassElementBlock((XMLEventReader)xmlEventReader, (String)tag);
        }
        sp.setRoleAttributes(roleAttributes);
    }

    public boolean supports(QName qname) {
        return false;
    }
}

