/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.saml.common.parsers;

import java.io.InputStream;
import javax.xml.stream.EventFilter;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.XMLEvent;
import javax.xml.stream.util.EventReaderDelegate;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.keycloak.common.util.Environment;
import org.keycloak.saml.common.PicketLinkLogger;
import org.keycloak.saml.common.PicketLinkLoggerFactory;
import org.keycloak.saml.common.exceptions.ParsingException;
import org.keycloak.saml.common.parsers.ParserNamespaceSupport;
import org.keycloak.saml.common.util.SecurityActions;
import org.keycloak.saml.common.util.StaxParserUtil;
import org.keycloak.saml.common.util.SystemPropertiesUtil;
import org.w3c.dom.Node;

public abstract class AbstractParser
implements ParserNamespaceSupport {
    protected static final PicketLinkLogger logger = PicketLinkLoggerFactory.getLogger();
    private static final ThreadLocal<XMLInputFactory> XML_INPUT_FACTORY = new ThreadLocal<XMLInputFactory>(){

        @Override
        protected XMLInputFactory initialValue() {
            return this.getXMLInputFactory();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private XMLInputFactory getXMLInputFactory() {
            boolean tccl_jaxp = SystemPropertiesUtil.getSystemProperty("picketlink.jaxp.tccl", "false").equalsIgnoreCase("true");
            ClassLoader prevTCCL = SecurityActions.getTCCL();
            try {
                if (tccl_jaxp) {
                    SecurityActions.setTCCL(AbstractParser.class.getClassLoader());
                }
                XMLInputFactory xMLInputFactory = XMLInputFactory.newInstance();
                return xMLInputFactory;
            }
            finally {
                if (tccl_jaxp) {
                    SecurityActions.setTCCL(prevTCCL);
                }
            }
        }
    };

    public Object parse(InputStream configStream) throws ParsingException {
        XMLEventReader xmlEventReader = this.createEventReader(configStream);
        return this.parse(xmlEventReader);
    }

    public Object parse(Source source) throws ParsingException {
        XMLEventReader xmlEventReader = this.createEventReader(source);
        return this.parse(xmlEventReader);
    }

    public Object parse(Node node) throws ParsingException {
        return this.parse(new DOMSource(node));
    }

    public XMLEventReader createEventReader(InputStream configStream) throws ParsingException {
        if (configStream == null) {
            throw logger.nullArgumentError("InputStream");
        }
        XMLEventReader xmlEventReader = StaxParserUtil.getXMLEventReader(configStream);
        try {
            xmlEventReader = this.filterWhitespaces(xmlEventReader);
        }
        catch (XMLStreamException e) {
            throw logger.parserException(e);
        }
        return xmlEventReader;
    }

    public XMLEventReader createEventReader(Source source) throws ParsingException {
        if (source == null) {
            throw logger.nullArgumentError("Source");
        }
        XMLEventReader xmlEventReader = StaxParserUtil.getXMLEventReader(source);
        try {
            xmlEventReader = this.filterWhitespaces(xmlEventReader);
        }
        catch (XMLStreamException e) {
            throw logger.parserException(e);
        }
        return xmlEventReader;
    }

    protected XMLEventReader filterWhitespaces(XMLEventReader xmlEventReader) throws XMLStreamException {
        XMLInputFactory xmlInputFactory = XML_INPUT_FACTORY.get();
        xmlEventReader = xmlInputFactory.createFilteredReader(xmlEventReader, new EventFilter(){

            @Override
            public boolean accept(XMLEvent xmlEvent) {
                if (xmlEvent.isCharacters()) {
                    Characters chars = xmlEvent.asCharacters();
                    String data = chars.getData();
                    data = this.valid(data) ? data.trim() : null;
                    return this.valid(data);
                }
                return xmlEvent.isStartElement() || xmlEvent.isEndElement();
            }

            private boolean valid(String str) {
                return str != null && !str.isEmpty();
            }
        });
        if (Environment.IS_IBM_JAVA) {
            final XMLEventReader origReader = xmlEventReader;
            xmlEventReader = new EventReaderDelegate(origReader){

                @Override
                public boolean hasNext() {
                    boolean hasNext = super.hasNext();
                    try {
                        return hasNext && origReader.peek() != null;
                    }
                    catch (XMLStreamException xse) {
                        throw new IllegalStateException(xse);
                    }
                }
            };
        }
        return xmlEventReader;
    }
}

