/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.saml;

import java.io.Serializable;
import java.net.URI;
import java.security.Principal;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.keycloak.common.util.MultivaluedHashMap;
import org.keycloak.dom.saml.v2.assertion.AssertionType;
import org.keycloak.dom.saml.v2.assertion.NameIDType;

public class SamlPrincipal
implements Serializable,
Principal {
    public static final String DEFAULT_ROLE_ATTRIBUTE_NAME = "Roles";
    private MultivaluedHashMap<String, String> attributes = new MultivaluedHashMap();
    private MultivaluedHashMap<String, String> friendlyAttributes = new MultivaluedHashMap();
    private String name;
    private String samlSubject;
    private String nameIDFormat;
    private AssertionType assertion;

    public SamlPrincipal(AssertionType assertion, String name, String samlSubject, String nameIDFormat, MultivaluedHashMap<String, String> attributes, MultivaluedHashMap<String, String> friendlyAttributes) {
        this.name = name;
        this.attributes = attributes;
        this.friendlyAttributes = friendlyAttributes;
        this.samlSubject = samlSubject;
        this.nameIDFormat = nameIDFormat;
        this.assertion = assertion;
    }

    public SamlPrincipal() {
    }

    public AssertionType getAssertion() {
        return this.assertion;
    }

    public String getSamlSubject() {
        return this.samlSubject;
    }

    public String getNameIDFormat() {
        return this.nameIDFormat;
    }

    public NameIDType getNameID() {
        if (this.assertion != null && this.assertion.getSubject() != null && this.assertion.getSubject().getSubType() != null && this.assertion.getSubject().getSubType().getBaseID() instanceof NameIDType) {
            return (NameIDType)this.assertion.getSubject().getSubType().getBaseID();
        }
        NameIDType res = new NameIDType();
        res.setValue(this.getSamlSubject());
        if (this.getNameIDFormat() != null) {
            res.setFormat(URI.create(this.getNameIDFormat()));
        }
        return res;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public List<String> getAttributes(String name) {
        List list = (List)this.attributes.get((Object)name);
        if (list != null) {
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    public Map<String, List<String>> getAttributes() {
        return Collections.unmodifiableMap(this.attributes);
    }

    public List<String> getFriendlyAttributes(String friendlyName) {
        List list = (List)this.friendlyAttributes.get((Object)friendlyName);
        if (list != null) {
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    public String getAttribute(String name) {
        return (String)this.attributes.getFirst((Object)name);
    }

    public String getFriendlyAttribute(String friendlyName) {
        return (String)this.friendlyAttributes.getFirst((Object)friendlyName);
    }

    public Set<String> getAttributeNames() {
        return Collections.unmodifiableSet(this.attributes.keySet());
    }

    public Set<String> getFriendlyNames() {
        return Collections.unmodifiableSet(this.friendlyAttributes.keySet());
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SamlPrincipal)) {
            return false;
        }
        SamlPrincipal otherPrincipal = (SamlPrincipal)other;
        return (this.name != null ? this.name.equals(otherPrincipal.name) : otherPrincipal.name == null) && (this.samlSubject != null ? this.samlSubject.equals(otherPrincipal.samlSubject) : otherPrincipal.samlSubject == null) && (this.nameIDFormat != null ? this.nameIDFormat.equals(otherPrincipal.nameIDFormat) : otherPrincipal.nameIDFormat == null) && (this.attributes != null ? this.attributes.equals(otherPrincipal.attributes) : otherPrincipal.attributes == null) && (this.friendlyAttributes != null ? this.friendlyAttributes.equals(otherPrincipal.friendlyAttributes) : otherPrincipal.friendlyAttributes == null);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.samlSubject == null ? 0 : this.samlSubject.hashCode());
        result = 31 * result + (this.nameIDFormat == null ? 0 : this.nameIDFormat.hashCode());
        result = 31 * result + (this.attributes == null ? 0 : this.attributes.hashCode());
        result = 31 * result + (this.friendlyAttributes == null ? 0 : this.friendlyAttributes.hashCode());
        return result;
    }
}

