/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.subsystem.saml.as7;

import java.util.HashMap;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ObjectTypeAttributeDefinition;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ReloadRequiredRemoveStepHandler;
import org.jboss.as.controller.ReloadRequiredWriteAttributeHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.common.GenericSubsystemDescribeHandler;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.dmr.ModelType;
import org.keycloak.subsystem.saml.as7.AllowedClockSkew;
import org.keycloak.subsystem.saml.as7.IdentityProviderAddHandler;
import org.keycloak.subsystem.saml.as7.KeycloakSamlExtension;
import org.keycloak.subsystem.saml.as7.SingleLogoutDefinition;
import org.keycloak.subsystem.saml.as7.SingleSignOnDefinition;

public class IdentityProviderDefinition
extends SimpleResourceDefinition {
    static final SimpleAttributeDefinition SIGNATURES_REQUIRED = new SimpleAttributeDefinitionBuilder("signaturesRequired", ModelType.BOOLEAN, true).setXmlName("signaturesRequired").build();
    static final SimpleAttributeDefinition SIGNATURE_ALGORITHM = new SimpleAttributeDefinitionBuilder("signatureAlgorithm", ModelType.STRING, true).setXmlName("signatureAlgorithm").build();
    static final SimpleAttributeDefinition SIGNATURE_CANONICALIZATION_METHOD = new SimpleAttributeDefinitionBuilder("signatureCanonicalizationMethod", ModelType.STRING, true).setXmlName("signatureCanonicalizationMethod").build();
    static final ObjectTypeAttributeDefinition SINGLE_SIGN_ON = ObjectTypeAttributeDefinition.Builder.of((String)"SingleSignOnService", (AttributeDefinition[])SingleSignOnDefinition.ATTRIBUTES).setAllowNull(false).build();
    static final ObjectTypeAttributeDefinition SINGLE_LOGOUT = ObjectTypeAttributeDefinition.Builder.of((String)"SingleLogoutService", (AttributeDefinition[])SingleLogoutDefinition.ATTRIBUTES).setAllowNull(false).build();
    static final ObjectTypeAttributeDefinition ALLOWED_CLOCK_SKEW = ObjectTypeAttributeDefinition.Builder.of((String)"AllowedClockSkew", (AttributeDefinition[])AllowedClockSkew.ATTRIBUTES).setAllowNull(true).build();
    static final SimpleAttributeDefinition[] ATTRIBUTES = new SimpleAttributeDefinition[]{SIGNATURES_REQUIRED, SIGNATURE_ALGORITHM, SIGNATURE_CANONICALIZATION_METHOD};
    static final SimpleAttributeDefinition[] ALL_ATTRIBUTES = new SimpleAttributeDefinition[]{SIGNATURES_REQUIRED, SIGNATURE_ALGORITHM, SIGNATURE_CANONICALIZATION_METHOD, SINGLE_SIGN_ON, SINGLE_LOGOUT, ALLOWED_CLOCK_SKEW};
    static final HashMap<String, SimpleAttributeDefinition> ATTRIBUTE_MAP = new HashMap();
    static final IdentityProviderDefinition INSTANCE;

    private IdentityProviderDefinition() {
        super(PathElement.pathElement((String)"IDP"), (ResourceDescriptionResolver)KeycloakSamlExtension.getResourceDescriptionResolver("IDP"), (OperationStepHandler)new IdentityProviderAddHandler(), (OperationStepHandler)ReloadRequiredRemoveStepHandler.INSTANCE);
    }

    public void registerOperations(ManagementResourceRegistration resourceRegistration) {
        super.registerOperations(resourceRegistration);
        resourceRegistration.registerOperationHandler((OperationDefinition)GenericSubsystemDescribeHandler.DEFINITION, (OperationStepHandler)GenericSubsystemDescribeHandler.INSTANCE);
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        super.registerAttributes(resourceRegistration);
        ReloadRequiredWriteAttributeHandler writeHandler = new ReloadRequiredWriteAttributeHandler((AttributeDefinition[])ALL_ATTRIBUTES);
        for (SimpleAttributeDefinition attribute : ALL_ATTRIBUTES) {
            resourceRegistration.registerReadWriteAttribute((AttributeDefinition)attribute, null, (OperationStepHandler)writeHandler);
        }
    }

    static SimpleAttributeDefinition lookup(String xmlName) {
        return ATTRIBUTE_MAP.get(xmlName);
    }

    static {
        for (SimpleAttributeDefinition def : ALL_ATTRIBUTES) {
            ATTRIBUTE_MAP.put(def.getXmlName(), def);
        }
        INSTANCE = new IdentityProviderDefinition();
    }
}

