/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.saml.processing.core.parsers.saml.metadata;

import java.util.List;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.StartElement;
import org.keycloak.dom.saml.v2.metadata.AttributeConsumingServiceType;
import org.keycloak.dom.saml.v2.metadata.IndexedEndpointType;
import org.keycloak.dom.saml.v2.metadata.RoleDescriptorType;
import org.keycloak.dom.saml.v2.metadata.SPSSODescriptorType;
import org.keycloak.saml.common.exceptions.ParsingException;
import org.keycloak.saml.common.util.StaxParserUtil;
import org.keycloak.saml.processing.core.parsers.saml.metadata.SAMLAssertionConsumerServiceParser;
import org.keycloak.saml.processing.core.parsers.saml.metadata.SAMLAttributeConsumingServiceParser;
import org.keycloak.saml.processing.core.parsers.saml.metadata.SAMLMetadataQNames;
import org.keycloak.saml.processing.core.parsers.saml.metadata.SAMLSSODescriptorTypeParser;

public class SAMLSPSSODescriptorParser
extends SAMLSSODescriptorTypeParser<SPSSODescriptorType> {
    private static final SAMLSPSSODescriptorParser INSTANCE = new SAMLSPSSODescriptorParser();

    private SAMLSPSSODescriptorParser() {
        super(SAMLMetadataQNames.SP_SSO_DESCRIPTOR);
    }

    public static SAMLSPSSODescriptorParser getInstance() {
        return INSTANCE;
    }

    @Override
    protected SPSSODescriptorType instantiateElement(XMLEventReader xmlEventReader, StartElement element) throws ParsingException {
        Boolean wantAssertionSigned;
        List<String> protocolEnum = StaxParserUtil.getRequiredStringListAttributeValue(element, SAMLMetadataQNames.ATTR_PROTOCOL_SUPPORT_ENUMERATION);
        SPSSODescriptorType descriptor = new SPSSODescriptorType(protocolEnum);
        this.parseOptionalArguments(element, (RoleDescriptorType)descriptor);
        Boolean authnRequestsSigned = StaxParserUtil.getBooleanAttributeValue(element, SAMLMetadataQNames.ATTR_AUTHN_REQUESTS_SIGNED);
        if (authnRequestsSigned != null) {
            descriptor.setAuthnRequestsSigned(authnRequestsSigned);
        }
        if ((wantAssertionSigned = StaxParserUtil.getBooleanAttributeValue(element, SAMLMetadataQNames.ATTR_WANT_ASSERTIONS_SIGNED)) != null) {
            descriptor.setWantAssertionsSigned(wantAssertionSigned);
        }
        return descriptor;
    }

    @Override
    protected void processSubElement(XMLEventReader xmlEventReader, SPSSODescriptorType target, SAMLMetadataQNames element, StartElement elementDetail) throws ParsingException {
        switch (element) {
            case ASSERTION_CONSUMER_SERVICE: {
                target.addAssertionConsumerService((IndexedEndpointType)SAMLAssertionConsumerServiceParser.getInstance().parse(xmlEventReader));
                break;
            }
            case ATTRIBUTE_CONSUMING_SERVICE: {
                target.addAttributeConsumerService((AttributeConsumingServiceType)SAMLAttributeConsumingServiceParser.getInstance().parse(xmlEventReader));
                break;
            }
            default: {
                super.processSubElement(xmlEventReader, target, element, elementDetail);
            }
        }
    }
}

