/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.saml;

import java.net.URI;
import java.util.LinkedList;
import java.util.List;
import org.keycloak.dom.saml.v2.assertion.NameIDType;
import org.keycloak.dom.saml.v2.protocol.ArtifactResolveType;
import org.keycloak.dom.saml.v2.protocol.ExtensionsType;
import org.keycloak.dom.saml.v2.protocol.RequestAbstractType;
import org.keycloak.saml.SAML2NameIDBuilder;
import org.keycloak.saml.SamlProtocolExtensionsAwareBuilder;
import org.keycloak.saml.common.exceptions.ConfigurationException;
import org.keycloak.saml.common.exceptions.ParsingException;
import org.keycloak.saml.common.exceptions.ProcessingException;
import org.keycloak.saml.processing.api.saml.v2.request.SAML2Request;
import org.w3c.dom.Document;

public class SAML2ArtifactResolveRequestBuilder
implements SamlProtocolExtensionsAwareBuilder<SAML2ArtifactResolveRequestBuilder> {
    protected String artifact;
    protected String destination;
    protected NameIDType issuer;
    protected final List<SamlProtocolExtensionsAwareBuilder.NodeGenerator> extensions = new LinkedList<SamlProtocolExtensionsAwareBuilder.NodeGenerator>();

    public SAML2ArtifactResolveRequestBuilder artifact(String artifact) {
        this.artifact = artifact;
        return this;
    }

    public SAML2ArtifactResolveRequestBuilder destination(String destination) {
        this.destination = destination;
        return this;
    }

    public SAML2ArtifactResolveRequestBuilder issuer(NameIDType issuer) {
        this.issuer = issuer;
        return this;
    }

    public SAML2ArtifactResolveRequestBuilder issuer(String issuer) {
        return this.issuer(SAML2NameIDBuilder.value(issuer).build());
    }

    @Override
    public SAML2ArtifactResolveRequestBuilder addExtension(SamlProtocolExtensionsAwareBuilder.NodeGenerator extension) {
        this.extensions.add(extension);
        return this;
    }

    public Document buildDocument() throws ProcessingException, ConfigurationException, ParsingException {
        Document document = SAML2Request.convert((RequestAbstractType)this.createArtifactResolveRequest());
        return document;
    }

    public ArtifactResolveType createArtifactResolveRequest() throws ConfigurationException {
        ArtifactResolveType lort = SAML2Request.createArtifactResolveRequest(this.issuer);
        lort.setIssuer(this.issuer);
        if (this.destination != null) {
            lort.setDestination(URI.create(this.destination));
        }
        if (this.artifact != null) {
            lort.setArtifact(this.artifact);
        }
        if (!this.extensions.isEmpty()) {
            ExtensionsType extensionsType = new ExtensionsType();
            for (SamlProtocolExtensionsAwareBuilder.NodeGenerator extension : this.extensions) {
                extensionsType.addExtension((Object)extension);
            }
            lort.setExtensions(extensionsType);
        }
        return lort;
    }
}

