/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.saml.processing.core.parsers.saml.protocol;

import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.StartElement;
import org.keycloak.dom.saml.v2.assertion.AttributeType;
import org.keycloak.dom.saml.v2.assertion.SubjectType;
import org.keycloak.dom.saml.v2.protocol.AttributeQueryType;
import org.keycloak.dom.saml.v2.protocol.RequestAbstractType;
import org.keycloak.saml.common.exceptions.ParsingException;
import org.keycloak.saml.common.parsers.StaxParser;
import org.keycloak.saml.common.util.StaxParserUtil;
import org.keycloak.saml.processing.core.parsers.saml.assertion.SAMLAttributeParser;
import org.keycloak.saml.processing.core.parsers.saml.assertion.SAMLSubjectParser;
import org.keycloak.saml.processing.core.parsers.saml.protocol.SAMLProtocolQNames;
import org.keycloak.saml.processing.core.parsers.saml.protocol.SAMLRequestAbstractParser;
import org.keycloak.saml.processing.core.parsers.util.SAMLParserUtil;
import org.keycloak.saml.processing.core.saml.v2.util.XMLTimeUtil;

public class SAMLAttributeQueryParser
extends SAMLRequestAbstractParser<AttributeQueryType>
implements StaxParser {
    private static final SAMLAttributeQueryParser INSTANCE = new SAMLAttributeQueryParser();

    private SAMLAttributeQueryParser() {
        super(SAMLProtocolQNames.ATTRIBUTE_QUERY);
    }

    public static SAMLAttributeQueryParser getInstance() {
        return INSTANCE;
    }

    @Override
    protected AttributeQueryType instantiateElement(XMLEventReader xmlEventReader, StartElement element) throws ParsingException {
        SAMLParserUtil.validateAttributeValue(element, SAMLProtocolQNames.ATTR_VERSION, "2.0");
        String id = StaxParserUtil.getRequiredAttributeValue(element, SAMLProtocolQNames.ATTR_ID);
        XMLGregorianCalendar issueInstant = XMLTimeUtil.parse(StaxParserUtil.getRequiredAttributeValue(element, SAMLProtocolQNames.ATTR_ISSUE_INSTANT));
        AttributeQueryType authnRequest = new AttributeQueryType(id, issueInstant);
        super.parseBaseAttributes(element, authnRequest);
        return authnRequest;
    }

    @Override
    protected void processSubElement(XMLEventReader xmlEventReader, AttributeQueryType target, SAMLProtocolQNames element, StartElement elementDetail) throws ParsingException {
        switch (element) {
            case ISSUER: 
            case SIGNATURE: 
            case EXTENSIONS: {
                this.parseCommonElements(element, elementDetail, xmlEventReader, (RequestAbstractType)target);
                break;
            }
            case SUBJECT: {
                target.setSubject((SubjectType)SAMLSubjectParser.getInstance().parse(xmlEventReader));
                break;
            }
            case ATTRIBUTE: {
                target.add((AttributeType)SAMLAttributeParser.getInstance().parse(xmlEventReader));
                break;
            }
            default: {
                throw LOGGER.parserUnknownTag(StaxParserUtil.getElementName(elementDetail), elementDetail.getLocation());
            }
        }
    }
}

