/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.cloned;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.util.EntityUtils;
import org.keycloak.adapters.cloned.HttpClientAdapterException;
import org.keycloak.adapters.saml.descriptor.parsers.SamlDescriptorIDPKeysExtractor;
import org.keycloak.common.util.MultivaluedHashMap;
import org.keycloak.saml.common.exceptions.ParsingException;

public class HttpAdapterUtils {
    public static MultivaluedHashMap<String, KeyInfo> downloadKeysFromSamlDescriptor(HttpClient client, String descriptorUrl) throws HttpClientAdapterException {
        try {
            MultivaluedHashMap<String, KeyInfo> res;
            HttpGet httpRequest = new HttpGet(descriptorUrl);
            HttpResponse response = client.execute((HttpUriRequest)httpRequest);
            int status = response.getStatusLine().getStatusCode();
            if (status != 200) {
                EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                throw new HttpClientAdapterException("Unexpected status = " + status);
            }
            HttpEntity entity = response.getEntity();
            if (entity == null) {
                throw new HttpClientAdapterException("There was no entity.");
            }
            try (InputStream is = entity.getContent();){
                res = HttpAdapterUtils.extractKeysFromSamlDescriptor(is);
            }
            EntityUtils.consumeQuietly((HttpEntity)entity);
            return res;
        }
        catch (IOException | ParsingException e) {
            throw new HttpClientAdapterException("IO error", e);
        }
    }

    public static MultivaluedHashMap<String, KeyInfo> extractKeysFromSamlDescriptor(InputStream xmlStream) throws ParsingException {
        MultivaluedHashMap<String, KeyInfo> res = new SamlDescriptorIDPKeysExtractor().parse(xmlStream);
        return res;
    }
}

