/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.saml.processing.core.parsers.util;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.keycloak.dom.saml.v2.assertion.AttributeStatementType;
import org.keycloak.dom.saml.v2.assertion.AttributeType;
import org.keycloak.dom.saml.v2.assertion.AuthnContextClassRefType;
import org.keycloak.dom.saml.v2.assertion.AuthnContextDeclRefType;
import org.keycloak.dom.saml.v2.assertion.AuthnContextDeclType;
import org.keycloak.dom.saml.v2.assertion.AuthnContextType;
import org.keycloak.dom.saml.v2.assertion.AuthnStatementType;
import org.keycloak.dom.saml.v2.assertion.NameIDType;
import org.keycloak.dom.saml.v2.assertion.SubjectLocalityType;
import org.keycloak.dom.saml.v2.assertion.URIType;
import org.keycloak.dom.xmlsec.w3.xmldsig.DSAKeyValueType;
import org.keycloak.dom.xmlsec.w3.xmldsig.KeyInfoType;
import org.keycloak.dom.xmlsec.w3.xmldsig.RSAKeyValueType;
import org.keycloak.dom.xmlsec.w3.xmldsig.X509CertificateType;
import org.keycloak.dom.xmlsec.w3.xmldsig.X509DataType;
import org.keycloak.saml.common.PicketLinkLogger;
import org.keycloak.saml.common.PicketLinkLoggerFactory;
import org.keycloak.saml.common.constants.JBossSAMLConstants;
import org.keycloak.saml.common.constants.JBossSAMLURIConstants;
import org.keycloak.saml.common.exceptions.ParsingException;
import org.keycloak.saml.common.util.StaxParserUtil;
import org.keycloak.saml.common.util.StringUtil;
import org.keycloak.saml.processing.core.saml.v2.util.SignatureUtil;
import org.keycloak.saml.processing.core.saml.v2.util.XMLTimeUtil;
import org.w3c.dom.Element;

public class SAMLParserUtil {
    private static final PicketLinkLogger logger = PicketLinkLoggerFactory.getLogger();

    public static KeyInfoType parseKeyInfo(XMLEventReader xmlEventReader) throws ParsingException {
        KeyInfoType keyInfo = new KeyInfoType();
        StartElement startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
        StaxParserUtil.validate(startElement, "KeyInfo");
        XMLEvent xmlEvent = null;
        String tag = null;
        while (xmlEventReader.hasNext()) {
            xmlEvent = StaxParserUtil.peek(xmlEventReader);
            if (xmlEvent instanceof EndElement) {
                tag = StaxParserUtil.getEndElementName((EndElement)xmlEvent);
                if (tag.equals("KeyInfo")) {
                    xmlEvent = StaxParserUtil.getNextEndElement(xmlEventReader);
                    break;
                }
                throw logger.parserUnknownEndElement(tag);
            }
            startElement = (StartElement)xmlEvent;
            tag = StaxParserUtil.getStartElementName(startElement);
            if (tag.equals("EncryptedKey")) {
                keyInfo.addContent((Object)StaxParserUtil.getDOMElement(xmlEventReader));
                continue;
            }
            if (tag.equals("X509Data")) {
                startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
                X509DataType x509 = new X509DataType();
                startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
                StaxParserUtil.validate(startElement, "X509Certificate");
                X509CertificateType cert = new X509CertificateType();
                String certValue = StaxParserUtil.getElementText(xmlEventReader);
                cert.setEncodedCertificate(certValue.getBytes());
                x509.add((Object)cert);
                EndElement endElement = StaxParserUtil.getNextEndElement(xmlEventReader);
                StaxParserUtil.validate(endElement, "X509Data");
                keyInfo.addContent((Object)x509);
                continue;
            }
            if (!tag.equals("KeyValue")) continue;
            startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
            RSAKeyValueType keyValue = null;
            startElement = StaxParserUtil.peekNextStartElement(xmlEventReader);
            tag = StaxParserUtil.getStartElementName(startElement);
            if (tag.equals("RSAKeyValue")) {
                keyValue = SAMLParserUtil.parseRSAKeyValue(xmlEventReader);
            } else if (tag.equals("DSAKeyValue")) {
                keyValue = SAMLParserUtil.parseDSAKeyValue(xmlEventReader);
            } else {
                throw logger.parserUnknownTag(tag, startElement.getLocation());
            }
            EndElement endElement = StaxParserUtil.getNextEndElement(xmlEventReader);
            StaxParserUtil.validate(endElement, "KeyValue");
            keyInfo.addContent((Object)keyValue);
        }
        return keyInfo;
    }

    private static RSAKeyValueType parseRSAKeyValue(XMLEventReader xmlEventReader) throws ParsingException {
        StartElement startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
        StaxParserUtil.validate(startElement, "RSAKeyValue");
        XMLEvent xmlEvent = null;
        String tag = null;
        RSAKeyValueType rsaKeyValue = new RSAKeyValueType();
        while (xmlEventReader.hasNext()) {
            String text;
            xmlEvent = StaxParserUtil.peek(xmlEventReader);
            if (xmlEvent instanceof EndElement) {
                tag = StaxParserUtil.getEndElementName((EndElement)xmlEvent);
                if (tag.equals("RSAKeyValue")) {
                    xmlEvent = StaxParserUtil.getNextEndElement(xmlEventReader);
                    break;
                }
                throw logger.parserUnknownEndElement(tag);
            }
            startElement = (StartElement)xmlEvent;
            tag = StaxParserUtil.getStartElementName(startElement);
            if (tag.equals("Modulus")) {
                startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
                text = StaxParserUtil.getElementText(xmlEventReader);
                rsaKeyValue.setModulus(text.getBytes());
                continue;
            }
            if (tag.equals("Exponent")) {
                startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
                text = StaxParserUtil.getElementText(xmlEventReader);
                rsaKeyValue.setExponent(text.getBytes());
                continue;
            }
            throw logger.parserUnknownTag(tag, startElement.getLocation());
        }
        return rsaKeyValue;
    }

    private static DSAKeyValueType parseDSAKeyValue(XMLEventReader xmlEventReader) throws ParsingException {
        StartElement startElement = StaxParserUtil.peekNextStartElement(xmlEventReader);
        StaxParserUtil.validate(startElement, "DSAKeyValue");
        Element dsaElement = StaxParserUtil.getDOMElement(xmlEventReader);
        return SignatureUtil.getDSAKeyValue(dsaElement);
    }

    public static AttributeStatementType parseAttributeStatement(XMLEventReader xmlEventReader) throws ParsingException {
        AttributeStatementType attributeStatementType = new AttributeStatementType();
        StartElement startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
        String ATTRIBSTATEMT = JBossSAMLConstants.ATTRIBUTE_STATEMENT.get();
        StaxParserUtil.validate(startElement, ATTRIBSTATEMT);
        while (xmlEventReader.hasNext()) {
            XMLEvent xmlEvent = StaxParserUtil.peek(xmlEventReader);
            if (xmlEvent instanceof EndElement) {
                EndElement endElement = StaxParserUtil.getNextEndElement(xmlEventReader);
                StaxParserUtil.validate(endElement, JBossSAMLConstants.ATTRIBUTE_STATEMENT.get());
                break;
            }
            startElement = StaxParserUtil.peekNextStartElement(xmlEventReader);
            String tag = startElement.getName().getLocalPart();
            if (JBossSAMLConstants.ATTRIBUTE.get().equals(tag)) {
                AttributeType attribute = SAMLParserUtil.parseAttribute(xmlEventReader);
                attributeStatementType.addAttribute(new AttributeStatementType.ASTChoiceType(attribute));
                continue;
            }
            throw logger.parserUnknownTag(tag, startElement.getLocation());
        }
        return attributeStatementType;
    }

    public static AttributeType parseAttribute(XMLEventReader xmlEventReader) throws ParsingException {
        StartElement startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
        StaxParserUtil.validate(startElement, JBossSAMLConstants.ATTRIBUTE.get());
        AttributeType attributeType = null;
        Attribute name = startElement.getAttributeByName(new QName(JBossSAMLConstants.NAME.get()));
        if (name == null) {
            throw logger.parserRequiredAttribute("Name");
        }
        attributeType = new AttributeType(StaxParserUtil.getAttributeValue(name));
        SAMLParserUtil.parseAttributeType(xmlEventReader, startElement, JBossSAMLConstants.ATTRIBUTE.get(), attributeType);
        return attributeType;
    }

    public static void parseAttributeType(XMLEventReader xmlEventReader, StartElement startElement, String rootTag, AttributeType attributeType) throws ParsingException {
        EndElement end;
        XMLEvent xmlEvent;
        Attribute nameFormat;
        Attribute friendlyName;
        QName x500EncodingName = new QName(JBossSAMLURIConstants.X500_NSURI.get(), JBossSAMLConstants.ENCODING.get(), JBossSAMLURIConstants.X500_PREFIX.get());
        Attribute x500EncodingAttr = startElement.getAttributeByName(x500EncodingName);
        if (x500EncodingAttr != null) {
            attributeType.getOtherAttributes().put(x500EncodingAttr.getName(), StaxParserUtil.getAttributeValue(x500EncodingAttr));
        }
        if ((friendlyName = startElement.getAttributeByName(new QName(JBossSAMLConstants.FRIENDLY_NAME.get()))) != null) {
            attributeType.setFriendlyName(StaxParserUtil.getAttributeValue(friendlyName));
        }
        if ((nameFormat = startElement.getAttributeByName(new QName(JBossSAMLConstants.NAME_FORMAT.get()))) != null) {
            attributeType.setNameFormat(StaxParserUtil.getAttributeValue(nameFormat));
        }
        while (!(!xmlEventReader.hasNext() || (xmlEvent = StaxParserUtil.peek(xmlEventReader)) instanceof EndElement && StaxParserUtil.matches(end = StaxParserUtil.getNextEndElement(xmlEventReader), rootTag) || (startElement = StaxParserUtil.peekNextStartElement(xmlEventReader)) == null)) {
            String tag = StaxParserUtil.getStartElementName(startElement);
            if (JBossSAMLConstants.ATTRIBUTE.get().equals(tag)) break;
            if (JBossSAMLConstants.ATTRIBUTE_VALUE.get().equals(tag)) {
                Object attributeValue = SAMLParserUtil.parseAttributeValue(xmlEventReader);
                attributeType.addAttributeValue(attributeValue);
                continue;
            }
            throw logger.parserUnknownTag(tag, startElement.getLocation());
        }
    }

    public static Object parseAttributeValue(XMLEventReader xmlEventReader) throws ParsingException {
        StartElement startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
        StaxParserUtil.validate(startElement, JBossSAMLConstants.ATTRIBUTE_VALUE.get());
        Attribute type = startElement.getAttributeByName(new QName(JBossSAMLURIConstants.XSI_NSURI.get(), "type", "xsi"));
        if (type == null) {
            if (StaxParserUtil.hasTextAhead(xmlEventReader)) {
                return StaxParserUtil.getElementText(xmlEventReader);
            }
            XMLEvent xmlEvent = StaxParserUtil.peek(xmlEventReader);
            if (xmlEvent instanceof StartElement) {
                startElement = (StartElement)xmlEvent;
                String tag = StaxParserUtil.getStartElementName(startElement);
                if (tag.equals(JBossSAMLConstants.NAMEID.get())) {
                    return SAMLParserUtil.parseNameIDType(xmlEventReader);
                }
            } else if (xmlEvent instanceof EndElement) {
                return "";
            }
            throw logger.unsupportedType(StaxParserUtil.getStartElementName(startElement));
        }
        String typeValue = StaxParserUtil.getAttributeValue(type);
        if (typeValue.contains(":string")) {
            return StaxParserUtil.getElementText(xmlEventReader);
        }
        if (typeValue.contains(":anyType")) {
            return StaxParserUtil.getElementText(xmlEventReader);
        }
        if (typeValue.contains(":base64Binary")) {
            return StaxParserUtil.getElementText(xmlEventReader);
        }
        throw logger.parserUnknownXSI(typeValue);
    }

    public static AuthnStatementType parseAuthnStatement(XMLEventReader xmlEventReader) throws ParsingException {
        XMLEvent xmlEvent;
        StartElement startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
        String AUTHNSTATEMENT = JBossSAMLConstants.AUTHN_STATEMENT.get();
        StaxParserUtil.validate(startElement, AUTHNSTATEMENT);
        Attribute authnInstant = startElement.getAttributeByName(new QName("AuthnInstant"));
        if (authnInstant == null) {
            throw logger.parserRequiredAttribute("AuthnInstant");
        }
        XMLGregorianCalendar issueInstant = XMLTimeUtil.parse(StaxParserUtil.getAttributeValue(authnInstant));
        AuthnStatementType authnStatementType = new AuthnStatementType(issueInstant);
        Attribute sessionIndex = startElement.getAttributeByName(new QName("SessionIndex"));
        if (sessionIndex != null) {
            authnStatementType.setSessionIndex(StaxParserUtil.getAttributeValue(sessionIndex));
        }
        while (xmlEventReader.hasNext() && (xmlEvent = StaxParserUtil.peek(xmlEventReader)) != null) {
            if (xmlEvent instanceof EndElement) {
                xmlEvent = StaxParserUtil.getNextEvent(xmlEventReader);
                EndElement endElement = (EndElement)xmlEvent;
                String endElementTag = StaxParserUtil.getEndElementName(endElement);
                if (endElementTag.equals(AUTHNSTATEMENT)) break;
                throw logger.parserUnknownEndElement(endElementTag);
            }
            startElement = null;
            startElement = xmlEvent instanceof StartElement ? (StartElement)xmlEvent : StaxParserUtil.peekNextStartElement(xmlEventReader);
            if (startElement == null) break;
            String tag = StaxParserUtil.getStartElementName(startElement);
            if (JBossSAMLConstants.SUBJECT_LOCALITY.get().equals(tag)) {
                Attribute dns;
                startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
                SubjectLocalityType subjectLocalityType = new SubjectLocalityType();
                Attribute address = startElement.getAttributeByName(new QName(JBossSAMLConstants.ADDRESS.get()));
                if (address != null) {
                    subjectLocalityType.setAddress(StaxParserUtil.getAttributeValue(address));
                }
                if ((dns = startElement.getAttributeByName(new QName(JBossSAMLConstants.DNS_NAME.get()))) != null) {
                    subjectLocalityType.setDNSName(StaxParserUtil.getAttributeValue(dns));
                }
                authnStatementType.setSubjectLocality(subjectLocalityType);
                StaxParserUtil.validate(StaxParserUtil.getNextEndElement(xmlEventReader), JBossSAMLConstants.SUBJECT_LOCALITY.get());
                continue;
            }
            if (JBossSAMLConstants.AUTHN_CONTEXT.get().equals(tag)) {
                authnStatementType.setAuthnContext(SAMLParserUtil.parseAuthnContextType(xmlEventReader));
                continue;
            }
            throw logger.parserUnknownTag(tag, startElement.getLocation());
        }
        return authnStatementType;
    }

    public static AuthnContextType parseAuthnContextType(XMLEventReader xmlEventReader) throws ParsingException {
        XMLEvent xmlEvent;
        AuthnContextType authnContextType = new AuthnContextType();
        StartElement startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
        StaxParserUtil.validate(startElement, JBossSAMLConstants.AUTHN_CONTEXT.get());
        while (xmlEventReader.hasNext() && (xmlEvent = StaxParserUtil.peek(xmlEventReader)) != null) {
            String text;
            AuthnContextType.AuthnContextTypeSequence authnContextSequence;
            if (xmlEvent instanceof EndElement) {
                xmlEvent = StaxParserUtil.getNextEvent(xmlEventReader);
                EndElement endElement = (EndElement)xmlEvent;
                String endElementTag = StaxParserUtil.getEndElementName(endElement);
                if (endElementTag.equals(JBossSAMLConstants.AUTHN_CONTEXT.get())) break;
                throw logger.parserUnknownEndElement(endElementTag);
            }
            startElement = null;
            startElement = xmlEvent instanceof StartElement ? (StartElement)xmlEvent : StaxParserUtil.peekNextStartElement(xmlEventReader);
            if (startElement == null) break;
            String tag = StaxParserUtil.getStartElementName(startElement);
            if (JBossSAMLConstants.AUTHN_CONTEXT_DECLARATION.get().equals(tag)) {
                startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
                Element dom = StaxParserUtil.getDOMElement(xmlEventReader);
                AuthnContextDeclType authnContextDecl = new AuthnContextDeclType((Object)dom);
                authnContextSequence = new AuthnContextType.AuthnContextTypeSequence(authnContextType);
                authnContextSequence.setAuthnContextDecl(authnContextDecl);
                authnContextType.setSequence(authnContextSequence);
                EndElement endElement = StaxParserUtil.getNextEndElement(xmlEventReader);
                StaxParserUtil.validate(endElement, JBossSAMLConstants.AUTHN_CONTEXT_DECLARATION.get());
                continue;
            }
            if (JBossSAMLConstants.AUTHN_CONTEXT_DECLARATION_REF.get().equals(tag)) {
                startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
                text = StaxParserUtil.getElementText(xmlEventReader);
                AuthnContextDeclRefType aAuthnContextDeclType = new AuthnContextDeclRefType(URI.create(text));
                authnContextType.addURIType((URIType)aAuthnContextDeclType);
                continue;
            }
            if (JBossSAMLConstants.AUTHN_CONTEXT_CLASS_REF.get().equals(tag)) {
                startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
                text = StaxParserUtil.getElementText(xmlEventReader);
                AuthnContextClassRefType aAuthnContextClassRefType = new AuthnContextClassRefType(URI.create(text));
                authnContextSequence = new AuthnContextType.AuthnContextTypeSequence(authnContextType);
                authnContextSequence.setClassRef(aAuthnContextClassRefType);
                authnContextType.setSequence(authnContextSequence);
                continue;
            }
            if (JBossSAMLConstants.AUTHENTICATING_AUTHORITY.get().equals(tag)) {
                startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
                text = StaxParserUtil.getElementText(xmlEventReader);
                authnContextType.addAuthenticatingAuthority(URI.create(text));
                continue;
            }
            throw logger.parserUnknownTag(tag, startElement.getLocation());
        }
        return authnContextType;
    }

    public static NameIDType parseNameIDType(XMLEventReader xmlEventReader) throws ParsingException {
        Attribute spNameQualifier;
        Attribute spProvidedID;
        Attribute format;
        StartElement nameIDElement = StaxParserUtil.getNextStartElement(xmlEventReader);
        NameIDType nameID = new NameIDType();
        Attribute nameQualifier = nameIDElement.getAttributeByName(new QName(JBossSAMLConstants.NAME_QUALIFIER.get()));
        if (nameQualifier != null) {
            nameID.setNameQualifier(StaxParserUtil.getAttributeValue(nameQualifier));
        }
        if ((format = nameIDElement.getAttributeByName(new QName(JBossSAMLConstants.FORMAT.get()))) != null) {
            nameID.setFormat(URI.create(StaxParserUtil.getAttributeValue(format)));
        }
        if ((spProvidedID = nameIDElement.getAttributeByName(new QName(JBossSAMLConstants.SP_PROVIDED_ID.get()))) != null) {
            nameID.setSPProvidedID(StaxParserUtil.getAttributeValue(spProvidedID));
        }
        if ((spNameQualifier = nameIDElement.getAttributeByName(new QName(JBossSAMLConstants.SP_NAME_QUALIFIER.get()))) != null) {
            nameID.setSPNameQualifier(StaxParserUtil.getAttributeValue(spNameQualifier));
        }
        String nameIDValue = StaxParserUtil.getElementText(xmlEventReader);
        nameID.setValue(nameIDValue);
        return nameID;
    }

    public static List<String> parseProtocolEnumeration(StartElement startElement) {
        ArrayList<String> protocolEnum = new ArrayList<String>();
        Attribute proto = startElement.getAttributeByName(new QName(JBossSAMLConstants.PROTOCOL_SUPPORT_ENUMERATION.get()));
        String val = StaxParserUtil.getAttributeValue(proto);
        if (StringUtil.isNotNull(val)) {
            StringTokenizer st = new StringTokenizer(val);
            while (st.hasMoreTokens()) {
                protocolEnum.add(st.nextToken());
            }
        }
        return protocolEnum;
    }
}

