/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.saml;

import java.net.URI;
import java.util.LinkedList;
import java.util.List;
import org.keycloak.dom.saml.v2.assertion.AssertionType;
import org.keycloak.dom.saml.v2.assertion.AudienceRestrictionType;
import org.keycloak.dom.saml.v2.assertion.AuthnStatementType;
import org.keycloak.dom.saml.v2.assertion.ConditionAbstractType;
import org.keycloak.dom.saml.v2.assertion.ConditionsType;
import org.keycloak.dom.saml.v2.assertion.OneTimeUseType;
import org.keycloak.dom.saml.v2.assertion.StatementAbstractType;
import org.keycloak.dom.saml.v2.assertion.SubjectConfirmationDataType;
import org.keycloak.dom.saml.v2.assertion.SubjectConfirmationType;
import org.keycloak.dom.saml.v2.protocol.ExtensionsType;
import org.keycloak.dom.saml.v2.protocol.ResponseType;
import org.keycloak.dom.saml.v2.protocol.StatusResponseType;
import org.keycloak.saml.SamlProtocolExtensionsAwareBuilder;
import org.keycloak.saml.common.PicketLinkLogger;
import org.keycloak.saml.common.PicketLinkLoggerFactory;
import org.keycloak.saml.common.constants.JBossSAMLURIConstants;
import org.keycloak.saml.common.exceptions.ConfigurationException;
import org.keycloak.saml.common.exceptions.ProcessingException;
import org.keycloak.saml.common.util.DocumentUtil;
import org.keycloak.saml.common.util.StringUtil;
import org.keycloak.saml.processing.api.saml.v2.response.SAML2Response;
import org.keycloak.saml.processing.core.saml.v2.common.IDGenerator;
import org.keycloak.saml.processing.core.saml.v2.holders.IDPInfoHolder;
import org.keycloak.saml.processing.core.saml.v2.holders.IssuerInfoHolder;
import org.keycloak.saml.processing.core.saml.v2.holders.SPInfoHolder;
import org.keycloak.saml.processing.core.saml.v2.util.StatementUtil;
import org.keycloak.saml.processing.core.saml.v2.util.XMLTimeUtil;
import org.w3c.dom.Document;

public class SAML2LoginResponseBuilder
implements SamlProtocolExtensionsAwareBuilder<SAML2LoginResponseBuilder> {
    protected static final PicketLinkLogger logger = PicketLinkLoggerFactory.getLogger();
    protected String destination;
    protected String issuer;
    protected int subjectExpiration;
    protected int assertionExpiration;
    protected String nameId;
    protected String nameIdFormat;
    protected boolean multiValuedRoles;
    protected boolean disableAuthnStatement;
    protected String requestID;
    protected String authMethod;
    protected String requestIssuer;
    protected String sessionIndex;
    protected final List<SamlProtocolExtensionsAwareBuilder.NodeGenerator> extensions = new LinkedList<SamlProtocolExtensionsAwareBuilder.NodeGenerator>();
    protected boolean includeOneTimeUseCondition;

    public SAML2LoginResponseBuilder sessionIndex(String sessionIndex) {
        this.sessionIndex = sessionIndex;
        return this;
    }

    public SAML2LoginResponseBuilder destination(String destination) {
        this.destination = destination;
        return this;
    }

    public SAML2LoginResponseBuilder issuer(String issuer) {
        this.issuer = issuer;
        return this;
    }

    public SAML2LoginResponseBuilder subjectExpiration(int subjectExpiration) {
        this.subjectExpiration = subjectExpiration;
        return this;
    }

    public SAML2LoginResponseBuilder assertionExpiration(int assertionExpiration) {
        this.assertionExpiration = assertionExpiration;
        return this;
    }

    public SAML2LoginResponseBuilder requestID(String requestID) {
        this.requestID = requestID;
        return this;
    }

    public SAML2LoginResponseBuilder requestIssuer(String requestIssuer) {
        this.requestIssuer = requestIssuer;
        return this;
    }

    public SAML2LoginResponseBuilder authMethod(String authMethod) {
        this.authMethod = authMethod;
        return this;
    }

    public SAML2LoginResponseBuilder nameIdentifier(String nameIdFormat, String nameId) {
        this.nameIdFormat = nameIdFormat;
        this.nameId = nameId;
        return this;
    }

    public SAML2LoginResponseBuilder multiValuedRoles(boolean multiValuedRoles) {
        this.multiValuedRoles = multiValuedRoles;
        return this;
    }

    public SAML2LoginResponseBuilder disableAuthnStatement(boolean disableAuthnStatement) {
        this.disableAuthnStatement = disableAuthnStatement;
        return this;
    }

    public SAML2LoginResponseBuilder includeOneTimeUseCondition(boolean includeOneTimeUseCondition) {
        this.includeOneTimeUseCondition = includeOneTimeUseCondition;
        return this;
    }

    @Override
    public SAML2LoginResponseBuilder addExtension(SamlProtocolExtensionsAwareBuilder.NodeGenerator extension) {
        this.extensions.add(extension);
        return this;
    }

    public Document buildDocument(ResponseType responseType) throws ConfigurationException, ProcessingException {
        Document samlResponseDocument = null;
        try {
            SAML2Response docGen = new SAML2Response();
            samlResponseDocument = docGen.convert((StatusResponseType)responseType);
            if (logger.isTraceEnabled()) {
                logger.trace("SAML Response Document: " + DocumentUtil.asString(samlResponseDocument));
            }
        }
        catch (Exception e) {
            throw logger.samlAssertionMarshallError(e);
        }
        return samlResponseDocument;
    }

    public ResponseType buildModel() throws ConfigurationException, ProcessingException {
        ResponseType responseType = null;
        SAML2Response saml2Response = new SAML2Response();
        String id = IDGenerator.create("ID_");
        IssuerInfoHolder issuerHolder = new IssuerInfoHolder(this.issuer);
        issuerHolder.setStatusCode(JBossSAMLURIConstants.STATUS_SUCCESS.get());
        IDPInfoHolder idp = new IDPInfoHolder();
        idp.setNameIDFormatValue(this.nameId);
        idp.setNameIDFormat(this.nameIdFormat);
        SPInfoHolder sp = new SPInfoHolder();
        sp.setResponseDestinationURI(this.destination);
        sp.setRequestID(this.requestID);
        sp.setIssuer(this.requestIssuer);
        responseType = saml2Response.createResponseType(id, sp, idp, issuerHolder);
        AssertionType assertion = ((ResponseType.RTChoiceType)responseType.getAssertions().get(0)).getAssertion();
        AudienceRestrictionType audience = new AudienceRestrictionType();
        audience.addAudience(URI.create(this.requestIssuer));
        assertion.getConditions().addCondition((ConditionAbstractType)audience);
        if (this.assertionExpiration > 0) {
            ConditionsType conditions = assertion.getConditions();
            conditions.setNotOnOrAfter(XMLTimeUtil.add(conditions.getNotBefore(), this.assertionExpiration * 1000));
        }
        if (this.subjectExpiration > 0) {
            SubjectConfirmationDataType subjectConfirmationData = ((SubjectConfirmationType)assertion.getSubject().getConfirmation().get(0)).getSubjectConfirmationData();
            subjectConfirmationData.setNotOnOrAfter(XMLTimeUtil.add(assertion.getConditions().getNotBefore(), this.subjectExpiration * 1000));
        }
        if (!this.disableAuthnStatement) {
            String authContextRef = JBossSAMLURIConstants.AC_UNSPECIFIED.get();
            if (StringUtil.isNotNull(this.authMethod)) {
                authContextRef = this.authMethod;
            }
            AuthnStatementType authnStatement = StatementUtil.createAuthnStatement(XMLTimeUtil.getIssueInstant(), authContextRef);
            if (this.sessionIndex != null) {
                authnStatement.setSessionIndex(this.sessionIndex);
            } else {
                authnStatement.setSessionIndex(assertion.getID());
            }
            assertion.addStatement((StatementAbstractType)authnStatement);
        }
        if (this.includeOneTimeUseCondition) {
            assertion.getConditions().addCondition((ConditionAbstractType)new OneTimeUseType());
        }
        if (!this.extensions.isEmpty()) {
            ExtensionsType extensionsType = new ExtensionsType();
            for (SamlProtocolExtensionsAwareBuilder.NodeGenerator extension : this.extensions) {
                extensionsType.addExtension((Object)extension);
            }
            responseType.setExtensions(extensionsType);
        }
        return responseType;
    }
}

