/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.saml;

import java.net.URI;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.http.client.HttpClient;
import org.keycloak.adapters.saml.SamlDeployment;
import org.keycloak.adapters.saml.rotation.SamlDescriptorPublicKeyLocator;
import org.keycloak.common.enums.SslRequired;
import org.keycloak.rotation.CompositeKeyLocator;
import org.keycloak.rotation.HardcodedKeyLocator;
import org.keycloak.rotation.KeyLocator;
import org.keycloak.saml.SignatureAlgorithm;

public class DefaultSamlDeployment
implements SamlDeployment {
    private SamlDeployment.IDP idp;
    private boolean configured;
    private SslRequired sslRequired = SslRequired.EXTERNAL;
    private String entityID;
    private String nameIDPolicyFormat;
    private boolean forceAuthentication;
    private boolean isPassive;
    private boolean turnOffChangeSessionIdOnLogin;
    private PrivateKey decryptionKey;
    private KeyPair signingKeyPair;
    private Set<String> roleAttributeNames;
    private SamlDeployment.PrincipalNamePolicy principalNamePolicy = SamlDeployment.PrincipalNamePolicy.FROM_NAME_ID;
    private String principalAttributeName;
    private String logoutPage;
    private SignatureAlgorithm signatureAlgorithm;
    private String signatureCanonicalizationMethod;
    private boolean autodetectBearerOnly;

    @Override
    public boolean turnOffChangeSessionIdOnLogin() {
        return this.turnOffChangeSessionIdOnLogin;
    }

    public void setTurnOffChangeSessionIdOnLogin(boolean turnOffChangeSessionIdOnLogin) {
        this.turnOffChangeSessionIdOnLogin = turnOffChangeSessionIdOnLogin;
    }

    @Override
    public SamlDeployment.IDP getIDP() {
        return this.idp;
    }

    @Override
    public boolean isConfigured() {
        return this.configured;
    }

    @Override
    public SslRequired getSslRequired() {
        return this.sslRequired;
    }

    @Override
    public String getEntityID() {
        return this.entityID;
    }

    @Override
    public String getNameIDPolicyFormat() {
        return this.nameIDPolicyFormat;
    }

    @Override
    public boolean isForceAuthentication() {
        return this.forceAuthentication;
    }

    @Override
    public boolean isIsPassive() {
        return this.isPassive;
    }

    @Override
    public PrivateKey getDecryptionKey() {
        return this.decryptionKey;
    }

    @Override
    public KeyPair getSigningKeyPair() {
        return this.signingKeyPair;
    }

    @Override
    public Set<String> getRoleAttributeNames() {
        return this.roleAttributeNames;
    }

    @Override
    public SamlDeployment.PrincipalNamePolicy getPrincipalNamePolicy() {
        return this.principalNamePolicy;
    }

    @Override
    public String getPrincipalAttributeName() {
        return this.principalAttributeName;
    }

    public void setIdp(SamlDeployment.IDP idp) {
        this.idp = idp;
    }

    public void setConfigured(boolean configured) {
        this.configured = configured;
    }

    public void setSslRequired(SslRequired sslRequired) {
        this.sslRequired = sslRequired;
    }

    public void setEntityID(String entityID) {
        this.entityID = entityID;
    }

    public void setNameIDPolicyFormat(String nameIDPolicyFormat) {
        this.nameIDPolicyFormat = nameIDPolicyFormat;
    }

    public void setForceAuthentication(boolean forceAuthentication) {
        this.forceAuthentication = forceAuthentication;
    }

    public void setIsPassive(boolean isPassive) {
        this.isPassive = isPassive;
    }

    public void setDecryptionKey(PrivateKey decryptionKey) {
        this.decryptionKey = decryptionKey;
    }

    public void setSigningKeyPair(KeyPair signingKeyPair) {
        this.signingKeyPair = signingKeyPair;
    }

    public void setRoleAttributeNames(Set<String> roleAttributeNames) {
        this.roleAttributeNames = roleAttributeNames;
    }

    public void setPrincipalNamePolicy(SamlDeployment.PrincipalNamePolicy principalNamePolicy) {
        this.principalNamePolicy = principalNamePolicy;
    }

    public void setPrincipalAttributeName(String principalAttributeName) {
        this.principalAttributeName = principalAttributeName;
    }

    @Override
    public String getLogoutPage() {
        return this.logoutPage;
    }

    public void setLogoutPage(String logoutPage) {
        this.logoutPage = logoutPage;
    }

    @Override
    public String getSignatureCanonicalizationMethod() {
        return this.signatureCanonicalizationMethod;
    }

    public void setSignatureCanonicalizationMethod(String signatureCanonicalizationMethod) {
        this.signatureCanonicalizationMethod = signatureCanonicalizationMethod;
    }

    @Override
    public SignatureAlgorithm getSignatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    public void setSignatureAlgorithm(SignatureAlgorithm signatureAlgorithm) {
        this.signatureAlgorithm = signatureAlgorithm;
    }

    @Override
    public boolean isAutodetectBearerOnly() {
        return this.autodetectBearerOnly;
    }

    public void setAutodetectBearerOnly(boolean autodetectBearerOnly) {
        this.autodetectBearerOnly = autodetectBearerOnly;
    }

    public static class DefaultIDP
    implements SamlDeployment.IDP {
        private static final int DEFAULT_CACHE_TTL = 86400;
        private String entityID;
        private final CompositeKeyLocator signatureValidationKeyLocator = new CompositeKeyLocator();
        private SamlDeployment.IDP.SingleSignOnService singleSignOnService;
        private SamlDeployment.IDP.SingleLogoutService singleLogoutService;
        private final List<PublicKey> signatureValidationKeys = new LinkedList<PublicKey>();
        private int minTimeBetweenDescriptorRequests;
        private HttpClient client;
        private String metadataUrl;

        @Override
        public String getEntityID() {
            return this.entityID;
        }

        @Override
        public SamlDeployment.IDP.SingleSignOnService getSingleSignOnService() {
            return this.singleSignOnService;
        }

        @Override
        public SamlDeployment.IDP.SingleLogoutService getSingleLogoutService() {
            return this.singleLogoutService;
        }

        @Override
        public KeyLocator getSignatureValidationKeyLocator() {
            return this.signatureValidationKeyLocator;
        }

        @Override
        public int getMinTimeBetweenDescriptorRequests() {
            return this.minTimeBetweenDescriptorRequests;
        }

        public void setMinTimeBetweenDescriptorRequests(int minTimeBetweenDescriptorRequests) {
            this.minTimeBetweenDescriptorRequests = minTimeBetweenDescriptorRequests;
        }

        public void setEntityID(String entityID) {
            this.entityID = entityID;
        }

        public void addSignatureValidationKey(PublicKey signatureValidationKey) {
            this.signatureValidationKeys.add(signatureValidationKey);
        }

        public void setSingleSignOnService(SamlDeployment.IDP.SingleSignOnService singleSignOnService) {
            this.singleSignOnService = singleSignOnService;
        }

        public void setSingleLogoutService(SamlDeployment.IDP.SingleLogoutService singleLogoutService) {
            this.singleLogoutService = singleLogoutService;
        }

        public void refreshKeyLocatorConfiguration() {
            this.signatureValidationKeyLocator.clear();
            if (!this.signatureValidationKeys.isEmpty()) {
                this.signatureValidationKeyLocator.add((KeyLocator)new HardcodedKeyLocator(this.signatureValidationKeys));
            } else if (this.singleSignOnService != null) {
                HttpClient httpClient = this.getClient();
                SamlDescriptorPublicKeyLocator samlDescriptorPublicKeyLocator = new SamlDescriptorPublicKeyLocator(this.getMetadataUrl(), this.minTimeBetweenDescriptorRequests, 86400, httpClient);
                this.signatureValidationKeyLocator.add((KeyLocator)samlDescriptorPublicKeyLocator);
            }
        }

        @Override
        public HttpClient getClient() {
            return this.client;
        }

        public void setClient(HttpClient client) {
            this.client = client;
        }

        public String getMetadataUrl() {
            return this.metadataUrl == null ? this.singleSignOnService.getRequestBindingUrl() + "/descriptor" : this.metadataUrl;
        }

        public void setMetadataUrl(String metadataUrl) {
            this.metadataUrl = metadataUrl;
        }
    }

    public static class DefaultSingleLogoutService
    implements SamlDeployment.IDP.SingleLogoutService {
        private boolean validateRequestSignature;
        private boolean validateResponseSignature;
        private boolean signRequest;
        private boolean signResponse;
        private SamlDeployment.Binding requestBinding;
        private SamlDeployment.Binding responseBinding;
        private String requestBindingUrl;
        private String responseBindingUrl;

        @Override
        public boolean validateRequestSignature() {
            return this.validateRequestSignature;
        }

        @Override
        public boolean validateResponseSignature() {
            return this.validateResponseSignature;
        }

        @Override
        public boolean signRequest() {
            return this.signRequest;
        }

        @Override
        public boolean signResponse() {
            return this.signResponse;
        }

        @Override
        public SamlDeployment.Binding getRequestBinding() {
            return this.requestBinding;
        }

        @Override
        public SamlDeployment.Binding getResponseBinding() {
            return this.responseBinding;
        }

        @Override
        public String getRequestBindingUrl() {
            return this.requestBindingUrl;
        }

        @Override
        public String getResponseBindingUrl() {
            return this.responseBindingUrl;
        }

        public void setValidateRequestSignature(boolean validateRequestSignature) {
            this.validateRequestSignature = validateRequestSignature;
        }

        public void setValidateResponseSignature(boolean validateResponseSignature) {
            this.validateResponseSignature = validateResponseSignature;
        }

        public void setSignRequest(boolean signRequest) {
            this.signRequest = signRequest;
        }

        public void setSignResponse(boolean signResponse) {
            this.signResponse = signResponse;
        }

        public void setRequestBinding(SamlDeployment.Binding requestBinding) {
            this.requestBinding = requestBinding;
        }

        public void setResponseBinding(SamlDeployment.Binding responseBinding) {
            this.responseBinding = responseBinding;
        }

        public void setRequestBindingUrl(String requestBindingUrl) {
            this.requestBindingUrl = requestBindingUrl;
        }

        public void setResponseBindingUrl(String responseBindingUrl) {
            this.responseBindingUrl = responseBindingUrl;
        }
    }

    public static class DefaultSingleSignOnService
    implements SamlDeployment.IDP.SingleSignOnService {
        private boolean signRequest;
        private boolean validateResponseSignature;
        private boolean validateAssertionSignature;
        private SamlDeployment.Binding requestBinding;
        private SamlDeployment.Binding responseBinding;
        private String requestBindingUrl;
        private URI assertionConsumerServiceUrl;

        @Override
        public boolean signRequest() {
            return this.signRequest;
        }

        @Override
        public boolean validateResponseSignature() {
            return this.validateResponseSignature;
        }

        @Override
        public boolean validateAssertionSignature() {
            return this.validateAssertionSignature;
        }

        @Override
        public SamlDeployment.Binding getRequestBinding() {
            return this.requestBinding;
        }

        @Override
        public SamlDeployment.Binding getResponseBinding() {
            return this.responseBinding;
        }

        @Override
        public String getRequestBindingUrl() {
            return this.requestBindingUrl;
        }

        @Override
        public URI getAssertionConsumerServiceUrl() {
            return this.assertionConsumerServiceUrl;
        }

        public void setAssertionConsumerServiceUrl(URI assertionConsumerServiceUrl) {
            this.assertionConsumerServiceUrl = assertionConsumerServiceUrl;
        }

        public void setSignRequest(boolean signRequest) {
            this.signRequest = signRequest;
        }

        public void setValidateResponseSignature(boolean validateResponseSignature) {
            this.validateResponseSignature = validateResponseSignature;
        }

        public void setValidateAssertionSignature(boolean validateAssertionSignature) {
            this.validateAssertionSignature = validateAssertionSignature;
        }

        public void setRequestBinding(SamlDeployment.Binding requestBinding) {
            this.requestBinding = requestBinding;
        }

        public void setResponseBinding(SamlDeployment.Binding responseBinding) {
            this.responseBinding = responseBinding;
        }

        public void setRequestBindingUrl(String requestBindingUrl) {
            this.requestBindingUrl = requestBindingUrl;
        }
    }
}

