/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.saml;

import java.util.LinkedList;
import java.util.List;
import org.keycloak.dom.saml.v2.assertion.NameIDType;
import org.keycloak.dom.saml.v2.protocol.ExtensionsType;
import org.keycloak.dom.saml.v2.protocol.StatusCodeType;
import org.keycloak.dom.saml.v2.protocol.StatusResponseType;
import org.keycloak.dom.saml.v2.protocol.StatusType;
import org.keycloak.saml.SamlProtocolExtensionsAwareBuilder;
import org.keycloak.saml.common.constants.JBossSAMLURIConstants;
import org.keycloak.saml.common.exceptions.ConfigurationException;
import org.keycloak.saml.common.exceptions.ParsingException;
import org.keycloak.saml.common.exceptions.ProcessingException;
import org.keycloak.saml.processing.api.saml.v2.response.SAML2Response;
import org.keycloak.saml.processing.core.saml.v2.common.IDGenerator;
import org.keycloak.saml.processing.core.saml.v2.util.XMLTimeUtil;
import org.w3c.dom.Document;

public class SAML2LogoutResponseBuilder
implements SamlProtocolExtensionsAwareBuilder<SAML2LogoutResponseBuilder> {
    protected String logoutRequestID;
    protected String destination;
    protected String issuer;
    protected final List<SamlProtocolExtensionsAwareBuilder.NodeGenerator> extensions = new LinkedList<SamlProtocolExtensionsAwareBuilder.NodeGenerator>();

    public SAML2LogoutResponseBuilder logoutRequestID(String logoutRequestID) {
        this.logoutRequestID = logoutRequestID;
        return this;
    }

    public SAML2LogoutResponseBuilder destination(String destination) {
        this.destination = destination;
        return this;
    }

    public SAML2LogoutResponseBuilder issuer(String issuer) {
        this.issuer = issuer;
        return this;
    }

    @Override
    public SAML2LogoutResponseBuilder addExtension(SamlProtocolExtensionsAwareBuilder.NodeGenerator extension) {
        this.extensions.add(extension);
        return this;
    }

    public StatusResponseType buildModel() throws ConfigurationException {
        StatusResponseType statusResponse = new StatusResponseType(IDGenerator.create("ID_"), XMLTimeUtil.getIssueInstant());
        StatusType statusType = new StatusType();
        StatusCodeType statusCodeType = new StatusCodeType();
        statusCodeType.setValue(JBossSAMLURIConstants.STATUS_SUCCESS.getUri());
        statusType.setStatusCode(statusCodeType);
        statusResponse.setStatus(statusType);
        statusResponse.setInResponseTo(this.logoutRequestID);
        NameIDType issuer = new NameIDType();
        issuer.setValue(this.issuer);
        statusResponse.setIssuer(issuer);
        statusResponse.setDestination(this.destination);
        if (!this.extensions.isEmpty()) {
            ExtensionsType extensionsType = new ExtensionsType();
            for (SamlProtocolExtensionsAwareBuilder.NodeGenerator extension : this.extensions) {
                extensionsType.addExtension((Object)extension);
            }
            statusResponse.setExtensions(extensionsType);
        }
        return statusResponse;
    }

    public Document buildDocument() throws ProcessingException {
        Document samlResponse = null;
        try {
            StatusResponseType statusResponse = this.buildModel();
            SAML2Response saml2Response = new SAML2Response();
            samlResponse = saml2Response.convert(statusResponse);
        }
        catch (ConfigurationException e) {
            throw new ProcessingException((Throwable)e);
        }
        catch (ParsingException e) {
            throw new ProcessingException((Throwable)e);
        }
        return samlResponse;
    }
}

