/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.saml.jetty;

import javax.servlet.ServletRequest;
import org.eclipse.jetty.server.AbstractHttpConnection;
import org.eclipse.jetty.server.Authentication;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.UserIdentity;
import org.keycloak.adapters.saml.SamlDeployment;
import org.keycloak.adapters.saml.jetty.AbstractSamlAuthenticator;
import org.keycloak.adapters.saml.jetty.JettyAdapterSessionStore;
import org.keycloak.adapters.spi.AdapterSessionStore;

public class KeycloakSamlAuthenticator
extends AbstractSamlAuthenticator {
    public AdapterSessionStore createSessionTokenStore(Request request, SamlDeployment resolvedDeployment) {
        return new JettyAdapterSessionStore(request);
    }

    protected Request resolveRequest(ServletRequest req) {
        return req instanceof Request ? (Request)req : AbstractHttpConnection.getCurrentConnection().getRequest();
    }

    public Authentication createAuthentication(UserIdentity userIdentity) {
        return new AbstractSamlAuthenticator.KeycloakAuthentication(this.getAuthMethod(), userIdentity){

            public void logout() {
                KeycloakSamlAuthenticator.this.logoutCurrent(AbstractHttpConnection.getCurrentConnection().getRequest());
            }
        };
    }
}

