/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.saml.processing.core.parsers.saml.assertion;

import java.net.URI;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.StartElement;
import org.keycloak.dom.saml.v2.assertion.AuthnContextClassRefType;
import org.keycloak.dom.saml.v2.assertion.AuthnContextDeclRefType;
import org.keycloak.dom.saml.v2.assertion.AuthnContextDeclType;
import org.keycloak.dom.saml.v2.assertion.AuthnContextType;
import org.keycloak.dom.saml.v2.assertion.URIType;
import org.keycloak.saml.common.exceptions.ParsingException;
import org.keycloak.saml.common.util.StaxParserUtil;
import org.keycloak.saml.processing.core.parsers.saml.assertion.AbstractStaxSamlAssertionParser;
import org.keycloak.saml.processing.core.parsers.saml.assertion.SAMLAssertionQNames;
import org.w3c.dom.Element;

public class SAMLAuthnContextParser
extends AbstractStaxSamlAssertionParser<AuthnContextType> {
    private static final SAMLAuthnContextParser INSTANCE = new SAMLAuthnContextParser();

    private SAMLAuthnContextParser() {
        super(SAMLAssertionQNames.AUTHN_CONTEXT);
    }

    public static SAMLAuthnContextParser getInstance() {
        return INSTANCE;
    }

    @Override
    protected AuthnContextType instantiateElement(XMLEventReader xmlEventReader, StartElement element) throws ParsingException {
        return new AuthnContextType();
    }

    @Override
    protected void processSubElement(XMLEventReader xmlEventReader, AuthnContextType target, SAMLAssertionQNames element, StartElement elementDetail) throws ParsingException {
        switch (element) {
            case AUTHN_CONTEXT_DECL: {
                Element dom = StaxParserUtil.getDOMElement(xmlEventReader);
                AuthnContextDeclType authnContextDecl = new AuthnContextDeclType((Object)dom);
                AuthnContextType.AuthnContextTypeSequence authnContextSequence = target.getSequence() != null ? target.getSequence() : new AuthnContextType.AuthnContextTypeSequence();
                authnContextSequence.setAuthnContextDecl(authnContextDecl);
                target.setSequence(authnContextSequence);
                break;
            }
            case AUTHN_CONTEXT_DECL_REF: {
                StaxParserUtil.advance(xmlEventReader);
                String text = StaxParserUtil.getElementText(xmlEventReader);
                AuthnContextDeclRefType authnContextDeclRef = new AuthnContextDeclRefType(URI.create(text));
                target.addURIType((URIType)authnContextDeclRef);
                break;
            }
            case AUTHN_CONTEXT_CLASS_REF: {
                StaxParserUtil.advance(xmlEventReader);
                String text = StaxParserUtil.getElementText(xmlEventReader);
                AuthnContextClassRefType authnContextClassRef = new AuthnContextClassRefType(URI.create(text));
                AuthnContextType.AuthnContextTypeSequence authnContextSequence = target.getSequence() != null ? target.getSequence() : new AuthnContextType.AuthnContextTypeSequence();
                authnContextSequence.setClassRef(authnContextClassRef);
                target.setSequence(authnContextSequence);
                break;
            }
            case AUTHENTICATING_AUTHORITY: {
                StaxParserUtil.advance(xmlEventReader);
                String text = StaxParserUtil.getElementText(xmlEventReader);
                target.addAuthenticatingAuthority(URI.create(text));
                break;
            }
            default: {
                throw LOGGER.parserUnknownTag(StaxParserUtil.getElementName(elementDetail), elementDetail.getLocation());
            }
        }
    }
}

