/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.saml;

import java.io.StringWriter;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.keycloak.dom.saml.v2.metadata.EndpointType;
import org.keycloak.dom.saml.v2.metadata.EntityDescriptorType;
import org.keycloak.dom.saml.v2.metadata.IndexedEndpointType;
import org.keycloak.dom.saml.v2.metadata.KeyDescriptorType;
import org.keycloak.dom.saml.v2.metadata.KeyTypes;
import org.keycloak.dom.saml.v2.metadata.SPSSODescriptorType;
import org.keycloak.dom.saml.v2.metadata.SSODescriptorType;
import org.keycloak.saml.common.constants.JBossSAMLURIConstants;
import org.keycloak.saml.common.exceptions.ProcessingException;
import org.keycloak.saml.common.util.StaxUtil;
import org.keycloak.saml.processing.core.saml.v2.common.IDGenerator;
import org.keycloak.saml.processing.core.saml.v2.writers.SAMLMetadataWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SPMetadataDescriptor {
    public static String getSPDescriptor(URI binding, URI assertionEndpoint, URI logoutEndpoint, boolean wantAuthnRequestsSigned, boolean wantAssertionsSigned, boolean wantAssertionsEncrypted, String entityId, String nameIDPolicyFormat, List<Element> signingCerts, List<Element> encryptionCerts) throws XMLStreamException, ProcessingException, ParserConfigurationException {
        return SPMetadataDescriptor.getSPDescriptor(binding, binding, assertionEndpoint, logoutEndpoint, wantAuthnRequestsSigned, wantAssertionsSigned, wantAssertionsEncrypted, entityId, nameIDPolicyFormat, signingCerts, encryptionCerts);
    }

    public static String getSPDescriptor(URI loginBinding, URI logoutBinding, URI assertionEndpoint, URI logoutEndpoint, boolean wantAuthnRequestsSigned, boolean wantAssertionsSigned, boolean wantAssertionsEncrypted, String entityId, String nameIDPolicyFormat, List<Element> signingCerts, List<Element> encryptionCerts) throws XMLStreamException, ProcessingException, ParserConfigurationException {
        KeyDescriptorType keyDescriptor;
        StringWriter sw = new StringWriter();
        XMLStreamWriter writer = StaxUtil.getXMLStreamWriter(sw);
        SAMLMetadataWriter metadataWriter = new SAMLMetadataWriter(writer);
        EntityDescriptorType entityDescriptor = new EntityDescriptorType(entityId);
        entityDescriptor.setID(IDGenerator.create("ID_"));
        SPSSODescriptorType spSSODescriptor = new SPSSODescriptorType(Arrays.asList(JBossSAMLURIConstants.PROTOCOL_NSURI.get()));
        spSSODescriptor.setAuthnRequestsSigned(Boolean.valueOf(wantAuthnRequestsSigned));
        spSSODescriptor.setWantAssertionsSigned(Boolean.valueOf(wantAssertionsSigned));
        spSSODescriptor.addNameIDFormat(nameIDPolicyFormat);
        spSSODescriptor.addSingleLogoutService(new EndpointType(logoutBinding, logoutEndpoint));
        if (wantAuthnRequestsSigned && signingCerts != null) {
            for (Element key : signingCerts) {
                keyDescriptor = new KeyDescriptorType();
                keyDescriptor.setUse(KeyTypes.SIGNING);
                keyDescriptor.setKeyInfo(key);
                spSSODescriptor.addKeyDescriptor(keyDescriptor);
            }
        }
        if (wantAssertionsEncrypted && encryptionCerts != null) {
            for (Element key : encryptionCerts) {
                keyDescriptor = new KeyDescriptorType();
                keyDescriptor.setUse(KeyTypes.ENCRYPTION);
                keyDescriptor.setKeyInfo(key);
                spSSODescriptor.addKeyDescriptor(keyDescriptor);
            }
        }
        IndexedEndpointType assertionConsumerEndpoint = new IndexedEndpointType(loginBinding, assertionEndpoint);
        assertionConsumerEndpoint.setIsDefault(Boolean.valueOf(true));
        assertionConsumerEndpoint.setIndex(1);
        spSSODescriptor.addAssertionConsumerService(assertionConsumerEndpoint);
        entityDescriptor.addChoiceType(new EntityDescriptorType.EDTChoiceType(Arrays.asList(new EntityDescriptorType.EDTDescriptorChoiceType((SSODescriptorType)spSSODescriptor))));
        metadataWriter.writeEntityDescriptor(entityDescriptor);
        return sw.toString();
    }

    public static Element buildKeyInfoElement(String keyName, String pemEncodedCertificate) throws ParserConfigurationException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document doc = db.newDocument();
        Element keyInfo = doc.createElementNS(JBossSAMLURIConstants.XMLDSIG_NSURI.get(), "ds:KeyInfo");
        if (keyName != null) {
            Element keyNameElement = doc.createElementNS(JBossSAMLURIConstants.XMLDSIG_NSURI.get(), "ds:KeyName");
            keyNameElement.setTextContent(keyName);
            keyInfo.appendChild(keyNameElement);
        }
        Element x509Data = doc.createElementNS(JBossSAMLURIConstants.XMLDSIG_NSURI.get(), "ds:X509Data");
        Element x509Certificate = doc.createElementNS(JBossSAMLURIConstants.XMLDSIG_NSURI.get(), "ds:X509Certificate");
        x509Certificate.setTextContent(pemEncodedCertificate);
        x509Data.appendChild(x509Certificate);
        keyInfo.appendChild(x509Data);
        return keyInfo;
    }
}

