/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.saml.profile;

import java.io.IOException;
import java.net.URI;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyManagementException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import org.jboss.logging.Logger;
import org.keycloak.adapters.saml.AbstractInitiateLogin;
import org.keycloak.adapters.saml.OnSessionCreated;
import org.keycloak.adapters.saml.SamlAuthenticationError;
import org.keycloak.adapters.saml.SamlDeployment;
import org.keycloak.adapters.saml.SamlPrincipal;
import org.keycloak.adapters.saml.SamlSession;
import org.keycloak.adapters.saml.SamlSessionStore;
import org.keycloak.adapters.saml.SamlUtil;
import org.keycloak.adapters.saml.profile.SamlAuthenticationHandler;
import org.keycloak.adapters.saml.profile.SamlInvocationContext;
import org.keycloak.adapters.saml.profile.webbrowsersso.WebBrowserSsoAuthenticationHandler;
import org.keycloak.adapters.spi.AuthChallenge;
import org.keycloak.adapters.spi.AuthOutcome;
import org.keycloak.adapters.spi.AuthenticationError;
import org.keycloak.adapters.spi.HttpFacade;
import org.keycloak.common.VerificationException;
import org.keycloak.common.util.Base64;
import org.keycloak.common.util.KeycloakUriBuilder;
import org.keycloak.common.util.MultivaluedHashMap;
import org.keycloak.dom.saml.common.CommonConditionsType;
import org.keycloak.dom.saml.v2.SAML2Object;
import org.keycloak.dom.saml.v2.assertion.AssertionType;
import org.keycloak.dom.saml.v2.assertion.AttributeStatementType;
import org.keycloak.dom.saml.v2.assertion.AttributeType;
import org.keycloak.dom.saml.v2.assertion.AuthnStatementType;
import org.keycloak.dom.saml.v2.assertion.NameIDType;
import org.keycloak.dom.saml.v2.assertion.SubjectType;
import org.keycloak.dom.saml.v2.protocol.ExtensionsType;
import org.keycloak.dom.saml.v2.protocol.LogoutRequestType;
import org.keycloak.dom.saml.v2.protocol.RequestAbstractType;
import org.keycloak.dom.saml.v2.protocol.ResponseType;
import org.keycloak.dom.saml.v2.protocol.StatusCodeType;
import org.keycloak.dom.saml.v2.protocol.StatusResponseType;
import org.keycloak.dom.saml.v2.protocol.StatusType;
import org.keycloak.rotation.KeyLocator;
import org.keycloak.saml.BaseSAML2BindingBuilder;
import org.keycloak.saml.SAML2AuthnRequestBuilder;
import org.keycloak.saml.SAMLRequestParser;
import org.keycloak.saml.SignatureAlgorithm;
import org.keycloak.saml.common.constants.JBossSAMLConstants;
import org.keycloak.saml.common.constants.JBossSAMLURIConstants;
import org.keycloak.saml.common.exceptions.ConfigurationException;
import org.keycloak.saml.common.exceptions.ProcessingException;
import org.keycloak.saml.common.util.DocumentUtil;
import org.keycloak.saml.processing.api.saml.v2.sig.SAML2Signature;
import org.keycloak.saml.processing.core.saml.v2.common.SAMLDocumentHolder;
import org.keycloak.saml.processing.core.saml.v2.util.AssertionUtil;
import org.keycloak.saml.processing.core.util.KeycloakKeySamlExtensionGenerator;
import org.keycloak.saml.processing.core.util.XMLEncryptionUtil;
import org.keycloak.saml.processing.web.util.PostBindingUtil;
import org.keycloak.saml.validators.ConditionsValidator;
import org.keycloak.saml.validators.DestinationValidator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class AbstractSamlAuthenticationHandler
implements SamlAuthenticationHandler {
    protected static Logger log = Logger.getLogger(WebBrowserSsoAuthenticationHandler.class);
    protected final HttpFacade facade;
    protected final SamlSessionStore sessionStore;
    protected final SamlDeployment deployment;
    protected AuthChallenge challenge;
    private final DestinationValidator destinationValidator = DestinationValidator.forProtocolMap(null);
    private static final AuthChallenge CHALLENGE_EXTRACTION_FAILURE = new AuthChallenge(){

        public boolean challenge(HttpFacade exchange) {
            SamlAuthenticationError error = new SamlAuthenticationError(SamlAuthenticationError.Reason.EXTRACTION_FAILURE);
            exchange.getRequest().setError((AuthenticationError)error);
            exchange.getResponse().sendError(403);
            return true;
        }

        public int getResponseCode() {
            return 403;
        }
    };
    private static final AuthChallenge CHALLENGE_INVALID_SIGNATURE = new AuthChallenge(){

        public boolean challenge(HttpFacade exchange) {
            SamlAuthenticationError error = new SamlAuthenticationError(SamlAuthenticationError.Reason.INVALID_SIGNATURE);
            exchange.getRequest().setError((AuthenticationError)error);
            exchange.getResponse().sendError(403);
            return true;
        }

        public int getResponseCode() {
            return 403;
        }
    };

    public AbstractSamlAuthenticationHandler(HttpFacade facade, SamlDeployment deployment, SamlSessionStore sessionStore) {
        this.facade = facade;
        this.deployment = deployment;
        this.sessionStore = sessionStore;
    }

    public AuthOutcome doHandle(SamlInvocationContext context, OnSessionCreated onCreateSession) {
        String samlRequest = context.getSamlRequest();
        String samlResponse = context.getSamlResponse();
        String relayState = context.getRelayState();
        if (samlRequest != null) {
            return this.handleSamlRequest(samlRequest, relayState);
        }
        if (samlResponse != null) {
            return this.handleSamlResponse(samlResponse, relayState, onCreateSession);
        }
        if (this.sessionStore.isLoggedIn()) {
            if (this.verifySSL()) {
                return this.failedTerminal();
            }
            log.debug((Object)"AUTHENTICATED: was cached");
            return this.handleRequest();
        }
        return this.initiateLogin();
    }

    protected AuthOutcome handleRequest() {
        return AuthOutcome.AUTHENTICATED;
    }

    @Override
    public AuthChallenge getChallenge() {
        return this.challenge;
    }

    protected AuthOutcome handleSamlRequest(String samlRequest, String relayState) {
        SAMLDocumentHolder holder = null;
        boolean postBinding = false;
        String requestUri = this.facade.getRequest().getURI();
        if (this.facade.getRequest().getMethod().equalsIgnoreCase("GET")) {
            int index = requestUri.indexOf(63);
            if (index > -1) {
                requestUri = requestUri.substring(0, index);
            }
            holder = SAMLRequestParser.parseRequestRedirectBinding((String)samlRequest);
        } else {
            postBinding = true;
            holder = SAMLRequestParser.parseRequestPostBinding((String)samlRequest);
        }
        if (holder == null) {
            log.error((Object)"Error parsing SAML document");
            return this.failedTerminal();
        }
        RequestAbstractType requestAbstractType = (RequestAbstractType)holder.getSamlObject();
        if (requestAbstractType.getDestination() == null && this.containsUnencryptedSignature(holder, postBinding)) {
            log.error((Object)"Destination field required.");
            return this.failed(CHALLENGE_EXTRACTION_FAILURE);
        }
        if (!this.destinationValidator.validate(requestUri, requestAbstractType.getDestination())) {
            log.error((Object)("Expected destination '" + requestUri + "' got '" + requestAbstractType.getDestination() + "'"));
            return this.failedTerminal();
        }
        if (requestAbstractType instanceof LogoutRequestType) {
            if (this.deployment.getIDP().getSingleLogoutService().validateRequestSignature()) {
                try {
                    this.validateSamlSignature(holder, postBinding, "SAMLRequest");
                }
                catch (VerificationException e) {
                    log.error((Object)"Failed to verify saml request signature", (Throwable)e);
                    return this.failedTerminal();
                }
            }
            LogoutRequestType logout = (LogoutRequestType)requestAbstractType;
            return this.logoutRequest(logout, relayState);
        }
        log.error((Object)"unknown SAML request type");
        return this.failedTerminal();
    }

    protected abstract AuthOutcome logoutRequest(LogoutRequestType var1, String var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AuthOutcome handleSamlResponse(String samlResponse, String relayState, OnSessionCreated onCreateSession) {
        SAMLDocumentHolder holder = null;
        boolean postBinding = false;
        String requestUri = this.facade.getRequest().getURI();
        if (this.facade.getRequest().getMethod().equalsIgnoreCase("GET")) {
            int index = requestUri.indexOf(63);
            if (index > -1) {
                requestUri = requestUri.substring(0, index);
            }
            holder = this.extractRedirectBindingResponse(samlResponse);
        } else {
            postBinding = true;
            holder = this.extractPostBindingResponse(samlResponse);
        }
        if (holder == null) {
            log.error((Object)"Error parsing SAML document");
            return this.failed(CHALLENGE_EXTRACTION_FAILURE);
        }
        StatusResponseType statusResponse = (StatusResponseType)holder.getSamlObject();
        if (statusResponse.getDestination() == null && this.containsUnencryptedSignature(holder, postBinding)) {
            log.error((Object)"Destination field required.");
            return this.failed(CHALLENGE_EXTRACTION_FAILURE);
        }
        if (!this.destinationValidator.validate(requestUri, statusResponse.getDestination())) {
            log.error((Object)("Request URI '" + requestUri + "' does not match SAML request destination '" + statusResponse.getDestination() + "'"));
            return this.failedTerminal();
        }
        if (statusResponse instanceof ResponseType) {
            try {
                if (this.deployment.getIDP().getSingleSignOnService().validateResponseSignature()) {
                    try {
                        this.validateSamlSignature(holder, postBinding, "SAMLResponse");
                    }
                    catch (VerificationException e) {
                        log.error((Object)"Failed to verify saml response signature", (Throwable)e);
                        AuthOutcome authOutcome = this.failed(CHALLENGE_INVALID_SIGNATURE);
                        this.sessionStore.setCurrentAction(SamlSessionStore.CurrentAction.NONE);
                        return authOutcome;
                    }
                }
                AuthOutcome e = this.handleLoginResponse(holder, postBinding, onCreateSession);
                return e;
            }
            finally {
                this.sessionStore.setCurrentAction(SamlSessionStore.CurrentAction.NONE);
            }
        }
        if (this.sessionStore.isLoggingOut()) {
            try {
                if (this.deployment.getIDP().getSingleLogoutService().validateResponseSignature()) {
                    try {
                        this.validateSamlSignature(holder, postBinding, "SAMLResponse");
                    }
                    catch (VerificationException e) {
                        log.error((Object)"Failed to verify saml response signature", (Throwable)e);
                        AuthOutcome authOutcome = this.failedTerminal();
                        this.sessionStore.setCurrentAction(SamlSessionStore.CurrentAction.NONE);
                        return authOutcome;
                    }
                }
                AuthOutcome e = this.handleLogoutResponse(holder, statusResponse, relayState);
                return e;
            }
            finally {
                this.sessionStore.setCurrentAction(SamlSessionStore.CurrentAction.NONE);
            }
        }
        if (this.sessionStore.isLoggingIn()) {
            try {
                StatusType status = statusResponse.getStatus();
                if (this.checkStatusCodeValue(status.getStatusCode(), JBossSAMLURIConstants.STATUS_RESPONDER.get()) && this.checkStatusCodeValue(status.getStatusCode().getStatusCode(), JBossSAMLURIConstants.STATUS_NO_PASSIVE.get())) {
                    log.debug((Object)("Not authenticated due passive mode Status found in SAML response: " + status.toString()));
                    AuthOutcome authOutcome = AuthOutcome.NOT_AUTHENTICATED;
                    return authOutcome;
                }
                AuthOutcome authOutcome = this.failed(AbstractSamlAuthenticationHandler.createAuthChallenge403(statusResponse));
                return authOutcome;
            }
            finally {
                this.sessionStore.setCurrentAction(SamlSessionStore.CurrentAction.NONE);
            }
        }
        log.warn((Object)"Keycloak Adapter obtained Response, that is not understood. This may be because the containers cookies are not properly configured with SameSite settings. Refer to KEYCLOAK-14103 for more details.");
        return AuthOutcome.NOT_ATTEMPTED;
    }

    private boolean containsUnencryptedSignature(SAMLDocumentHolder documentHolder, boolean postBinding) {
        if (postBinding) {
            Document signedDoc = documentHolder.getSamlDocument();
            NodeList nl = signedDoc.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature");
            return nl != null && nl.getLength() > 0;
        }
        String algorithm = this.facade.getRequest().getQueryParamValue("SigAlg");
        return algorithm != null;
    }

    private void validateSamlSignature(SAMLDocumentHolder holder, boolean postBinding, String paramKey) throws VerificationException {
        KeyLocator signatureValidationKey = this.deployment.getIDP().getSignatureValidationKeyLocator();
        if (postBinding) {
            this.verifyPostBindingSignature(holder.getSamlDocument(), signatureValidationKey);
        } else {
            String keyId = this.getMessageSigningKeyId(holder.getSamlObject());
            this.verifyRedirectBindingSignature(paramKey, signatureValidationKey, keyId);
        }
    }

    private String getMessageSigningKeyId(SAML2Object doc) {
        ExtensionsType extensions;
        if (doc instanceof RequestAbstractType) {
            extensions = ((RequestAbstractType)doc).getExtensions();
        } else if (doc instanceof StatusResponseType) {
            extensions = ((StatusResponseType)doc).getExtensions();
        } else {
            return null;
        }
        if (extensions == null) {
            return null;
        }
        for (Object ext : extensions.getAny()) {
            String res;
            if (!(ext instanceof Element) || (res = KeycloakKeySamlExtensionGenerator.getMessageSigningKeyIdFromElement((Element)((Element)ext))) == null) continue;
            return res;
        }
        return null;
    }

    private boolean checkStatusCodeValue(StatusCodeType statusCode, String expectedValue) {
        if (statusCode != null && statusCode.getValue() != null) {
            String v = statusCode.getValue().toString();
            return expectedValue.equals(v);
        }
        return false;
    }

    protected AuthOutcome handleLoginResponse(SAMLDocumentHolder responseHolder, boolean postBinding, OnSessionCreated onCreateSession) {
        String nameFormatString;
        SubjectType subject;
        SubjectType.STSubType subType;
        if (!this.sessionStore.isLoggingIn()) {
            log.warn((Object)"Adapter obtained LoginResponse, however containers session is not aware of sending any request. This may be because the session cookies created by container are not properly configured with SameSite settings. Refer to KEYCLOAK-14103 for more details.");
        }
        ResponseType responseType = (ResponseType)responseHolder.getSamlObject();
        AssertionType assertion = null;
        if (!this.isSuccessfulSamlResponse(responseType) || responseType.getAssertions() == null || responseType.getAssertions().isEmpty()) {
            return this.failed(AbstractSamlAuthenticationHandler.createAuthChallenge403((StatusResponseType)responseType));
        }
        try {
            assertion = AssertionUtil.getAssertion((SAMLDocumentHolder)responseHolder, (ResponseType)responseType, (PrivateKey)this.deployment.getDecryptionKey());
            ConditionsValidator.Builder cvb = new ConditionsValidator.Builder(assertion.getID(), (CommonConditionsType)assertion.getConditions(), this.destinationValidator);
            try {
                cvb.clockSkewInMillis(this.deployment.getIDP().getAllowedClockSkew());
                cvb.addAllowedAudience(new URI[]{URI.create(this.deployment.getEntityID())});
                if (responseType.getDestination() != null) {
                    cvb.addAllowedAudience(new URI[]{URI.create(responseType.getDestination())});
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (!cvb.build().isValid()) {
                return this.initiateLogin();
            }
        }
        catch (Exception e) {
            log.error((Object)("Error extracting SAML assertion: " + e.getMessage()));
            return this.failed(CHALLENGE_EXTRACTION_FAILURE);
        }
        Element assertionElement = null;
        if (this.deployment.getIDP().getSingleSignOnService().validateAssertionSignature()) {
            try {
                assertionElement = this.getAssertionFromResponse(responseHolder);
                if (!AssertionUtil.isSignatureValid((Element)assertionElement, (KeyLocator)this.deployment.getIDP().getSignatureValidationKeyLocator())) {
                    log.error((Object)"Failed to verify saml assertion signature");
                    return this.failed(CHALLENGE_INVALID_SIGNATURE);
                }
            }
            catch (Exception e) {
                log.error((Object)("Error processing validation of SAML assertion: " + e.getMessage()));
                return this.failed(CHALLENGE_EXTRACTION_FAILURE);
            }
        }
        NameIDType subjectNameID = (subType = (subject = assertion.getSubject()).getSubType()) == null ? null : (NameIDType)subType.getBaseID();
        String principalName = subjectNameID == null ? null : subjectNameID.getValue();
        Set<String> roles = new HashSet<String>();
        MultivaluedHashMap attributes = new MultivaluedHashMap();
        MultivaluedHashMap friendlyAttributes = new MultivaluedHashMap();
        Set statements = assertion.getStatements();
        for (Object statement : statements) {
            if (!(statement instanceof AttributeStatementType)) continue;
            AttributeStatementType attributeStatement = (AttributeStatementType)statement;
            List attList = attributeStatement.getAttributes();
            for (AttributeStatementType.ASTChoiceType obj : attList) {
                List attributeValues;
                AttributeType attr = obj.getAttribute();
                if (this.isRole(attr)) {
                    attributeValues = attr.getAttributeValue();
                    if (attributeValues == null) continue;
                    for (Object attrValue : attributeValues) {
                        String role = this.getAttributeValue(attrValue);
                        log.debugv("Add role: {0}", (Object)role);
                        roles.add(role);
                    }
                    continue;
                }
                attributeValues = attr.getAttributeValue();
                if (attributeValues == null) continue;
                for (Object attrValue : attributeValues) {
                    String value = this.getAttributeValue(attrValue);
                    if (attr.getName() != null) {
                        attributes.add((Object)attr.getName(), (Object)value);
                    }
                    if (attr.getFriendlyName() == null) continue;
                    friendlyAttributes.add((Object)attr.getFriendlyName(), (Object)value);
                }
            }
        }
        if (this.deployment.getPrincipalNamePolicy() == SamlDeployment.PrincipalNamePolicy.FROM_ATTRIBUTE && this.deployment.getPrincipalAttributeName() != null) {
            String attribute = (String)attributes.getFirst((Object)this.deployment.getPrincipalAttributeName());
            if (attribute != null) {
                principalName = attribute;
            } else {
                attribute = (String)friendlyAttributes.getFirst((Object)this.deployment.getPrincipalAttributeName());
                if (attribute != null) {
                    principalName = attribute;
                }
            }
        }
        if (this.deployment.getRoleMappingsProvider() != null) {
            roles = this.deployment.getRoleMappingsProvider().map(principalName, roles);
        }
        attributes.put((Object)"Roles", new ArrayList<String>(roles));
        AuthnStatementType authn = null;
        for (Object statement : assertion.getStatements()) {
            if (!(statement instanceof AuthnStatementType)) continue;
            authn = (AuthnStatementType)statement;
            break;
        }
        URI nameFormat = subjectNameID == null ? null : subjectNameID.getFormat();
        String string = nameFormatString = nameFormat == null ? JBossSAMLURIConstants.NAMEID_FORMAT_UNSPECIFIED.get() : nameFormat.toString();
        if (this.deployment.isKeepDOMAssertion() && assertionElement == null) {
            assertionElement = this.getAssertionFromResponseNoException(responseHolder);
        }
        SamlPrincipal principal = new SamlPrincipal(assertion, this.deployment.isKeepDOMAssertion() ? this.getAssertionDocumentFromElement(assertionElement) : null, principalName, principalName, nameFormatString, attributes, friendlyAttributes);
        String sessionIndex = authn == null ? null : authn.getSessionIndex();
        XMLGregorianCalendar sessionNotOnOrAfter = authn == null ? null : authn.getSessionNotOnOrAfter();
        SamlSession account = new SamlSession(principal, roles, sessionIndex, sessionNotOnOrAfter);
        this.sessionStore.saveAccount(account);
        onCreateSession.onSessionCreated(account);
        String redirectUri = this.sessionStore.getRedirectUri();
        if (redirectUri != null) {
            this.facade.getResponse().setHeader("Location", redirectUri);
            this.facade.getResponse().setStatus(302);
            this.facade.getResponse().end();
        } else {
            log.debug((Object)"IDP initiated invocation");
        }
        log.debug((Object)"AUTHENTICATED authn");
        return AuthOutcome.AUTHENTICATED;
    }

    private AuthOutcome failed(AuthChallenge challenge) {
        this.challenge = challenge;
        return AuthOutcome.FAILED;
    }

    private AuthOutcome failedTerminal() {
        return this.failed(null);
    }

    private boolean isSuccessfulSamlResponse(ResponseType responseType) {
        return responseType != null && responseType.getStatus() != null && responseType.getStatus().getStatusCode() != null && responseType.getStatus().getStatusCode().getValue() != null && Objects.equals(responseType.getStatus().getStatusCode().getValue().toString(), JBossSAMLURIConstants.STATUS_SUCCESS.get());
    }

    private Element getAssertionFromResponse(SAMLDocumentHolder responseHolder) throws ConfigurationException, ProcessingException {
        Element encryptedAssertion = DocumentUtil.getElement((Document)responseHolder.getSamlDocument(), (QName)new QName(JBossSAMLConstants.ENCRYPTED_ASSERTION.get()));
        if (encryptedAssertion != null) {
            Document encryptedAssertionDocument = DocumentUtil.createDocument();
            encryptedAssertionDocument.appendChild(encryptedAssertionDocument.importNode(encryptedAssertion, true));
            return XMLEncryptionUtil.decryptElementInDocument((Document)encryptedAssertionDocument, data -> Collections.singletonList(this.deployment.getDecryptionKey()));
        }
        return DocumentUtil.getElement((Document)responseHolder.getSamlDocument(), (QName)new QName(JBossSAMLConstants.ASSERTION.get()));
    }

    private Element getAssertionFromResponseNoException(SAMLDocumentHolder responseHolder) {
        try {
            return this.getAssertionFromResponse(responseHolder);
        }
        catch (ConfigurationException | ProcessingException e) {
            log.warn((Object)"Cannot obtain DOM assertion element", e);
            return null;
        }
    }

    private Document getAssertionDocumentFromElement(Element assertionElement) {
        if (assertionElement == null) {
            return null;
        }
        try {
            Document assertionDoc = DocumentUtil.createDocument();
            assertionDoc.adoptNode(assertionElement);
            assertionDoc.appendChild(assertionElement);
            return assertionDoc;
        }
        catch (ConfigurationException e) {
            log.warn((Object)"Cannot obtain DOM assertion document", (Throwable)e);
            return null;
        }
    }

    private String getAttributeValue(Object attrValue) {
        if (attrValue == null) {
            return "";
        }
        if (attrValue instanceof String) {
            return (String)attrValue;
        }
        if (attrValue instanceof Node) {
            Node roleNode = (Node)attrValue;
            return roleNode.getFirstChild().getNodeValue();
        }
        if (attrValue instanceof NameIDType) {
            NameIDType nameIdType = (NameIDType)attrValue;
            return nameIdType.getValue();
        }
        log.warn((Object)("Unable to extract unknown SAML assertion attribute value type: " + attrValue.getClass().getName()));
        return null;
    }

    protected boolean isRole(AttributeType attribute) {
        return attribute.getName() != null && this.deployment.getRoleAttributeNames().contains(attribute.getName()) || attribute.getFriendlyName() != null && this.deployment.getRoleAttributeNames().contains(attribute.getFriendlyName());
    }

    protected AuthOutcome handleLogoutResponse(SAMLDocumentHolder holder, StatusResponseType responseType, String relayState) {
        boolean loggedIn = this.sessionStore.isLoggedIn();
        if (!loggedIn || !"logout".equals(relayState)) {
            return AuthOutcome.NOT_ATTEMPTED;
        }
        this.sessionStore.logoutAccount();
        return AuthOutcome.LOGGED_OUT;
    }

    protected SAMLDocumentHolder extractRedirectBindingResponse(String response) {
        return SAMLRequestParser.parseRequestRedirectBinding((String)response);
    }

    protected SAMLDocumentHolder extractPostBindingResponse(String response) {
        byte[] samlBytes = PostBindingUtil.base64Decode((String)response);
        return SAMLRequestParser.parseResponseDocument((byte[])samlBytes);
    }

    protected AuthOutcome initiateLogin() {
        this.challenge = this.createChallenge();
        return AuthOutcome.NOT_ATTEMPTED;
    }

    protected AbstractInitiateLogin createChallenge() {
        return new AbstractInitiateLogin(this.deployment, this.sessionStore){

            @Override
            protected void sendAuthnRequest(HttpFacade httpFacade, SAML2AuthnRequestBuilder authnRequestBuilder, BaseSAML2BindingBuilder binding) throws ProcessingException, ConfigurationException, IOException {
                if (AbstractSamlAuthenticationHandler.this.isAutodetectedBearerOnly(httpFacade.getRequest())) {
                    httpFacade.getResponse().setStatus(401);
                    httpFacade.getResponse().end();
                } else {
                    Document document = authnRequestBuilder.toDocument();
                    SamlDeployment.Binding samlBinding = this.deployment.getIDP().getSingleSignOnService().getRequestBinding();
                    SamlUtil.sendSaml(true, httpFacade, this.deployment.getIDP().getSingleSignOnService().getRequestBindingUrl(), binding, document, samlBinding);
                }
            }
        };
    }

    protected boolean verifySSL() {
        if (!this.facade.getRequest().isSecure() && this.deployment.getSslRequired().isRequired(this.facade.getRequest().getRemoteAddr())) {
            log.warn((Object)"SSL is required to authenticate");
            return true;
        }
        return false;
    }

    public void verifyPostBindingSignature(Document document, KeyLocator keyLocator) throws VerificationException {
        SAML2Signature saml2Signature = new SAML2Signature();
        try {
            if (!saml2Signature.validate(document, keyLocator)) {
                throw new VerificationException("Invalid signature on document");
            }
        }
        catch (ProcessingException e) {
            throw new VerificationException("Error validating signature", (Throwable)e);
        }
    }

    private void verifyRedirectBindingSignature(String paramKey, KeyLocator keyLocator, String keyId) throws VerificationException {
        String request = this.facade.getRequest().getQueryParamValue(paramKey);
        String algorithm = this.facade.getRequest().getQueryParamValue("SigAlg");
        String signature = this.facade.getRequest().getQueryParamValue("Signature");
        String decodedAlgorithm = this.facade.getRequest().getQueryParamValue("SigAlg");
        if (request == null) {
            throw new VerificationException("SAML Request was null");
        }
        if (algorithm == null) {
            throw new VerificationException("SigAlg was null");
        }
        if (signature == null) {
            throw new VerificationException("Signature was null");
        }
        String relayState = this.facade.getRequest().getQueryParamValue("RelayState");
        KeycloakUriBuilder builder = KeycloakUriBuilder.fromPath((String)"/").queryParam(paramKey, new Object[]{request});
        if (relayState != null) {
            builder.queryParam("RelayState", new Object[]{relayState});
        }
        builder.queryParam("SigAlg", new Object[]{algorithm});
        String rawQuery = builder.build(new Object[0]).getRawQuery();
        try {
            byte[] decodedSignature = Base64.decode((String)signature);
            byte[] rawQueryBytes = rawQuery.getBytes("UTF-8");
            SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.getFromXmlMethod((String)decodedAlgorithm);
            if (!this.validateRedirectBindingSignature(signatureAlgorithm, rawQueryBytes, decodedSignature, keyLocator, keyId)) {
                throw new VerificationException("Invalid query param signature");
            }
        }
        catch (Exception e) {
            throw new VerificationException((Throwable)e);
        }
    }

    private boolean validateRedirectBindingSignature(SignatureAlgorithm sigAlg, byte[] rawQueryBytes, byte[] decodedSignature, KeyLocator locator, String keyId) throws KeyManagementException, VerificationException {
        try {
            try {
                boolean keyLocated;
                Key key = locator.getKey(keyId);
                boolean bl = keyLocated = key != null;
                if (keyLocated) {
                    return this.validateRedirectBindingSignatureForKey(sigAlg, rawQueryBytes, decodedSignature, key);
                }
            }
            catch (KeyManagementException keyManagementException) {}
        }
        catch (SignatureException ex) {
            log.debug("Verification failed for key %s: %s", (Object)keyId, (Throwable)ex);
            log.trace((Object)ex);
        }
        if (locator instanceof Iterable) {
            Iterable availableKeys = (Iterable)locator;
            log.trace((Object)"Trying hard to validate XML signature using all available keys.");
            for (Key key : availableKeys) {
                try {
                    if (!this.validateRedirectBindingSignatureForKey(sigAlg, rawQueryBytes, decodedSignature, key)) continue;
                    return true;
                }
                catch (SignatureException ex) {
                    log.debug((Object)"Verification failed: %s", (Throwable)ex);
                }
            }
        }
        return false;
    }

    private boolean validateRedirectBindingSignatureForKey(SignatureAlgorithm sigAlg, byte[] rawQueryBytes, byte[] decodedSignature, Key key) throws SignatureException {
        if (key == null) {
            return false;
        }
        if (!(key instanceof PublicKey)) {
            log.warnf("Unusable key for signature validation: %s", (Object)key);
            return false;
        }
        Signature signature = sigAlg.createSignature();
        try {
            signature.initVerify((PublicKey)key);
        }
        catch (InvalidKeyException ex) {
            log.warnf((Throwable)ex, "Unusable key for signature validation: %s", (Object)key);
            return false;
        }
        signature.update(rawQueryBytes);
        return signature.verify(decodedSignature);
    }

    protected boolean isAutodetectedBearerOnly(HttpFacade.Request request) {
        if (!this.deployment.isAutodetectBearerOnly()) {
            return false;
        }
        String headerValue = this.facade.getRequest().getHeader("X-Requested-With");
        if (headerValue != null && headerValue.equalsIgnoreCase("XMLHttpRequest")) {
            return true;
        }
        headerValue = this.facade.getRequest().getHeader("Faces-Request");
        if (headerValue != null && headerValue.startsWith("partial/")) {
            return true;
        }
        headerValue = this.facade.getRequest().getHeader("SOAPAction");
        if (headerValue != null) {
            return true;
        }
        List<String> accepts = this.facade.getRequest().getHeaders("Accept");
        if (accepts == null) {
            accepts = Collections.emptyList();
        }
        for (String accept : accepts) {
            if (!accept.contains("text/html") && !accept.contains("text/*") && !accept.contains("*/*")) continue;
            return false;
        }
        return true;
    }

    private static AuthChallenge createAuthChallenge(final int httpError, final SamlAuthenticationError error) {
        return new AuthChallenge(){

            public boolean challenge(HttpFacade exchange) {
                exchange.getRequest().setError((AuthenticationError)error);
                exchange.getResponse().sendError(httpError);
                return true;
            }

            public int getResponseCode() {
                return httpError;
            }
        };
    }

    private static AuthChallenge createAuthChallenge403(StatusResponseType responseType) {
        return AbstractSamlAuthenticationHandler.createAuthChallenge(403, new SamlAuthenticationError(SamlAuthenticationError.Reason.ERROR_STATUS, responseType));
    }
}

