/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.undertow;

import io.undertow.server.HttpServerExchange;
import io.undertow.server.session.Session;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.handlers.ServletRequestContext;
import io.undertow.servlet.spec.HttpSessionImpl;
import io.undertow.servlet.spec.ServletContextImpl;
import java.lang.reflect.Method;
import java.security.AccessController;
import javax.servlet.http.HttpSession;

public class ChangeSessionId {
    public static void turnOffChangeSessionIdOnLogin(DeploymentInfo deploymentInfo) {
        try {
            Method method = DeploymentInfo.class.getMethod("setChangeSessionIdOnLogin", Boolean.TYPE);
            method.invoke((Object)deploymentInfo, false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String changeSessionId(HttpServerExchange exchange, boolean create) {
        ServletRequestContext sc = (ServletRequestContext)exchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
        ServletContextImpl currentServletContext = sc.getCurrentServletContext();
        HttpSessionImpl session = currentServletContext.getSession(exchange, create);
        if (session == null) {
            return null;
        }
        Session underlyingSession = System.getSecurityManager() == null ? session.getSession() : (Session)AccessController.doPrivileged(new HttpSessionImpl.UnwrapSessionAction((HttpSession)session));
        return underlyingSession.changeSessionId(exchange, currentServletContext.getSessionConfig());
    }
}

