/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.saml.undertow;

import io.undertow.security.api.SecurityContext;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.session.SessionListener;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.handlers.ServletRequestContext;
import io.undertow.util.Headers;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.jboss.logging.Logger;
import org.keycloak.adapters.saml.SamlDeployment;
import org.keycloak.adapters.saml.SamlDeploymentContext;
import org.keycloak.adapters.saml.SamlSessionStore;
import org.keycloak.adapters.saml.undertow.AbstractSamlAuthMech;
import org.keycloak.adapters.saml.undertow.IdMapperUpdaterSessionListener;
import org.keycloak.adapters.saml.undertow.ServletSamlSessionStore;
import org.keycloak.adapters.spi.HttpFacade;
import org.keycloak.adapters.spi.InMemorySessionIdMapper;
import org.keycloak.adapters.spi.SessionIdMapper;
import org.keycloak.adapters.spi.SessionIdMapperUpdater;
import org.keycloak.adapters.undertow.ServletHttpFacade;
import org.keycloak.adapters.undertow.UndertowHttpFacade;
import org.keycloak.adapters.undertow.UndertowUserSessionManagement;

public class ServletSamlAuthMech
extends AbstractSamlAuthMech {
    private static final Logger LOG = Logger.getLogger(ServletSamlAuthMech.class);
    protected SessionIdMapper idMapper = new InMemorySessionIdMapper();
    protected SessionIdMapperUpdater idMapperUpdater = SessionIdMapperUpdater.DIRECT;

    public ServletSamlAuthMech(SamlDeploymentContext deploymentContext, UndertowUserSessionManagement sessionManagement, String errorPage) {
        super(deploymentContext, sessionManagement, errorPage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTokenStoreUpdaters(DeploymentInfo deploymentInfo) {
        deploymentInfo.addSessionListener((SessionListener)new IdMapperUpdaterSessionListener(this.idMapper));
        SessionIdMapperUpdater updater = SessionIdMapperUpdater.EXTERNAL;
        try {
            String idMapperSessionUpdaterClasses;
            Map initParameters = deploymentInfo.getInitParameters();
            String string = idMapperSessionUpdaterClasses = initParameters == null ? null : (String)initParameters.get("keycloak.sessionIdMapperUpdater.classes");
            if (idMapperSessionUpdaterClasses == null) {
                return;
            }
            for (String clazz : idMapperSessionUpdaterClasses.split("\\s*,\\s*")) {
                if (clazz.isEmpty()) continue;
                updater = this.invokeAddTokenStoreUpdaterMethod(clazz, deploymentInfo, updater);
            }
        }
        finally {
            this.setIdMapperUpdater(updater);
        }
    }

    private SessionIdMapperUpdater invokeAddTokenStoreUpdaterMethod(String idMapperSessionUpdaterClass, DeploymentInfo deploymentInfo, SessionIdMapperUpdater previousIdMapperUpdater) {
        try {
            Class<?> clazz = deploymentInfo.getClassLoader().loadClass(idMapperSessionUpdaterClass);
            Method addTokenStoreUpdatersMethod = clazz.getMethod("addTokenStoreUpdaters", DeploymentInfo.class, SessionIdMapper.class, SessionIdMapperUpdater.class);
            if (!(Modifier.isStatic(addTokenStoreUpdatersMethod.getModifiers()) && Modifier.isPublic(addTokenStoreUpdatersMethod.getModifiers()) && SessionIdMapperUpdater.class.isAssignableFrom(addTokenStoreUpdatersMethod.getReturnType()))) {
                LOG.errorv("addTokenStoreUpdaters method in class {0} has to be public static. Ignoring class.", (Object)idMapperSessionUpdaterClass);
                return previousIdMapperUpdater;
            }
            LOG.debugv("Initializing sessionIdMapperUpdater class {0}", (Object)idMapperSessionUpdaterClass);
            return (SessionIdMapperUpdater)addTokenStoreUpdatersMethod.invoke(null, deploymentInfo, this.idMapper, previousIdMapperUpdater);
        }
        catch (ClassNotFoundException | NoSuchMethodException | SecurityException ex) {
            LOG.warnv((Throwable)ex, "Cannot use sessionIdMapperUpdater class {0}", (Object)idMapperSessionUpdaterClass);
            return previousIdMapperUpdater;
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
            LOG.warnv((Throwable)ex, "Cannot use {0}.addTokenStoreUpdaters(DeploymentInfo, SessionIdMapper) method", (Object)idMapperSessionUpdaterClass);
            return previousIdMapperUpdater;
        }
    }

    @Override
    protected SamlSessionStore getTokenStore(HttpServerExchange exchange, HttpFacade facade, SamlDeployment deployment, SecurityContext securityContext) {
        return new ServletSamlSessionStore(exchange, this.sessionManagement, securityContext, this.idMapper, this.idMapperUpdater, deployment);
    }

    @Override
    protected UndertowHttpFacade createFacade(HttpServerExchange exchange) {
        return new ServletHttpFacade(exchange);
    }

    @Override
    protected void redirectLogout(SamlDeployment deployment, HttpServerExchange exchange) {
        exchange.getResponseHeaders().add(Headers.CACHE_CONTROL, "no-cache, no-store, must-revalidate");
        exchange.getResponseHeaders().add(Headers.PRAGMA, "no-cache");
        exchange.getResponseHeaders().add(Headers.EXPIRES, "0");
        super.redirectLogout(deployment, exchange);
    }

    @Override
    protected Integer servePage(HttpServerExchange exchange, String location) {
        ServletRequestContext servletRequestContext = (ServletRequestContext)exchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
        ServletRequest req = servletRequestContext.getServletRequest();
        ServletResponse resp = servletRequestContext.getServletResponse();
        RequestDispatcher disp = req.getRequestDispatcher(location);
        exchange.getResponseHeaders().add(Headers.CACHE_CONTROL, "no-cache, no-store, must-revalidate");
        exchange.getResponseHeaders().add(Headers.PRAGMA, "no-cache");
        exchange.getResponseHeaders().add(Headers.EXPIRES, "0");
        try {
            disp.forward(req, resp);
        }
        catch (ServletException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    public SessionIdMapperUpdater getIdMapperUpdater() {
        return this.idMapperUpdater;
    }

    protected void setIdMapperUpdater(SessionIdMapperUpdater idMapperUpdater) {
        this.idMapperUpdater = idMapperUpdater;
    }
}

