/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.saml.elytron;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.EventListener;
import java.util.LinkedList;
import java.util.Objects;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.jboss.logging.Logger;
import org.keycloak.adapters.saml.DefaultSamlDeployment;
import org.keycloak.adapters.saml.SamlConfigResolver;
import org.keycloak.adapters.saml.SamlDeployment;
import org.keycloak.adapters.saml.SamlDeploymentContext;
import org.keycloak.adapters.saml.config.parsers.DeploymentBuilder;
import org.keycloak.adapters.saml.config.parsers.ResourceLoader;
import org.keycloak.adapters.saml.elytron.IdMapperUpdaterSessionListener;
import org.keycloak.adapters.saml.elytron.infinispan.InfinispanSessionCacheIdMapperUpdater;
import org.keycloak.adapters.spi.InMemorySessionIdMapper;
import org.keycloak.adapters.spi.SessionIdMapper;
import org.keycloak.adapters.spi.SessionIdMapperUpdater;
import org.keycloak.saml.common.exceptions.ParsingException;

public class KeycloakConfigurationServletListener
implements ServletContextListener {
    protected static Logger log = Logger.getLogger(KeycloakConfigurationServletListener.class);
    public static final String ADAPTER_DEPLOYMENT_CONTEXT_ATTRIBUTE = SamlDeploymentContext.class.getName();
    public static final String ADAPTER_DEPLOYMENT_CONTEXT_ATTRIBUTE_ELYTRON = SamlDeploymentContext.class.getName() + ".elytron";
    public static final String ADAPTER_SESSION_ID_MAPPER_ATTRIBUTE_ELYTRON = SessionIdMapper.class.getName() + ".elytron";
    public static final String ADAPTER_SESSION_ID_MAPPER_UPDATER_ATTRIBUTE_ELYTRON = SessionIdMapperUpdater.class.getName() + ".elytron";
    private final SessionIdMapper idMapper = new InMemorySessionIdMapper();
    private SessionIdMapperUpdater idMapperUpdater = SessionIdMapperUpdater.DIRECT;
    private Collection<AutoCloseable> toClose = new LinkedList<AutoCloseable>();

    public void contextInitialized(ServletContextEvent sce) {
        final ServletContext servletContext = sce.getServletContext();
        String configResolverClass = servletContext.getInitParameter("keycloak.config.resolver");
        SamlDeploymentContext deploymentContext = (SamlDeploymentContext)servletContext.getAttribute(SamlDeployment.class.getName());
        if (deploymentContext == null) {
            if (configResolverClass != null) {
                try {
                    SamlConfigResolver configResolver = (SamlConfigResolver)servletContext.getClassLoader().loadClass(configResolverClass).newInstance();
                    deploymentContext = new SamlDeploymentContext(configResolver);
                    log.infov("Using {0} to resolve Keycloak configuration on a per-request basis.", (Object)configResolverClass);
                }
                catch (Exception ex) {
                    log.errorv("The specified resolver {0} could NOT be loaded. Keycloak is unconfigured and will deny all requests. Reason: {1}", new Object[]{configResolverClass, ex.getMessage()});
                    deploymentContext = new SamlDeploymentContext((SamlDeployment)new DefaultSamlDeployment());
                }
            } else {
                DefaultSamlDeployment deployment;
                InputStream is = KeycloakConfigurationServletListener.getConfigInputStream(servletContext);
                if (is == null) {
                    log.warn((Object)"No adapter configuration.  Keycloak is unconfigured and will deny all requests.");
                    deployment = new DefaultSamlDeployment();
                } else {
                    try {
                        ResourceLoader loader = new ResourceLoader(){

                            public InputStream getResourceAsStream(String resource) {
                                return servletContext.getResourceAsStream(resource);
                            }
                        };
                        deployment = new DeploymentBuilder().build(is, loader);
                    }
                    catch (ParsingException e) {
                        throw new RuntimeException(e);
                    }
                }
                deploymentContext = new SamlDeploymentContext((SamlDeployment)deployment);
                log.debug((Object)"Keycloak is using a per-deployment configuration.");
            }
        }
        this.addTokenStoreUpdaters(servletContext);
        servletContext.setAttribute(ADAPTER_DEPLOYMENT_CONTEXT_ATTRIBUTE, (Object)deploymentContext);
        servletContext.setAttribute(ADAPTER_DEPLOYMENT_CONTEXT_ATTRIBUTE_ELYTRON, (Object)deploymentContext);
        servletContext.setAttribute(ADAPTER_SESSION_ID_MAPPER_ATTRIBUTE_ELYTRON, (Object)this.idMapper);
        servletContext.setAttribute(ADAPTER_SESSION_ID_MAPPER_UPDATER_ATTRIBUTE_ELYTRON, (Object)this.idMapperUpdater);
    }

    public void contextDestroyed(ServletContextEvent sce) {
        for (AutoCloseable c : this.toClose) {
            try {
                c.close();
            }
            catch (Exception e) {
                log.warnf((Throwable)e, "Exception while destroying servlet context", new Object[0]);
            }
        }
    }

    private static InputStream getConfigInputStream(ServletContext context) {
        InputStream is = KeycloakConfigurationServletListener.getXMLFromServletContext(context);
        if (is == null) {
            String path = context.getInitParameter("keycloak.config.file");
            if (path == null) {
                log.debug((Object)"using /WEB-INF/keycloak-saml.xml");
                is = context.getResourceAsStream("/WEB-INF/keycloak-saml.xml");
            } else {
                try {
                    is = new FileInputStream(path);
                }
                catch (FileNotFoundException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return is;
    }

    private static InputStream getXMLFromServletContext(ServletContext servletContext) {
        String json = servletContext.getInitParameter("org.keycloak.saml.xml.adapterConfig");
        if (json == null) {
            return null;
        }
        return new ByteArrayInputStream(json.getBytes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTokenStoreUpdaters(ServletContext servletContext) {
        SessionIdMapperUpdater updater = this.idMapperUpdater;
        servletContext.addListener((EventListener)((Object)new IdMapperUpdaterSessionListener(this.idMapper)));
        try {
            String idMapperSessionUpdaterClasses = servletContext.getInitParameter("keycloak.sessionIdMapperUpdater.classes");
            if (idMapperSessionUpdaterClasses == null) {
                return;
            }
            updater = SessionIdMapperUpdater.DIRECT;
            for (String clazz : idMapperSessionUpdaterClasses.split("\\s*,\\s*")) {
                if (clazz.isEmpty()) continue;
                if (Objects.equals("org.keycloak.adapters.saml.wildfly.infinispan.InfinispanSessionCacheIdMapperUpdater", clazz)) {
                    clazz = InfinispanSessionCacheIdMapperUpdater.class.getName();
                }
                if (!((updater = this.invokeAddTokenStoreUpdaterMethod(clazz, servletContext, updater)) instanceof AutoCloseable)) continue;
                this.toClose.add((AutoCloseable)updater);
            }
        }
        finally {
            this.setIdMapperUpdater(updater);
        }
    }

    private SessionIdMapperUpdater invokeAddTokenStoreUpdaterMethod(String idMapperSessionUpdaterClass, ServletContext servletContext, SessionIdMapperUpdater previousIdMapperUpdater) {
        try {
            Class<?> clazz = servletContext.getClassLoader().loadClass(idMapperSessionUpdaterClass);
            Method addTokenStoreUpdatersMethod = clazz.getMethod("addTokenStoreUpdaters", ServletContext.class, SessionIdMapper.class, SessionIdMapperUpdater.class);
            if (!(Modifier.isStatic(addTokenStoreUpdatersMethod.getModifiers()) && Modifier.isPublic(addTokenStoreUpdatersMethod.getModifiers()) && SessionIdMapperUpdater.class.isAssignableFrom(addTokenStoreUpdatersMethod.getReturnType()))) {
                log.errorv("addTokenStoreUpdaters method in class {0} has to be public static. Ignoring class.", (Object)idMapperSessionUpdaterClass);
                return previousIdMapperUpdater;
            }
            log.debugv("Initializing sessionIdMapperUpdater class {0}", (Object)idMapperSessionUpdaterClass);
            return (SessionIdMapperUpdater)addTokenStoreUpdatersMethod.invoke(null, servletContext, this.idMapper, previousIdMapperUpdater);
        }
        catch (ClassNotFoundException | NoSuchMethodException | SecurityException ex) {
            log.warnv((Throwable)ex, "Cannot use sessionIdMapperUpdater class {0}", (Object)idMapperSessionUpdaterClass);
            return previousIdMapperUpdater;
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
            log.warnv((Throwable)ex, "Cannot use {0}.addTokenStoreUpdaters(DeploymentInfo, SessionIdMapper) method", (Object)idMapperSessionUpdaterClass);
            return previousIdMapperUpdater;
        }
    }

    public SessionIdMapperUpdater getIdMapperUpdater() {
        return this.idMapperUpdater;
    }

    protected void setIdMapperUpdater(SessionIdMapperUpdater idMapperUpdater) {
        this.idMapperUpdater = idMapperUpdater;
    }
}

