/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.saml.elytron;

import jakarta.servlet.http.HttpSession;
import jakarta.servlet.http.HttpSessionAttributeListener;
import jakarta.servlet.http.HttpSessionBindingEvent;
import jakarta.servlet.http.HttpSessionEvent;
import jakarta.servlet.http.HttpSessionIdListener;
import jakarta.servlet.http.HttpSessionListener;
import java.util.Objects;
import org.jboss.logging.Logger;
import org.keycloak.adapters.saml.SamlSession;
import org.keycloak.adapters.spi.SessionIdMapper;

public class IdMapperUpdaterSessionListener
implements HttpSessionListener,
HttpSessionAttributeListener,
HttpSessionIdListener {
    private static final Logger LOG = Logger.getLogger(IdMapperUpdaterSessionListener.class);
    private final SessionIdMapper idMapper;

    public IdMapperUpdaterSessionListener(SessionIdMapper idMapper) {
        this.idMapper = idMapper;
    }

    public void sessionCreated(HttpSessionEvent hse) {
        LOG.debugf("Session created", new Object[0]);
        HttpSession session = hse.getSession();
        Object value = session.getAttribute(SamlSession.class.getName());
        this.map(session.getId(), value);
    }

    public void sessionDestroyed(HttpSessionEvent hse) {
        LOG.debugf("Session destroyed", new Object[0]);
        HttpSession session = hse.getSession();
        this.unmap(session.getId(), session.getAttribute(SamlSession.class.getName()));
    }

    public void sessionIdChanged(HttpSessionEvent hse, String oldSessionId) {
        LOG.debugf("Session changed ID from %s", (Object)oldSessionId);
        HttpSession session = hse.getSession();
        Object value = session.getAttribute(SamlSession.class.getName());
        this.unmap(oldSessionId, value);
        this.map(session.getId(), value);
    }

    public void attributeAdded(HttpSessionBindingEvent hsbe) {
        HttpSession session = hsbe.getSession();
        if (Objects.equals(hsbe.getName(), SamlSession.class.getName())) {
            LOG.debugf("Attribute added", new Object[0]);
            this.map(session.getId(), hsbe.getValue());
        }
    }

    public void attributeRemoved(HttpSessionBindingEvent hsbe) {
        HttpSession session = hsbe.getSession();
        if (Objects.equals(hsbe.getName(), SamlSession.class.getName())) {
            LOG.debugf("Attribute removed", new Object[0]);
            this.unmap(session.getId(), hsbe.getValue());
        }
    }

    public void attributeReplaced(HttpSessionBindingEvent hsbe) {
        HttpSession session = hsbe.getSession();
        if (Objects.equals(hsbe.getName(), SamlSession.class.getName())) {
            LOG.debugf("Attribute replaced", new Object[0]);
            this.unmap(session.getId(), hsbe.getValue());
            this.map(session.getId(), session.getAttribute(SamlSession.class.getName()));
        }
    }

    private void map(String sessionId, Object value) {
        if (!(value instanceof SamlSession) || sessionId == null) {
            return;
        }
        SamlSession account = (SamlSession)value;
        this.idMapper.map(account.getSessionIndex(), account.getPrincipal().getSamlSubject(), sessionId);
    }

    private void unmap(String sessionId, Object value) {
        if (!(value instanceof SamlSession) || sessionId == null) {
            return;
        }
        SamlSession samlSession = (SamlSession)value;
        if (samlSession.getSessionIndex() != null) {
            this.idMapper.removeSession(sessionId);
        }
    }
}

