/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.saml.rotation;

import java.security.Key;
import java.security.KeyManagementException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.security.auth.x500.X500Principal;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyName;
import org.apache.http.client.HttpClient;
import org.jboss.logging.Logger;
import org.keycloak.adapters.cloned.HttpAdapterUtils;
import org.keycloak.adapters.cloned.HttpClientAdapterException;
import org.keycloak.common.util.MultivaluedHashMap;
import org.keycloak.common.util.SecretGenerator;
import org.keycloak.common.util.Time;
import org.keycloak.dom.saml.v2.metadata.KeyTypes;
import org.keycloak.rotation.KeyLocator;
import org.keycloak.saml.processing.api.util.KeyInfoTools;

public class SamlDescriptorPublicKeyLocator
implements KeyLocator {
    private static final Logger LOG = Logger.getLogger(SamlDescriptorPublicKeyLocator.class);
    private final int minTimeBetweenDescriptorRequests;
    private final int cacheEntryTtl;
    private final String descriptorUrl;
    private final Map<String, Key> publicKeyCacheByName = new ConcurrentHashMap<String, Key>();
    private final Map<KeyLocator.KeyHash, Key> publicKeyCacheByKey = new ConcurrentHashMap<KeyLocator.KeyHash, Key>();
    private final HttpClient client;
    private volatile int lastRequestTime = 0;

    public SamlDescriptorPublicKeyLocator(String descriptorUrl, int minTimeBetweenDescriptorRequests, int cacheEntryTtl, HttpClient httpClient) {
        this.minTimeBetweenDescriptorRequests = minTimeBetweenDescriptorRequests <= 0 ? 20 : minTimeBetweenDescriptorRequests;
        this.descriptorUrl = descriptorUrl;
        this.cacheEntryTtl = cacheEntryTtl;
        this.client = httpClient;
    }

    public Key getKey(String kid) throws KeyManagementException {
        if (kid == null) {
            LOG.debugf("Invalid key id: %s", (Object)kid);
            return null;
        }
        return this.getKey(kid, this.publicKeyCacheByName);
    }

    public Key getKey(Key key) throws KeyManagementException {
        if (key == null) {
            return null;
        }
        return this.getKey(new KeyLocator.KeyHash(key), this.publicKeyCacheByKey);
    }

    private <T> Key getKey(T key, Map<T, Key> cache) throws KeyManagementException {
        Key res;
        LOG.tracef("Requested key: %s", key);
        int currentTime = Time.currentTime();
        if (currentTime > this.lastRequestTime + this.cacheEntryTtl) {
            LOG.debugf("Performing regular cache cleanup.", new Object[0]);
            res = this.refreshCertificateCacheAndGet(key, cache, currentTime);
        } else {
            res = cache.get(key);
            if (res == null) {
                if (currentTime > this.lastRequestTime + this.minTimeBetweenDescriptorRequests) {
                    res = this.refreshCertificateCacheAndGet(key, cache, currentTime);
                } else {
                    LOG.debugf("Won't send request to realm SAML descriptor url, timeout not expired. Last request time was %d", this.lastRequestTime);
                }
            }
        }
        return res;
    }

    public synchronized void refreshKeyCache() {
        LOG.info((Object)"Forcing key cache cleanup and refresh.");
        this.publicKeyCacheByName.clear();
        this.publicKeyCacheByKey.clear();
        this.refreshCertificateCacheAndGet(null, this.publicKeyCacheByKey, Time.currentTime());
    }

    private synchronized <T> Key refreshCertificateCacheAndGet(T key, Map<T, Key> cache, int currentTime) {
        List signingCerts;
        if (this.descriptorUrl == null || currentTime <= this.lastRequestTime + this.minTimeBetweenDescriptorRequests) {
            return key == null ? null : cache.get(key);
        }
        this.lastRequestTime = Time.currentTime();
        LOG.debugf("Refreshing public key cache from %s", (Object)this.descriptorUrl);
        try {
            MultivaluedHashMap<String, KeyInfo> certs = HttpAdapterUtils.downloadKeysFromSamlDescriptor(this.client, this.descriptorUrl);
            signingCerts = (List)certs.get((Object)KeyTypes.SIGNING.value());
        }
        catch (HttpClientAdapterException ex) {
            LOG.error((Object)"Could not refresh certificates from the server", (Throwable)ex);
            return null;
        }
        if (signingCerts == null) {
            return null;
        }
        LOG.debugf("Certificates retrieved from server, filling public key cache", new Object[0]);
        this.publicKeyCacheByName.clear();
        this.publicKeyCacheByKey.clear();
        for (KeyInfo ki : signingCerts) {
            KeyName keyName = KeyInfoTools.getKeyName((KeyInfo)ki);
            X509Certificate x509certificate = KeyInfoTools.getX509Certificate((KeyInfo)ki);
            if (x509certificate == null) continue;
            try {
                x509certificate.checkValidity();
            }
            catch (CertificateException ex) {
                continue;
            }
            if (keyName != null) {
                LOG.tracef("Registering signing certificate %s", (Object)keyName.getName());
                this.publicKeyCacheByName.put(keyName.getName(), x509certificate.getPublicKey());
                this.publicKeyCacheByKey.put(new KeyLocator.KeyHash((Key)x509certificate.getPublicKey()), x509certificate.getPublicKey());
                continue;
            }
            X500Principal principal = x509certificate.getSubjectX500Principal();
            String name = (principal == null ? "unnamed" : principal.getName()) + "@" + String.valueOf(x509certificate.getSerialNumber()) + "$" + SecretGenerator.getInstance().generateSecureID();
            this.publicKeyCacheByName.put(name, x509certificate.getPublicKey());
            this.publicKeyCacheByKey.put(new KeyLocator.KeyHash((Key)x509certificate.getPublicKey()), x509certificate.getPublicKey());
            LOG.tracef("Adding certificate %s without a specific key name: %s", (Object)name, (Object)x509certificate);
        }
        return key == null ? null : cache.get(key);
    }

    public String toString() {
        return "Keys retrieved from SAML descriptor at " + this.descriptorUrl;
    }

    public Iterator<Key> iterator() {
        int currentTime = Time.currentTime();
        if (currentTime > this.lastRequestTime + this.cacheEntryTtl) {
            LOG.debugf("Performing regular cache cleanup.", new Object[0]);
            this.refreshCertificateCacheAndGet(null, this.publicKeyCacheByName, currentTime);
        }
        return this.publicKeyCacheByKey.values().iterator();
    }
}

