/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.saml.wildfly.infinispan;

import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.infinispan.Cache;
import org.infinispan.client.hotrod.annotation.ClientCacheEntryCreated;
import org.infinispan.client.hotrod.annotation.ClientCacheEntryRemoved;
import org.infinispan.client.hotrod.annotation.ClientListener;
import org.infinispan.client.hotrod.event.ClientCacheEntryCreatedEvent;
import org.infinispan.client.hotrod.event.ClientCacheEntryRemovedEvent;
import org.infinispan.context.Flag;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryCreated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryRemoved;
import org.infinispan.notifications.cachelistener.annotation.TransactionCompleted;
import org.infinispan.notifications.cachelistener.annotation.TransactionRegistered;
import org.infinispan.notifications.cachelistener.event.CacheEntryCreatedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryRemovedEvent;
import org.infinispan.notifications.cachelistener.event.Event;
import org.infinispan.notifications.cachelistener.event.TransactionCompletedEvent;
import org.infinispan.notifications.cachelistener.event.TransactionRegisteredEvent;
import org.infinispan.notifications.cachelistener.event.TransactionalEvent;
import org.infinispan.notifications.cachemanagerlistener.annotation.CacheStarted;
import org.infinispan.notifications.cachemanagerlistener.annotation.CacheStopped;
import org.infinispan.notifications.cachemanagerlistener.event.CacheStartedEvent;
import org.infinispan.notifications.cachemanagerlistener.event.CacheStoppedEvent;
import org.jboss.logging.Logger;
import org.keycloak.adapters.spi.SessionIdMapper;

@Listener
@ClientListener
public class SsoSessionCacheListener {
    private static final Logger LOG = Logger.getLogger(SsoSessionCacheListener.class);
    private final ConcurrentMap<String, Queue<Event>> map = new ConcurrentHashMap<String, Queue<Event>>();
    private final SessionIdMapper idMapper;
    private final Cache<String, String[]> ssoCache;
    private ExecutorService executor = Executors.newSingleThreadExecutor();

    public SsoSessionCacheListener(Cache<String, String[]> ssoCache, SessionIdMapper idMapper) {
        this.ssoCache = ssoCache;
        this.idMapper = idMapper;
    }

    @TransactionRegistered
    public void startTransaction(TransactionRegisteredEvent event) {
        if (event.getGlobalTransaction() == null) {
            return;
        }
        this.map.put(event.getGlobalTransaction().globalId(), new ConcurrentLinkedQueue());
    }

    @CacheStarted
    public void cacheStarted(CacheStartedEvent event) {
        this.executor = Executors.newSingleThreadExecutor();
    }

    @CacheStopped
    public void cacheStopped(CacheStoppedEvent event) {
        this.executor.shutdownNow();
    }

    @CacheEntryCreated
    @CacheEntryRemoved
    public void addEvent(TransactionalEvent event) {
        if (event.isOriginLocal()) {
            return;
        }
        if (event.isPre()) {
            return;
        }
        if (event.getGlobalTransaction() != null) {
            ((Queue)this.map.get(event.getGlobalTransaction().globalId())).add(event);
        } else {
            this.processEvent((Event)event);
        }
    }

    @TransactionCompleted
    public void endTransaction(TransactionCompletedEvent event) {
        if (event.getGlobalTransaction() == null) {
            return;
        }
        Queue events = (Queue)this.map.remove(event.getGlobalTransaction().globalId());
        if (events == null || !event.isTransactionSuccessful()) {
            return;
        }
        for (Event e : events) {
            this.processEvent(e);
        }
    }

    private void processEvent(final Event e) {
        switch (e.getType()) {
            case CACHE_ENTRY_CREATED: {
                this.executor.submit(new Runnable(){

                    @Override
                    public void run() {
                        SsoSessionCacheListener.this.cacheEntryCreated((CacheEntryCreatedEvent)e);
                    }
                });
                break;
            }
            case CACHE_ENTRY_REMOVED: {
                this.executor.submit(new Runnable(){

                    @Override
                    public void run() {
                        SsoSessionCacheListener.this.cacheEntryRemoved((CacheEntryRemovedEvent)e);
                    }
                });
            }
        }
    }

    private void cacheEntryCreated(CacheEntryCreatedEvent event) {
        if (!(event.getKey() instanceof String) || !(event.getValue() instanceof String[])) {
            return;
        }
        String httpSessionId = (String)event.getKey();
        String[] value = (String[])event.getValue();
        String ssoId = value[0];
        String principal = value[1];
        LOG.tracev("cacheEntryCreated {0}:{1}", (Object)httpSessionId, (Object)ssoId);
        this.idMapper.map(ssoId, principal, httpSessionId);
    }

    private void cacheEntryRemoved(CacheEntryRemovedEvent event) {
        if (!(event.getKey() instanceof String)) {
            return;
        }
        LOG.tracev("cacheEntryRemoved {0}", event.getKey());
        this.idMapper.removeSession((String)event.getKey());
    }

    @ClientCacheEntryCreated
    public void remoteCacheEntryCreated(final ClientCacheEntryCreatedEvent event) {
        if (!(event.getKey() instanceof String)) {
            return;
        }
        final String httpSessionId = (String)event.getKey();
        if (this.idMapper.hasSession(httpSessionId)) {
            LOG.tracev("IGNORING remoteCacheEntryCreated {0}", (Object)httpSessionId);
            return;
        }
        this.executor.submit(new Runnable(){

            @Override
            public void run() {
                String[] value = (String[])SsoSessionCacheListener.this.ssoCache.get((Object)httpSessionId);
                if (value != null) {
                    String ssoId = value[0];
                    String principal = value[1];
                    LOG.tracev("remoteCacheEntryCreated {0}:{1}", (Object)httpSessionId, (Object)ssoId);
                    SsoSessionCacheListener.this.idMapper.map(ssoId, principal, httpSessionId);
                } else {
                    LOG.tracev("remoteCacheEntryCreated {0}", event.getKey());
                }
            }
        });
    }

    @ClientCacheEntryRemoved
    public void remoteCacheEntryRemoved(ClientCacheEntryRemovedEvent event) {
        LOG.tracev("remoteCacheEntryRemoved {0}", event.getKey());
        this.idMapper.removeSession((String)event.getKey());
        this.ssoCache.getAdvancedCache().withFlags(Flag.SKIP_CACHE_STORE).remove((Object)((String)event.getKey()));
    }
}

