/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.saml.wildfly.infinispan;

import io.undertow.server.HttpServerExchange;
import io.undertow.server.session.Session;
import io.undertow.server.session.SessionListener;
import org.infinispan.Cache;
import org.jboss.logging.Logger;
import org.keycloak.adapters.saml.SamlSession;
import org.keycloak.adapters.spi.SessionIdMapper;
import org.keycloak.adapters.spi.SessionIdMapperUpdater;

public class SsoCacheSessionIdMapperUpdater
implements SessionIdMapperUpdater,
SessionListener {
    private static final Logger LOG = Logger.getLogger((String)SsoCacheSessionIdMapperUpdater.class.getName());
    private final SessionIdMapperUpdater delegate;
    private final Cache<String, String[]> httpSessionToSsoCache;

    public SsoCacheSessionIdMapperUpdater(Cache<String, String[]> httpSessionToSsoCache, SessionIdMapperUpdater previousIdMapperUpdater) {
        this.delegate = previousIdMapperUpdater;
        this.httpSessionToSsoCache = httpSessionToSsoCache;
    }

    public void clear(SessionIdMapper idMapper) {
        this.httpSessionToSsoCache.clear();
        this.delegate.clear(idMapper);
    }

    public void map(SessionIdMapper idMapper, String sso, String principal, String httpSessionId) {
        LOG.debugf("Adding mapping (%s, %s, %s)", (Object)sso, (Object)principal, (Object)httpSessionId);
        this.httpSessionToSsoCache.put((Object)httpSessionId, (Object)new String[]{sso, principal});
        this.delegate.map(idMapper, sso, principal, httpSessionId);
    }

    public boolean refreshMapping(SessionIdMapper idMapper, String httpSessionId) {
        LOG.debugf("Refreshing session %s", (Object)httpSessionId);
        String[] ssoAndPrincipal = (String[])this.httpSessionToSsoCache.get((Object)httpSessionId);
        if (ssoAndPrincipal != null) {
            this.delegate.map(idMapper, ssoAndPrincipal[0], ssoAndPrincipal[1], httpSessionId);
            return true;
        }
        return false;
    }

    public void removeSession(SessionIdMapper idMapper, String httpSessionId) {
        LOG.debugf("Removing session %s", (Object)httpSessionId);
        this.httpSessionToSsoCache.remove((Object)httpSessionId);
        this.delegate.removeSession(idMapper, httpSessionId);
    }

    public void sessionCreated(Session session, HttpServerExchange exchange) {
    }

    public void sessionDestroyed(Session session, HttpServerExchange exchange, SessionListener.SessionDestroyedReason reason) {
    }

    public void attributeAdded(Session session, String name, Object value) {
    }

    public void attributeUpdated(Session session, String name, Object newValue, Object oldValue) {
    }

    public void attributeRemoved(Session session, String name, Object oldValue) {
    }

    public void sessionIdChanged(Session session, String oldSessionId) {
        this.httpSessionToSsoCache.remove((Object)oldSessionId);
        Object value = session.getAttribute(SamlSession.class.getName());
        if (value instanceof SamlSession) {
            SamlSession sess = (SamlSession)value;
            this.httpSessionToSsoCache.put((Object)session.getId(), (Object)new String[]{sess.getSessionIndex(), sess.getPrincipal().getSamlSubject()});
        }
    }
}

