/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.subsystem.adapter.saml.extension;

import java.io.ByteArrayOutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.web.common.WarMetaData;
import org.jboss.dmr.ModelNode;
import org.jboss.metadata.javaee.spec.ParamValueMetaData;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.metadata.web.spec.LoginConfigMetaData;
import org.jboss.staxmapper.FormattingXMLStreamWriter;
import org.jboss.staxmapper.XMLExtendedStreamWriter;
import org.keycloak.subsystem.adapter.saml.extension.Configuration;
import org.keycloak.subsystem.adapter.saml.extension.KeycloakSubsystemParser;
import org.keycloak.subsystem.adapter.saml.extension.logging.KeycloakLogger;

public class KeycloakAdapterConfigDeploymentProcessor
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        String deploymentName = deploymentUnit.getName();
        if (Configuration.INSTANCE.getSecureDeployment(deploymentName) != null) {
            this.addKeycloakSamlAuthData(phaseContext, deploymentName);
        }
    }

    private void addKeycloakSamlAuthData(DeploymentPhaseContext phaseContext, String deploymentName) throws DeploymentUnitProcessingException {
        LoginConfigMetaData loginConfig;
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        WarMetaData warMetaData = (WarMetaData)deploymentUnit.getAttachment(WarMetaData.ATTACHMENT_KEY);
        if (warMetaData == null) {
            throw new DeploymentUnitProcessingException("WarMetaData not found for " + deploymentName + ".  Make sure you have specified a WAR as your secure-deployment in the Keycloak subsystem.");
        }
        try {
            this.addXMLData(this.getXML(deploymentName), warMetaData);
        }
        catch (Exception e) {
            throw new DeploymentUnitProcessingException("Failed to configure KeycloakSamlExtension from subsystem model", (Throwable)e);
        }
        JBossWebMetaData webMetaData = warMetaData.getMergedJBossWebMetaData();
        if (webMetaData == null) {
            webMetaData = new JBossWebMetaData();
            warMetaData.setMergedJBossWebMetaData(webMetaData);
        }
        if ((loginConfig = webMetaData.getLoginConfig()) == null) {
            loginConfig = new LoginConfigMetaData();
            webMetaData.setLoginConfig(loginConfig);
        }
        loginConfig.setAuthMethod("KEYCLOAK-SAML");
        KeycloakLogger.ROOT_LOGGER.deploymentSecured(deploymentName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getXML(String deploymentName) throws XMLStreamException {
        ModelNode node = Configuration.INSTANCE.getSecureDeployment(deploymentName);
        if (node != null) {
            KeycloakSubsystemParser writer = new KeycloakSubsystemParser();
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            try (FormattingXMLStreamWriter streamWriter = new FormattingXMLStreamWriter(XMLOutputFactory.newInstance().createXMLStreamWriter(output));){
                streamWriter.writeStartElement("keycloak-saml-adapter");
                writer.writeSps((XMLExtendedStreamWriter)streamWriter, node);
                streamWriter.writeEndElement();
            }
            return new String(output.toByteArray(), Charset.forName("utf-8"));
        }
        return null;
    }

    private void addXMLData(String xml, WarMetaData warMetaData) {
        ArrayList<ParamValueMetaData> contextParams;
        JBossWebMetaData webMetaData = warMetaData.getMergedJBossWebMetaData();
        if (webMetaData == null) {
            webMetaData = new JBossWebMetaData();
            warMetaData.setMergedJBossWebMetaData(webMetaData);
        }
        if ((contextParams = webMetaData.getContextParams()) == null) {
            contextParams = new ArrayList<ParamValueMetaData>();
        }
        ParamValueMetaData param = new ParamValueMetaData();
        param.setParamName("org.keycloak.saml.xml.adapterConfig");
        param.setParamValue(xml);
        contextParams.add(param);
        webMetaData.setContextParams(contextParams);
    }

    public void undeploy(DeploymentUnit du) {
    }
}

