/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.saml.elytron;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.cert.X509Certificate;
import org.jboss.logging.Logger;
import org.keycloak.adapters.saml.SamlDeployment;
import org.keycloak.adapters.saml.SamlDeploymentContext;
import org.keycloak.adapters.saml.SamlSession;
import org.keycloak.adapters.saml.SamlSessionStore;
import org.keycloak.adapters.saml.elytron.ElytronSamlSessionStore;
import org.keycloak.adapters.saml.elytron.ElytronTokeStore;
import org.keycloak.adapters.saml.elytron.SecurityIdentityUtil;
import org.keycloak.adapters.spi.AuthChallenge;
import org.keycloak.adapters.spi.AuthenticationError;
import org.keycloak.adapters.spi.HttpFacade;
import org.keycloak.adapters.spi.LogoutError;
import org.keycloak.adapters.spi.SessionIdMapper;
import org.keycloak.adapters.spi.SessionIdMapperUpdater;
import org.keycloak.common.util.MultivaluedHashMap;
import org.keycloak.common.util.UriUtils;
import org.wildfly.security.auth.callback.AnonymousAuthorizationCallback;
import org.wildfly.security.auth.callback.AuthenticationCompleteCallback;
import org.wildfly.security.auth.callback.SecurityIdentityCallback;
import org.wildfly.security.auth.server.SecurityIdentity;
import org.wildfly.security.http.HttpScope;
import org.wildfly.security.http.HttpServerCookie;
import org.wildfly.security.http.HttpServerRequest;
import org.wildfly.security.http.HttpServerResponse;
import org.wildfly.security.http.Scope;

class ElytronHttpFacade
implements HttpFacade {
    private static final boolean elyweb163Workaround;
    private static final Logger log;
    private final HttpServerRequest request;
    private final CallbackHandler callbackHandler;
    private final SamlDeploymentContext deploymentContext;
    private final SamlSessionStore sessionStore;
    private Consumer<HttpServerResponse> responseConsumer;
    private SecurityIdentity securityIdentity;
    private boolean restored;
    private SamlSession samlSession;
    protected MultivaluedHashMap<String, String> queryParameters;

    private static Integer[] parseVersion(String version) {
        if (version != null) {
            String[] versionArray = version.split(Pattern.quote("."));
            ArrayList<Integer> versionList = new ArrayList<Integer>();
            for (int i = 0; i < versionArray.length; ++i) {
                if (!versionArray[i].matches("[0-9]+")) continue;
                versionList.add(Integer.parseInt(versionArray[i]));
            }
            if (!versionList.isEmpty()) {
                return versionList.toArray(new Integer[0]);
            }
        }
        return null;
    }

    private static boolean versionIsLessThan(Integer[] array1, Integer[] array2) {
        if (array1 == null || array2 == null || array1.length == 0 || array2.length == 0) {
            throw new IllegalArgumentException("Arrays cannot be null or empty");
        }
        for (int i = 0; i < array1.length && i < array2.length; ++i) {
            if (array1[i] < array2[i]) {
                return true;
            }
            if (array1[i] <= array2[i]) continue;
            return false;
        }
        return array1.length < array2.length;
    }

    private static boolean versionIsGreaterOrEqualThan(Integer[] array1, Integer[] array2) {
        return !ElytronHttpFacade.versionIsLessThan(array1, array2);
    }

    public ElytronHttpFacade(HttpServerRequest request, SessionIdMapper idMapper, SessionIdMapperUpdater idMapperUpdater, SamlDeploymentContext deploymentContext, CallbackHandler handler) {
        this.request = request;
        this.deploymentContext = deploymentContext;
        this.callbackHandler = handler;
        this.responseConsumer = response -> {};
        this.sessionStore = this.createTokenStore(idMapper, idMapperUpdater);
    }

    private SamlSessionStore createTokenStore(SessionIdMapper idMapper, SessionIdMapperUpdater idMapperUpdater) {
        return new ElytronSamlSessionStore(this, idMapper, idMapperUpdater, this.getDeployment());
    }

    void authenticationComplete(SamlSession samlSession) {
        this.samlSession = samlSession;
    }

    void authenticationComplete() {
        this.securityIdentity = SecurityIdentityUtil.authorize(this.callbackHandler, this.samlSession.getPrincipal());
        if (this.securityIdentity != null) {
            this.request.authenticationComplete(response -> {
                if (!this.restored) {
                    this.responseConsumer.accept(response);
                }
            }, () -> ((ElytronTokeStore)this.sessionStore).logout(true));
        }
    }

    void authenticationCompleteAnonymous() {
        try {
            AnonymousAuthorizationCallback anonymousAuthorizationCallback = new AnonymousAuthorizationCallback(null);
            this.callbackHandler.handle(new Callback[]{anonymousAuthorizationCallback});
            if (anonymousAuthorizationCallback.isAuthorized()) {
                this.callbackHandler.handle(new Callback[]{AuthenticationCompleteCallback.SUCCEEDED, new SecurityIdentityCallback()});
                this.request.authenticationComplete(response -> response.forward(this.getRequest().getRelativePath()));
            } else {
                this.request.noAuthenticationInProgress(response -> response.forward(this.getRequest().getRelativePath()));
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Unexpected error processing callbacks during logout.", e);
        }
    }

    void authenticationFailed() {
        this.request.authenticationFailed("Authentication Failed", response -> this.responseConsumer.accept(response));
    }

    void noAuthenticationInProgress(AuthChallenge challenge) {
        if (challenge != null) {
            challenge.challenge((HttpFacade)this);
        }
        this.request.noAuthenticationInProgress(response -> this.responseConsumer.accept(response));
    }

    void authenticationInProgress() {
        this.request.authenticationInProgress(response -> this.responseConsumer.accept(response));
    }

    HttpScope getScope(Scope scope) {
        return this.request.getScope(scope);
    }

    HttpScope getScope(Scope scope, String id) {
        return this.request.getScope(scope, id);
    }

    Collection<String> getScopeIds(Scope scope) {
        return this.request.getScopeIds(scope);
    }

    SamlDeployment getDeployment() {
        return this.deploymentContext.resolveDeployment((HttpFacade)this);
    }

    public HttpFacade.Request getRequest() {
        return new HttpFacade.Request(){
            private InputStream inputStream;

            public String getMethod() {
                return ElytronHttpFacade.this.request.getRequestMethod();
            }

            public String getURI() {
                if (elyweb163Workaround) {
                    try {
                        return URLDecoder.decode(ElytronHttpFacade.this.request.getRequestURI().toString(), "UTF-8");
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new RuntimeException("Failed to decode request URI", e);
                    }
                }
                return ElytronHttpFacade.this.request.getRequestURI().toString();
            }

            public String getRelativePath() {
                return ElytronHttpFacade.this.request.getRequestPath();
            }

            public boolean isSecure() {
                return ElytronHttpFacade.this.request.getRequestURI().getScheme().equals("https");
            }

            public String getFirstParam(String param) {
                return ElytronHttpFacade.this.request.getFirstParameterValue(param);
            }

            public String getQueryParamValue(String param) {
                if (elyweb163Workaround) {
                    URI requestURI = ElytronHttpFacade.this.request.getRequestURI();
                    String query = requestURI.getQuery();
                    if (query != null) {
                        String[] parameters;
                        for (String parameter : parameters = query.split("&")) {
                            String[] keyValue = parameter.split("=", 2);
                            if (!keyValue[0].equals(param)) continue;
                            try {
                                return URLDecoder.decode(keyValue[1], "UTF-8");
                            }
                            catch (IOException e) {
                                throw new RuntimeException("Failed to decode request URI", e);
                            }
                        }
                    }
                    return null;
                }
                if (ElytronHttpFacade.this.queryParameters == null) {
                    ElytronHttpFacade.this.queryParameters = UriUtils.decodeQueryString((String)ElytronHttpFacade.this.request.getRequestURI().getRawQuery());
                }
                return (String)ElytronHttpFacade.this.queryParameters.getFirst((Object)param);
            }

            public HttpFacade.Cookie getCookie(String cookieName) {
                List cookies = ElytronHttpFacade.this.request.getCookies();
                if (cookies != null) {
                    for (HttpServerCookie cookie : cookies) {
                        if (!cookie.getName().equals(cookieName)) continue;
                        return new HttpFacade.Cookie(cookie.getName(), cookie.getValue(), cookie.getVersion(), cookie.getDomain(), cookie.getPath());
                    }
                }
                return null;
            }

            public String getHeader(String name) {
                return ElytronHttpFacade.this.request.getFirstRequestHeaderValue(name);
            }

            public List<String> getHeaders(String name) {
                return ElytronHttpFacade.this.request.getRequestHeaderValues(name);
            }

            public InputStream getInputStream() {
                return this.getInputStream(false);
            }

            public InputStream getInputStream(boolean buffered) {
                if (this.inputStream != null) {
                    return this.inputStream;
                }
                if (buffered) {
                    this.inputStream = new BufferedInputStream(ElytronHttpFacade.this.request.getInputStream());
                    return this.inputStream;
                }
                return ElytronHttpFacade.this.request.getInputStream();
            }

            public String getRemoteAddr() {
                InetSocketAddress sourceAddress = ElytronHttpFacade.this.request.getSourceAddress();
                if (sourceAddress == null) {
                    return "";
                }
                InetAddress address = sourceAddress.getAddress();
                if (address == null) {
                    return sourceAddress.getHostString();
                }
                return address.getHostAddress();
            }

            public void setError(AuthenticationError error) {
                ElytronHttpFacade.this.request.getScope(Scope.EXCHANGE).setAttachment(AuthenticationError.class.getName(), (Object)error);
            }

            public void setError(LogoutError error) {
                ElytronHttpFacade.this.request.getScope(Scope.EXCHANGE).setAttachment(LogoutError.class.getName(), (Object)error);
            }
        };
    }

    public HttpFacade.Response getResponse() {
        return new HttpFacade.Response(){

            public void setStatus(int status) {
                ElytronHttpFacade.this.responseConsumer = ElytronHttpFacade.this.responseConsumer.andThen(response -> response.setStatusCode(status));
            }

            public void addHeader(String name, String value) {
                ElytronHttpFacade.this.responseConsumer = ElytronHttpFacade.this.responseConsumer.andThen(response -> response.addResponseHeader(name, value));
            }

            public void setHeader(String name, String value) {
                this.addHeader(name, value);
            }

            public void resetCookie(String name, String path) {
                ElytronHttpFacade.this.responseConsumer = ElytronHttpFacade.this.responseConsumer.andThen(response -> this.setCookie(name, "", path, null, 0, false, false, (HttpServerResponse)response));
            }

            public void setCookie(String name, String value, String path, String domain, int maxAge, boolean secure, boolean httpOnly) {
                ElytronHttpFacade.this.responseConsumer = ElytronHttpFacade.this.responseConsumer.andThen(response -> this.setCookie(name, value, path, domain, maxAge, secure, httpOnly, (HttpServerResponse)response));
            }

            private void setCookie(final String name, final String value, final String path, final String domain, final int maxAge, final boolean secure, final boolean httpOnly, HttpServerResponse response) {
                response.setResponseCookie(new HttpServerCookie(){

                    public String getName() {
                        return name;
                    }

                    public String getValue() {
                        return value;
                    }

                    public String getDomain() {
                        return domain;
                    }

                    public int getMaxAge() {
                        return maxAge;
                    }

                    public String getPath() {
                        return path;
                    }

                    public boolean isSecure() {
                        return secure;
                    }

                    public int getVersion() {
                        return 0;
                    }

                    public boolean isHttpOnly() {
                        return httpOnly;
                    }
                });
            }

            public OutputStream getOutputStream() {
                final ByteArrayOutputStream stream = new ByteArrayOutputStream();
                ElytronHttpFacade.this.responseConsumer = ElytronHttpFacade.this.responseConsumer.andThen(new Consumer<HttpServerResponse>(){

                    @Override
                    public void accept(HttpServerResponse httpServerResponse) {
                        try {
                            httpServerResponse.getOutputStream().write(stream.toByteArray());
                        }
                        catch (IOException e) {
                            throw new RuntimeException("Failed to write to response output stream", e);
                        }
                    }
                });
                return stream;
            }

            public void sendError(int code) {
                this.setStatus(code);
            }

            public void sendError(int code, String message) {
                ElytronHttpFacade.this.responseConsumer = ElytronHttpFacade.this.responseConsumer.andThen(response -> {
                    response.setStatusCode(code);
                    response.addResponseHeader("Content-Type", "text/html");
                    try {
                        response.getOutputStream().write(message.getBytes());
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                });
            }

            public void end() {
            }
        };
    }

    public X509Certificate[] getCertificateChain() {
        return new X509Certificate[0];
    }

    public boolean restoreRequest() {
        this.restored = this.request.resumeRequest();
        return this.restored;
    }

    public void suspendRequest() {
        this.responseConsumer = this.responseConsumer.andThen(httpServerResponse -> this.request.suspendRequest());
    }

    public boolean isAuthorized() {
        return this.securityIdentity != null;
    }

    public URI getURI() {
        return this.request.getRequestURI();
    }

    public SamlSessionStore getSessionStore() {
        return this.sessionStore;
    }

    static {
        log = Logger.getLogger(ElytronHttpFacade.class);
        boolean tmpElyweb163Workaround = false;
        String prop = System.getProperty("org.keycloak.adapters.elytronweb.ELYWEB-163.workaround");
        if (prop != null) {
            tmpElyweb163Workaround = Boolean.parseBoolean(prop);
            log.tracef("Forcing workaround for issue ELYWEB-163 in elytron-web %b", (Object)tmpElyweb163Workaround);
        } else {
            try {
                Class<?> clazz = ElytronHttpFacade.class.getClassLoader().loadClass("org.wildfly.elytron.web.undertow.server.ElytronHttpExchange");
                String version = clazz.getPackage().getImplementationVersion();
                Integer[] array = ElytronHttpFacade.parseVersion(version);
                tmpElyweb163Workaround = array != null && (ElytronHttpFacade.versionIsLessThan(array, new Integer[]{1, 9, 2}) || ElytronHttpFacade.versionIsLessThan(array, new Integer[]{1, 10, 1}) && ElytronHttpFacade.versionIsGreaterOrEqualThan(array, new Integer[]{1, 10, 0}));
                log.tracef("Version detected for elytron-web %s workaround for ELYWEB-163 %b", (Object)version, (Object)tmpElyweb163Workaround);
            }
            catch (Exception e) {
                log.tracef((Throwable)e, "Cannot detect version of elytron-web workaround for ELYWEB-163 %b", (Object)tmpElyweb163Workaround);
            }
        }
        elyweb163Workaround = tmpElyweb163Workaround;
    }
}

