/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.saml.elytron.infinispan;

import jakarta.servlet.ServletContext;
import java.util.Set;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.persistence.manager.PersistenceManager;
import org.infinispan.persistence.remote.RemoteStore;
import org.jboss.logging.Logger;
import org.keycloak.adapters.saml.elytron.infinispan.SsoCacheSessionIdMapperUpdater;
import org.keycloak.adapters.saml.elytron.infinispan.SsoSessionCacheListener;
import org.keycloak.adapters.spi.SessionIdMapper;
import org.keycloak.adapters.spi.SessionIdMapperUpdater;

public class InfinispanSessionCacheIdMapperUpdater {
    private static final Logger LOG = Logger.getLogger(InfinispanSessionCacheIdMapperUpdater.class);
    public static final String DEFAULT_CACHE_CONTAINER_JNDI_NAME = "java:jboss/infinispan/container";

    public static SessionIdMapperUpdater addTokenStoreUpdaters(ServletContext servletContext, SessionIdMapper mapper, SessionIdMapperUpdater previousIdMapperUpdater) {
        String containerName = servletContext.getInitParameter("org.keycloak.saml.replication.container");
        String cacheName = servletContext.getInitParameter("org.keycloak.saml.replication.cache.sso");
        String contextPath = servletContext.getContextPath();
        if (contextPath == null || contextPath.isEmpty() || "/".equals(contextPath)) {
            contextPath = "/ROOT";
        }
        String deploymentSessionCacheName = contextPath;
        if (containerName == null || cacheName == null) {
            LOG.warnv("Cannot determine parameters of SSO cache for deployment {0}.", (Object)contextPath);
            return previousIdMapperUpdater;
        }
        String cacheContainerLookup = "java:jboss/infinispan/container/" + containerName;
        try {
            CacheMode ssoCacheMode;
            EmbeddedCacheManager cacheManager = (EmbeddedCacheManager)new InitialContext().lookup(cacheContainerLookup);
            Configuration ssoCacheConfiguration = cacheManager.getCacheConfiguration(cacheName);
            if (ssoCacheConfiguration == null) {
                ssoCacheConfiguration = InfinispanSessionCacheIdMapperUpdater.tryDefineCacheConfigurationFromTemplate(cacheManager, containerName, cacheName, deploymentSessionCacheName);
                if (ssoCacheConfiguration == null && cacheName.lastIndexOf(46) != -1) {
                    String templateName = cacheName.substring(0, cacheName.lastIndexOf(46));
                    ssoCacheConfiguration = InfinispanSessionCacheIdMapperUpdater.tryDefineCacheConfigurationFromTemplate(cacheManager, containerName, cacheName, templateName);
                }
                if (ssoCacheConfiguration == null) {
                    LOG.debugv("Using default configuration for SSO cache {0}.{1}.", (Object)containerName, (Object)cacheName);
                    ssoCacheConfiguration = cacheManager.getDefaultCacheConfiguration();
                    cacheManager.defineConfiguration(cacheName, ssoCacheConfiguration);
                }
            } else {
                LOG.debugv("Using custom configuration of SSO cache {0}.{1}.", (Object)containerName, (Object)cacheName);
            }
            if ((ssoCacheMode = ssoCacheConfiguration.clustering().cacheMode()) != CacheMode.REPL_ASYNC && ssoCacheMode != CacheMode.REPL_SYNC) {
                LOG.warnv("SSO cache mode is {0}, it is recommended to use replicated mode instead.", (Object)ssoCacheConfiguration.clustering().cacheModeString());
            }
            final Cache ssoCache = cacheManager.getCache(cacheName, true);
            SsoSessionCacheListener listener = new SsoSessionCacheListener((Cache<String, String[]>)ssoCache, mapper);
            ssoCache.addListener((Object)listener);
            InfinispanSessionCacheIdMapperUpdater.addSsoCacheCrossDcListener((Cache<String, String[]>)ssoCache, listener);
            LOG.debugv("Added distributed SSO session cache, lookup={0}, cache name={1}", (Object)cacheContainerLookup, (Object)cacheName);
            return new SsoCacheSessionIdMapperUpdater(ssoCache, previousIdMapperUpdater){

                @Override
                public void close() {
                    ssoCache.stop();
                }
            };
        }
        catch (NamingException ex) {
            LOG.warnv("Failed to obtain distributed session cache container, lookup={0}", (Object)cacheContainerLookup);
            return previousIdMapperUpdater;
        }
    }

    private static Configuration tryDefineCacheConfigurationFromTemplate(EmbeddedCacheManager cacheManager, String containerName, String newCacheName, String templateCacheName) {
        Configuration cacheConfiguration = cacheManager.getCacheConfiguration(templateCacheName);
        if (cacheConfiguration != null) {
            LOG.debugv("Using distributed HTTP session cache configuration for SSO cache {0}.{1}, configuration taken from cache {2}", (Object)containerName, (Object)newCacheName, (Object)templateCacheName);
            return cacheManager.defineConfiguration(newCacheName, cacheConfiguration);
        }
        return null;
    }

    private static void addSsoCacheCrossDcListener(Cache<String, String[]> ssoCache, SsoSessionCacheListener listener) {
        if (ssoCache.getCacheConfiguration().persistence() == null) {
            return;
        }
        Set<RemoteStore> stores = InfinispanSessionCacheIdMapperUpdater.getRemoteStores(ssoCache);
        if (stores == null || stores.isEmpty()) {
            return;
        }
        LOG.infov("Listening for events on remote stores configured for cache {0}", (Object)ssoCache.getName());
        for (RemoteStore store : stores) {
            store.getRemoteCache().addClientListener((Object)listener);
        }
    }

    public static Set<RemoteStore> getRemoteStores(Cache<?, ?> ispnCache) {
        return ((PersistenceManager)ComponentRegistry.componentOf(ispnCache, PersistenceManager.class)).getStores(RemoteStore.class);
    }
}

