/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.subsystem.adapter.saml.extension;

import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.module.ModuleDependency;
import org.jboss.as.server.deployment.module.ModuleSpecification;
import org.jboss.as.web.common.WarMetaData;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.metadata.web.spec.LoginConfigMetaData;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleLoader;
import org.keycloak.subsystem.adapter.saml.extension.Configuration;

public abstract class KeycloakDependencyProcessor
implements DeploymentUnitProcessor {
    static final String KEYCLOAK_JBOSS_CORE_ADAPTER = "org.keycloak.keycloak-jboss-adapter-core";
    static final String KEYCLOAK_CORE_ADAPTER = "org.keycloak.keycloak-saml-adapter-core";
    static final String KEYCLOAK_API_ADAPTER = "org.keycloak.keycloak-saml-adapter-api-public";
    static final String KEYCLOAK_COMMON = "org.keycloak.keycloak-common";

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (Configuration.INSTANCE.getSecureDeployment(deploymentUnit) == null) {
            WarMetaData warMetaData = (WarMetaData)deploymentUnit.getAttachment(WarMetaData.ATTACHMENT_KEY);
            if (warMetaData == null) {
                return;
            }
            JBossWebMetaData webMetaData = warMetaData.getMergedJBossWebMetaData();
            if (webMetaData == null) {
                return;
            }
            LoginConfigMetaData loginConfig = webMetaData.getLoginConfig();
            if (loginConfig == null) {
                return;
            }
            if (loginConfig.getAuthMethod() == null) {
                return;
            }
            if (!loginConfig.getAuthMethod().equals("KEYCLOAK-SAML")) {
                return;
            }
        }
        ModuleSpecification moduleSpecification = (ModuleSpecification)deploymentUnit.getAttachment(Attachments.MODULE_SPECIFICATION);
        ModuleLoader moduleLoader = Module.getCallerModuleLoader();
        if (moduleLoader == null) {
            moduleLoader = Module.getSystemModuleLoader();
        }
        this.addCoreModules(moduleSpecification, moduleLoader);
        this.addCommonModules(moduleSpecification, moduleLoader);
        this.addPlatformSpecificModules(phaseContext, moduleSpecification, moduleLoader);
    }

    protected void addCoreModules(ModuleSpecification moduleSpecification, ModuleLoader moduleLoader) {
        moduleSpecification.addSystemDependency(new ModuleDependency(moduleLoader, KEYCLOAK_CORE_ADAPTER, false, false, false, false));
    }

    private void addCommonModules(ModuleSpecification moduleSpecification, ModuleLoader moduleLoader) {
        moduleSpecification.addSystemDependency(new ModuleDependency(moduleLoader, KEYCLOAK_JBOSS_CORE_ADAPTER, false, false, false, false));
        moduleSpecification.addSystemDependency(new ModuleDependency(moduleLoader, KEYCLOAK_API_ADAPTER, false, false, false, false));
        moduleSpecification.addSystemDependency(new ModuleDependency(moduleLoader, KEYCLOAK_COMMON, false, false, false, false));
    }

    protected abstract void addPlatformSpecificModules(DeploymentPhaseContext var1, ModuleSpecification var2, ModuleLoader var3);

    public void undeploy(DeploymentUnit du) {
    }
}

