/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.subsystem.adapter.saml.extension;

import java.util.HashMap;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ObjectTypeAttributeDefinition;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ReloadRequiredRemoveStepHandler;
import org.jboss.as.controller.ReloadRequiredWriteAttributeHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.common.GenericSubsystemDescribeHandler;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.dmr.ModelType;
import org.keycloak.subsystem.adapter.saml.extension.AllowedClockSkew;
import org.keycloak.subsystem.adapter.saml.extension.HttpClientDefinition;
import org.keycloak.subsystem.adapter.saml.extension.IdentityProviderAddHandler;
import org.keycloak.subsystem.adapter.saml.extension.KeycloakSamlExtension;
import org.keycloak.subsystem.adapter.saml.extension.SingleLogoutDefinition;
import org.keycloak.subsystem.adapter.saml.extension.SingleSignOnDefinition;

public class IdentityProviderDefinition
extends SimpleResourceDefinition {
    private static final SimpleAttributeDefinition SIGNATURES_REQUIRED = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("signaturesRequired", ModelType.BOOLEAN, true).setXmlName("signaturesRequired")).build();
    private static final SimpleAttributeDefinition SIGNATURE_ALGORITHM = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("signatureAlgorithm", ModelType.STRING, true).setXmlName("signatureAlgorithm")).build();
    private static final SimpleAttributeDefinition SIGNATURE_CANONICALIZATION_METHOD = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("signatureCanonicalizationMethod", ModelType.STRING, true).setXmlName("signatureCanonicalizationMethod")).build();
    private static final SimpleAttributeDefinition METADATA_URL = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("metadataUrl", ModelType.STRING, true).setXmlName("metadataUrl")).setAllowExpression(true)).build();
    private static final ObjectTypeAttributeDefinition SINGLE_SIGN_ON = ((ObjectTypeAttributeDefinition.Builder)ObjectTypeAttributeDefinition.Builder.of((String)"SingleSignOnService", (AttributeDefinition[])SingleSignOnDefinition.ATTRIBUTES).setRequired(true)).build();
    private static final ObjectTypeAttributeDefinition SINGLE_LOGOUT = ((ObjectTypeAttributeDefinition.Builder)ObjectTypeAttributeDefinition.Builder.of((String)"SingleLogoutService", (AttributeDefinition[])SingleLogoutDefinition.ATTRIBUTES).setRequired(true)).build();
    private static final ObjectTypeAttributeDefinition ALLOWED_CLOCK_SKEW = ((ObjectTypeAttributeDefinition.Builder)ObjectTypeAttributeDefinition.Builder.of((String)"AllowedClockSkew", (AttributeDefinition[])AllowedClockSkew.ATTRIBUTES).setRequired(false)).build();
    private static final ObjectTypeAttributeDefinition HTTP_CLIENT = ((ObjectTypeAttributeDefinition.Builder)ObjectTypeAttributeDefinition.Builder.of((String)"HttpClient", (AttributeDefinition[])HttpClientDefinition.ATTRIBUTES).setRequired(false)).build();
    static final SimpleAttributeDefinition[] ATTRIBUTES = new SimpleAttributeDefinition[]{SIGNATURES_REQUIRED, SIGNATURE_ALGORITHM, SIGNATURE_CANONICALIZATION_METHOD, METADATA_URL};
    static final SimpleAttributeDefinition[] ALL_ATTRIBUTES = new SimpleAttributeDefinition[]{SIGNATURES_REQUIRED, SIGNATURE_ALGORITHM, SIGNATURE_CANONICALIZATION_METHOD, METADATA_URL, SINGLE_SIGN_ON, SINGLE_LOGOUT, ALLOWED_CLOCK_SKEW, HTTP_CLIENT};
    private static final HashMap<String, SimpleAttributeDefinition> ATTRIBUTE_MAP = new HashMap();
    static final IdentityProviderDefinition INSTANCE;

    private IdentityProviderDefinition() {
        super(PathElement.pathElement((String)"IDP"), (ResourceDescriptionResolver)KeycloakSamlExtension.getResourceDescriptionResolver("IDP"), (OperationStepHandler)new IdentityProviderAddHandler(), (OperationStepHandler)ReloadRequiredRemoveStepHandler.INSTANCE);
    }

    public void registerOperations(ManagementResourceRegistration resourceRegistration) {
        super.registerOperations(resourceRegistration);
        resourceRegistration.registerOperationHandler((OperationDefinition)GenericSubsystemDescribeHandler.DEFINITION, (OperationStepHandler)GenericSubsystemDescribeHandler.INSTANCE);
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        super.registerAttributes(resourceRegistration);
        ReloadRequiredWriteAttributeHandler writeHandler = new ReloadRequiredWriteAttributeHandler((AttributeDefinition[])ALL_ATTRIBUTES);
        for (SimpleAttributeDefinition attribute : ALL_ATTRIBUTES) {
            resourceRegistration.registerReadWriteAttribute((AttributeDefinition)attribute, null, (OperationStepHandler)writeHandler);
        }
    }

    static SimpleAttributeDefinition lookup(String xmlName) {
        return ATTRIBUTE_MAP.get(xmlName);
    }

    static {
        for (SimpleAttributeDefinition def : ALL_ATTRIBUTES) {
            ATTRIBUTE_MAP.put(def.getXmlName(), def);
        }
        INSTANCE = new IdentityProviderDefinition();
    }
}

