/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.subsystem.adapter.saml.extension;

import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.module.ModuleDependency;
import org.jboss.as.server.deployment.module.ModuleSpecification;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoader;
import org.keycloak.subsystem.adapter.saml.extension.Elytron;
import org.keycloak.subsystem.adapter.saml.extension.KeycloakDependencyProcessor;

public class KeycloakDependencyProcessorWildFly
extends KeycloakDependencyProcessor {
    private static final ModuleIdentifier KEYCLOAK_CORE_JAKARTA_ADAPTER = ModuleIdentifier.create((String)"org.keycloak.keycloak-saml-adapter-core-jakarta");
    private static final ModuleIdentifier KEYCLOAK_ELYTRON_ADAPTER = ModuleIdentifier.create((String)"org.keycloak.keycloak-saml-wildfly-elytron-adapter");
    private static final ModuleIdentifier KEYCLOAK_ELYTRON_JAKARTA_ADAPTER = ModuleIdentifier.create((String)"org.keycloak.keycloak-saml-wildfly-elytron-jakarta-adapter");

    @Override
    protected void addCoreModules(ModuleSpecification moduleSpecification, ModuleLoader moduleLoader) {
        if (this.isJakarta()) {
            moduleSpecification.addSystemDependency(new ModuleDependency(moduleLoader, KEYCLOAK_CORE_JAKARTA_ADAPTER, false, false, false, false));
        } else {
            super.addCoreModules(moduleSpecification, moduleLoader);
        }
    }

    @Override
    protected void addPlatformSpecificModules(DeploymentPhaseContext phaseContext, ModuleSpecification moduleSpecification, ModuleLoader moduleLoader) {
        if (Elytron.isElytronEnabled(phaseContext)) {
            if (this.isJakarta()) {
                moduleSpecification.addSystemDependency(new ModuleDependency(moduleLoader, KEYCLOAK_ELYTRON_JAKARTA_ADAPTER, true, false, false, false));
            } else {
                moduleSpecification.addSystemDependency(new ModuleDependency(moduleLoader, KEYCLOAK_ELYTRON_ADAPTER, true, false, false, false));
            }
        } else {
            throw new RuntimeException("Legacy WildFly security layer is no longer supported by the Keycloak WildFly adapter");
        }
    }

    private boolean isJakarta() {
        ClassLoader classLoader = this.getClass().getClassLoader();
        String classLoaderName = classLoader instanceof ModuleClassLoader ? ((ModuleClassLoader)classLoader).getName() : "";
        return classLoaderName.contains("jakarta");
    }
}

