/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.webservices.base.processors;

import com.arjuna.webservices.base.processors.ActivatedObjectProcessor;

public class ReactivatedObjectProcessor
extends ActivatedObjectProcessor {
    private static final Object tombstone = new Object();
    static boolean reactivationProcessingStarted = false;

    @Override
    public synchronized void activateObject(Object object, String identifier) {
        super.activateObject(object, identifier);
    }

    @Override
    public synchronized void deactivateObject(Object object) {
        this.deactivateObject(object, false);
    }

    public synchronized void deactivateObject(Object object, boolean leaveGhost) {
        if (leaveGhost) {
            String identifier = (String)this.identifierMap.get(object);
            super.deactivateObject(object);
            this.objectMap.put(identifier, tombstone);
        } else {
            super.deactivateObject(object);
        }
    }

    @Override
    public synchronized Object getObject(String identifier) {
        Object object = super.getObject(identifier);
        if (object == tombstone) {
            return null;
        }
        return object;
    }

    public synchronized boolean getGhost(String identifier) {
        if (reactivationProcessingStarted) {
            Object object = super.getObject(identifier);
            return object == tombstone;
        }
        return true;
    }

    public static void setReactivationProcessingStarted() {
        reactivationProcessingStarted = true;
    }
}

