/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.cache;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.ws.security.cache.ReplayCache;

public class MemoryReplayCache
implements ReplayCache {
    public static final long DEFAULT_TTL = 300L;
    public static final long MAX_TTL = 3600L;
    private SortedMap<Date, List<String>> cache = new TreeMap<Date, List<String>>();
    private Set<String> ids = Collections.synchronizedSet(new HashSet());

    public void add(String identifier) {
        this.add(identifier, 300L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(String identifier, long timeToLive) {
        if (identifier == null || "".equals(identifier)) {
            return;
        }
        long ttl = timeToLive;
        if (ttl < 0L || ttl > 3600L) {
            ttl = 300L;
        }
        Date expires = new Date();
        long currentTime = expires.getTime();
        expires.setTime(currentTime + ttl * 1000L);
        SortedMap<Date, List<String>> sortedMap = this.cache;
        synchronized (sortedMap) {
            ArrayList<String> list = (ArrayList<String>)this.cache.get(expires);
            if (list == null) {
                list = new ArrayList<String>(1);
                this.cache.put(expires, list);
            }
            list.add(identifier);
        }
        this.ids.add(identifier);
    }

    public boolean contains(String identifier) {
        this.processTokenExpiry();
        if (identifier != null && !"".equals(identifier)) {
            return this.ids.contains(identifier);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processTokenExpiry() {
        Date current = new Date();
        SortedMap<Date, List<String>> sortedMap = this.cache;
        synchronized (sortedMap) {
            Map.Entry<Date, List<String>> entry;
            Iterator<Map.Entry<Date, List<String>>> it = this.cache.entrySet().iterator();
            while (it.hasNext() && (entry = it.next()).getKey().before(current)) {
                for (String id : entry.getValue()) {
                    this.ids.remove(id);
                }
                it.remove();
            }
        }
    }
}

