/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.security.ssl.sun_jsse;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.Provider;
import java.security.Security;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLSocket;

public class JSSEUtil {
    private static final boolean isJDK14;

    public static void setEnabledProtocols(SSLSocket socket, String[] enabledProtocols) {
        if (!isJDK14) {
            return;
        }
        try {
            Method method = SSLSocket.class.getMethod("setEnabledProtocols", String[].class);
            method.invoke((Object)socket, new Object[]{enabledProtocols});
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e.getTargetException().toString());
        }
        catch (Exception e) {
            throw new RuntimeException(e.toString());
        }
    }

    public static void setEnabledProtocols(SSLServerSocket socket, String[] enabledProtocols) {
        if (!isJDK14) {
            return;
        }
        try {
            Method method = SSLServerSocket.class.getMethod("setEnabledProtocols", String[].class);
            method.invoke((Object)socket, new Object[]{enabledProtocols});
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e.getTargetException().toString());
        }
        catch (Exception e) {
            throw new RuntimeException(e.toString());
        }
    }

    public static void registerSecurityProvider() {
        if (isJDK14) {
            return;
        }
        try {
            Class<?> clazz = Class.forName("com.sun.net.ssl.internal.ssl.Provider");
            Security.addProvider((Provider)clazz.newInstance());
        }
        catch (Exception e) {
            throw new RuntimeException(e.toString());
        }
    }

    public static boolean isJDK14() {
        return isJDK14;
    }

    public static boolean wantClientAuth(boolean request_mutual_auth, boolean require_mutual_auth) {
        if (isJDK14) {
            return request_mutual_auth;
        }
        return request_mutual_auth && !require_mutual_auth;
    }

    public static void setWantClientAuth(SSLServerSocket s, boolean request_mutual_auth) {
        if (!isJDK14) {
            throw new RuntimeException("Request mutual authentication not supported with JSSE 1.0.x");
        }
        try {
            Method method = SSLServerSocket.class.getMethod("setWantClientAuth", Boolean.TYPE);
            method.invoke((Object)s, request_mutual_auth);
        }
        catch (Exception e) {
            throw new RuntimeException(e.toString());
        }
    }

    static {
        boolean result;
        try {
            SSLSocket.class.getMethod("setEnabledProtocols", String[].class);
            result = true;
        }
        catch (Exception e) {
            result = false;
        }
        isJDK14 = result;
    }
}

