/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.jms;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.Map;
import java.util.SimpleTimeZone;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.configuration.ConfigurationException;
import org.apache.cxf.continuations.ContinuationProvider;
import org.apache.cxf.continuations.SuspendedInvocationException;
import org.apache.cxf.interceptor.OneWayProcessorInterceptor;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.MessageImpl;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.AbstractConduit;
import org.apache.cxf.transport.AbstractMultiplexDestination;
import org.apache.cxf.transport.Conduit;
import org.apache.cxf.transport.Destination;
import org.apache.cxf.transport.MessageObserver;
import org.apache.cxf.transport.jms.JCATransactionalMessageListenerContainer;
import org.apache.cxf.transport.jms.JMSConfiguration;
import org.apache.cxf.transport.jms.JMSExchangeSender;
import org.apache.cxf.transport.jms.JMSFactory;
import org.apache.cxf.transport.jms.JMSMessageHeadersType;
import org.apache.cxf.transport.jms.JMSOutputStream;
import org.apache.cxf.transport.jms.JMSUtils;
import org.apache.cxf.transport.jms.continuations.JMSContinuation;
import org.apache.cxf.transport.jms.continuations.JMSContinuationProvider;
import org.apache.cxf.ws.addressing.EndpointReferenceType;
import org.apache.cxf.wsdl.EndpointReferenceUtils;
import org.springframework.jms.connection.JmsResourceHolder;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.core.MessageCreator;
import org.springframework.jms.core.SessionCallback;
import org.springframework.jms.listener.AbstractMessageListenerContainer;
import org.springframework.jms.listener.SessionAwareMessageListener;
import org.springframework.jms.support.JmsUtils;
import org.springframework.jms.support.destination.DestinationResolver;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class JMSDestination
extends AbstractMultiplexDestination
implements SessionAwareMessageListener<Message>,
MessageListener,
JMSExchangeSender {
    private static final Logger LOG = LogUtils.getL7dLogger(JMSDestination.class);
    private JMSConfiguration jmsConfig;
    private Bus bus;
    private EndpointInfo ei;
    private AbstractMessageListenerContainer jmsListener;
    private Collection<JMSContinuation> continuations = new ConcurrentLinkedQueue<JMSContinuation>();
    private ClassLoader loader;

    public JMSDestination(Bus b, EndpointInfo info, JMSConfiguration jmsConfig) {
        super(b, JMSDestination.getTargetReference((EndpointInfo)info, (Bus)b), info);
        this.bus = b;
        this.ei = info;
        this.jmsConfig = jmsConfig;
        info.setProperty(OneWayProcessorInterceptor.USE_ORIGINAL_THREAD, (Object)Boolean.TRUE);
        this.loader = (ClassLoader)this.bus.getExtension(ClassLoader.class);
    }

    protected Conduit getInbuiltBackChannel(org.apache.cxf.message.Message inMessage) {
        boolean robust = MessageUtils.isTrue((Object)inMessage.getContextualProperty("org.apache.cxf.oneway.robust"));
        if (inMessage.getExchange().isOneWay() && !robust) {
            return null;
        }
        EndpointReferenceType anon = EndpointReferenceUtils.getAnonymousEndpointReference();
        return new BackChannelConduit(this, anon, inMessage);
    }

    public void activate() {
        this.getLogger().log(Level.FINE, "JMSDestination activate().... ");
        String name = this.endpointInfo.getName().toString() + ".jms-destination";
        org.apache.cxf.common.i18n.Message msg = new org.apache.cxf.common.i18n.Message("INSUFFICIENT_CONFIGURATION_DESTINATION", LOG, new Object[]{name});
        this.jmsConfig.ensureProperlyConfigured(msg);
        Object o = this.ei.getProperty(AbstractMessageListenerContainer.class.getName());
        if (o instanceof AbstractMessageListenerContainer && this.jmsConfig.getMessageListenerContainer() == null) {
            this.jmsConfig.setMessageListenerContainer((AbstractMessageListenerContainer)o);
        }
        this.jmsListener = JMSFactory.createJmsListener(this.ei, this.jmsConfig, this, this.jmsConfig.getTargetDestination());
    }

    public void deactivate() {
        if (this.jmsListener != null) {
            this.jmsListener.shutdown();
            this.jmsConfig.destroyWrappedConnectionFactory();
        }
    }

    public void shutdown() {
        this.getLogger().log(Level.FINE, "JMSDestination shutdown()");
        this.deactivate();
    }

    private javax.jms.Destination resolveDestinationName(final JmsTemplate jmsTemplate, final String name) {
        SessionCallback<javax.jms.Destination> sc = new SessionCallback<javax.jms.Destination>(){

            public javax.jms.Destination doInJms(Session session) throws JMSException {
                DestinationResolver resolv = jmsTemplate.getDestinationResolver();
                return resolv.resolveDestinationName(session, name, JMSDestination.this.jmsConfig.isPubSubDomain());
            }
        };
        return (javax.jms.Destination)jmsTemplate.execute((SessionCallback)sc);
    }

    public javax.jms.Destination getReplyToDestination(JmsTemplate jmsTemplate, org.apache.cxf.message.Message inMessage) throws JMSException {
        Message message = (Message)inMessage.get((Object)"org.apache.cxf.jms.request.message");
        String replyToName = (String)inMessage.get((Object)"org.apache.cxf.jms.server.replyto");
        if (replyToName != null) {
            return this.resolveDestinationName(jmsTemplate, replyToName);
        }
        if (message.getJMSReplyTo() != null) {
            return message.getJMSReplyTo();
        }
        if (!StringUtils.isEmpty((String)this.jmsConfig.getReplyDestination())) {
            return this.resolveDestinationName(jmsTemplate, this.jmsConfig.getReplyDestination());
        }
        throw new RuntimeException("No replyTo destination set on request message or cxf message");
    }

    public String determineCorrelationID(Message request) throws JMSException {
        String correlationID = request.getJMSCorrelationID();
        if (correlationID == null || "".equals(correlationID)) {
            correlationID = request.getJMSMessageID();
        }
        return correlationID;
    }

    public void onMessage(Message message) {
        this.onMessage(message, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void onMessage(Message message, Session session) {
        block19: {
            ClassLoaderUtils.ClassLoaderHolder origLoader;
            block18: {
                origLoader = null;
                Bus origBus = null;
                try {
                    PlatformTransactionManager m;
                    if (this.loader != null) {
                        origLoader = ClassLoaderUtils.setThreadContextClassloader((ClassLoader)this.loader);
                    }
                    this.getLogger().log(Level.FINE, "server received request: ", message);
                    MessageImpl inMessage = new MessageImpl();
                    JMSUtils.populateIncomingContext(message, (org.apache.cxf.message.Message)inMessage, "org.apache.cxf.jms.server.request.headers", this.jmsConfig);
                    JMSUtils.retrieveAndSetPayload((org.apache.cxf.message.Message)inMessage, message, (String)inMessage.get((Object)org.apache.cxf.message.Message.ENCODING));
                    inMessage.put((Object)"org.apache.cxf.jms.server.response.headers", (Object)new JMSMessageHeadersType());
                    inMessage.put((Object)"org.apache.cxf.jms.request.message", (Object)message);
                    inMessage.setDestination((Destination)this);
                    if (this.jmsConfig.getMaxSuspendedContinuations() != 0) {
                        inMessage.put((Object)ContinuationProvider.class.getName(), (Object)new JMSContinuationProvider(this.bus, (org.apache.cxf.message.Message)inMessage, this.incomingObserver, this.continuations, this.jmsListener, this.jmsConfig));
                    }
                    origBus = BusFactory.getAndSetThreadDefaultBus((Bus)this.bus);
                    Map<Class<?>, ?> mp = JCATransactionalMessageListenerContainer.ENDPOINT_LOCAL.get();
                    if (mp != null) {
                        for (Map.Entry<Class<?>, ?> ent : mp.entrySet()) {
                            inMessage.setContent(ent.getKey(), ent.getValue());
                        }
                        JCATransactionalMessageListenerContainer.ENDPOINT_LOCAL.remove();
                    }
                    this.incomingObserver.onMessage((org.apache.cxf.message.Message)inMessage);
                    if (inMessage.getExchange() != null && inMessage.getExchange().getInMessage() != null) {
                        inMessage = inMessage.getExchange().getInMessage();
                    }
                    if (inMessage.getContent(Exception.class) != null && session != null && (m = this.jmsConfig.getTransactionManager()) != null) {
                        boolean trans;
                        TransactionStatus status = m.getTransaction(null);
                        JmsResourceHolder resourceHolder = (JmsResourceHolder)TransactionSynchronizationManager.getResource((Object)this.jmsConfig.getConnectionFactory());
                        boolean bl = trans = resourceHolder == null || !resourceHolder.containsSession(session);
                        if (status != null && !status.isCompleted() && trans) {
                            Exception ex = (Exception)inMessage.getContent(Exception.class);
                            if (ex.getCause() instanceof RuntimeException) {
                                throw (RuntimeException)ex.getCause();
                            }
                            throw new RuntimeException(ex);
                        }
                    }
                    if (origBus == this.bus) break block18;
                }
                catch (SuspendedInvocationException ex) {
                    this.getLogger().log(Level.FINE, "Request message has been suspended");
                    break block19;
                }
                catch (UnsupportedEncodingException ex2) {
                    this.getLogger().log(Level.WARNING, "can't get the right encoding information. " + ex2);
                    break block19;
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
                finally {
                    if (origBus != this.bus) {
                        BusFactory.setThreadDefaultBus(origBus);
                    }
                    if (origLoader != null) {
                        origLoader.reset();
                    }
                }
                BusFactory.setThreadDefaultBus((Bus)origBus);
            }
            if (origLoader != null) {
                origLoader.reset();
            }
        }
    }

    @Override
    public void sendExchange(Exchange exchange, final Object replyObj) {
        if (exchange.isOneWay()) {
            return;
        }
        org.apache.cxf.message.Message inMessage = exchange.getInMessage();
        final org.apache.cxf.message.Message outMessage = exchange.getOutMessage();
        try {
            final JMSMessageHeadersType messageProperties = (JMSMessageHeadersType)outMessage.get((Object)"org.apache.cxf.jms.server.response.headers");
            JMSMessageHeadersType inMessageProperties = (JMSMessageHeadersType)inMessage.get((Object)"org.apache.cxf.jms.server.request.headers");
            JMSUtils.initResponseMessageProperties(messageProperties, inMessageProperties);
            JmsTemplate jmsTemplate = JMSFactory.createJmsTemplate(this.jmsConfig, messageProperties);
            final Message request = (Message)inMessage.get((Object)"org.apache.cxf.jms.request.message");
            final String msgType = this.isMtomEnabled(outMessage) && !this.jmsConfig.getMessageType().equals("text") ? this.jmsConfig.getMessageType() : (request instanceof TextMessage ? "text" : (request instanceof BytesMessage ? "byte" : "binary"));
            if ("text".equals(msgType) && this.isMtomEnabled(outMessage)) {
                org.apache.cxf.common.i18n.Message msg = new org.apache.cxf.common.i18n.Message("INVALID_MESSAGE_TYPE", LOG, new Object[0]);
                throw new ConfigurationException(msg);
            }
            javax.jms.Destination replyTo = this.getReplyToDestination(jmsTemplate, inMessage);
            if (request.getJMSExpiration() > 0L) {
                SimpleTimeZone tz = new SimpleTimeZone(0, "GMT");
                GregorianCalendar cal = new GregorianCalendar(tz);
                long timeToLive = request.getJMSExpiration() - cal.getTimeInMillis();
                if (timeToLive < 0L) {
                    this.getLogger().log(Level.INFO, "Message time to live is already expired skipping response.");
                    return;
                }
            }
            this.getLogger().log(Level.FINE, "send out the message!");
            jmsTemplate.send(replyTo, new MessageCreator(){

                public Message createMessage(Session session) throws JMSException {
                    Message reply = JMSUtils.createAndSetPayload(replyObj, session, msgType);
                    reply.setJMSCorrelationID(JMSDestination.this.determineCorrelationID(request));
                    JMSUtils.prepareJMSProperties(messageProperties, outMessage, JMSDestination.this.jmsConfig);
                    JMSUtils.setJMSProperties(reply, messageProperties);
                    LOG.log(Level.FINE, "server sending reply: ", reply);
                    return reply;
                }
            });
        }
        catch (JMSException ex) {
            throw JmsUtils.convertJmsAccessException((JMSException)ex);
        }
    }

    protected Logger getLogger() {
        return LOG;
    }

    public JMSConfiguration getJmsConfig() {
        return this.jmsConfig;
    }

    public void setJmsConfig(JMSConfiguration jmsConfig) {
        this.jmsConfig = jmsConfig;
    }

    private boolean isMtomEnabled(org.apache.cxf.message.Message message) {
        return MessageUtils.isTrue((Object)message.getContextualProperty("mtom-enabled"));
    }

    protected class BackChannelConduit
    extends AbstractConduit {
        protected org.apache.cxf.message.Message inMessage;
        private JMSExchangeSender sender;

        BackChannelConduit(JMSExchangeSender sender, EndpointReferenceType ref, org.apache.cxf.message.Message message) {
            super(ref);
            this.inMessage = message;
            this.sender = sender;
        }

        public void close(org.apache.cxf.message.Message msg) throws IOException {
            Reader reader;
            Writer writer = (Writer)msg.getContent(Writer.class);
            if (writer != null) {
                writer.close();
            }
            if ((reader = (Reader)msg.getContent(Reader.class)) != null) {
                reader.close();
            }
            super.close(msg);
        }

        public void setMessageObserver(MessageObserver observer) {
        }

        public void prepare(final org.apache.cxf.message.Message message) throws IOException {
            Message jmsMessage = (Message)this.inMessage.get((Object)"org.apache.cxf.jms.request.message");
            message.put((Object)"org.apache.cxf.jms.request.message", (Object)jmsMessage);
            if (!message.containsKey((Object)"org.apache.cxf.jms.server.response.headers") && this.inMessage.containsKey((Object)"org.apache.cxf.jms.server.response.headers")) {
                message.put((Object)"org.apache.cxf.jms.server.response.headers", this.inMessage.get((Object)"org.apache.cxf.jms.server.response.headers"));
            }
            Exchange exchange = this.inMessage.getExchange();
            exchange.setOutMessage(message);
            if (jmsMessage instanceof TextMessage && !JMSDestination.this.isMtomEnabled(message)) {
                message.setContent(Writer.class, (Object)new StringWriter(){

                    @Override
                    public void close() throws IOException {
                        super.close();
                        BackChannelConduit.this.sender.sendExchange(message.getExchange(), this.toString());
                    }
                });
            } else {
                message.setContent(OutputStream.class, (Object)new JMSOutputStream(this.sender, exchange, false));
            }
        }

        protected Logger getLogger() {
            return LOG;
        }
    }
}

