/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.managers;

import java.net.URI;
import java.security.PublicKey;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.jboss.logging.Logger;
import org.jboss.resteasy.specimpl.MultivaluedMapImpl;
import org.jboss.resteasy.spi.HttpRequest;
import org.keycloak.ClientConnection;
import org.keycloak.RSATokenVerifier;
import org.keycloak.VerificationException;
import org.keycloak.broker.provider.IdentityProvider;
import org.keycloak.events.EventBuilder;
import org.keycloak.events.EventType;
import org.keycloak.jose.jws.JWSBuilder;
import org.keycloak.login.LoginFormsProvider;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientSessionModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RequiredCredentialModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserConsentModel;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.UserCredentialValueModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.protocol.LoginProtocol;
import org.keycloak.protocol.oidc.TokenManager;
import org.keycloak.representations.AccessToken;
import org.keycloak.services.Urls;
import org.keycloak.services.managers.BruteForceProtector;
import org.keycloak.services.managers.ClientSessionCode;
import org.keycloak.services.resources.IdentityBrokerService;
import org.keycloak.services.resources.LoginActionsService;
import org.keycloak.services.resources.RealmsResource;
import org.keycloak.services.util.CookieHelper;
import org.keycloak.services.validation.Validation;
import org.keycloak.util.Time;

public class AuthenticationManager {
    protected static Logger logger = Logger.getLogger(AuthenticationManager.class);
    public static final String FORM_USERNAME = "username";
    public static final String KEYCLOAK_IDENTITY_COOKIE = "KEYCLOAK_IDENTITY";
    public static final String KEYCLOAK_SESSION_COOKIE = "KEYCLOAK_SESSION";
    public static final String KEYCLOAK_REMEMBER_ME = "KEYCLOAK_REMEMBER_ME";
    public static final String KEYCLOAK_LOGOUT_PROTOCOL = "KEYCLOAK_LOGOUT_PROTOCOL";
    protected BruteForceProtector protector;

    public AuthenticationManager() {
    }

    public AuthenticationManager(BruteForceProtector protector) {
        this.protector = protector;
    }

    public static boolean isSessionValid(RealmModel realm, UserSessionModel userSession) {
        if (userSession == null) {
            logger.debug((Object)"No user session");
            return false;
        }
        int currentTime = Time.currentTime();
        int max = userSession.getStarted() + realm.getSsoSessionMaxLifespan();
        return userSession != null && userSession.getLastSessionRefresh() + realm.getSsoSessionIdleTimeout() > currentTime && max > currentTime;
    }

    public static void expireUserSessionCookie(KeycloakSession session, UserSessionModel userSession, RealmModel realm, UriInfo uriInfo, HttpHeaders headers, ClientConnection connection) {
        try {
            Cookie cookie = (Cookie)headers.getCookies().get(KEYCLOAK_IDENTITY_COOKIE);
            if (cookie == null) {
                return;
            }
            String tokenString = cookie.getValue();
            AccessToken token = RSATokenVerifier.verifyToken((String)tokenString, (PublicKey)realm.getPublicKey(), (String)Urls.realmIssuer(uriInfo.getBaseUri(), realm.getName()), (boolean)false);
            UserSessionModel cookieSession = session.sessions().getUserSession(realm, token.getSessionState());
            if (cookieSession == null || !cookieSession.getId().equals(userSession.getId())) {
                return;
            }
            AuthenticationManager.expireIdentityCookie(realm, uriInfo, connection);
            AuthenticationManager.expireRememberMeCookie(realm, uriInfo, connection);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public static void backchannelLogout(KeycloakSession session, RealmModel realm, UserSessionModel userSession, UriInfo uriInfo, ClientConnection connection, HttpHeaders headers, boolean logoutBroker) {
        String brokerId;
        if (userSession == null) {
            return;
        }
        UserModel user = userSession.getUser();
        userSession.setState(UserSessionModel.State.LOGGING_OUT);
        logger.debugv("Logging out: {0} ({1})", (Object)user.getUsername(), (Object)userSession.getId());
        AuthenticationManager.expireUserSessionCookie(session, userSession, realm, uriInfo, headers, connection);
        for (ClientSessionModel clientSession : userSession.getClientSessions()) {
            AuthenticationManager.backchannelLogoutClientSession(session, realm, clientSession, userSession, uriInfo, headers);
        }
        if (logoutBroker && (brokerId = userSession.getNote("BROKER_PROVIDER_ID")) != null) {
            IdentityProvider identityProvider = IdentityBrokerService.getIdentityProvider(session, realm, brokerId);
            try {
                identityProvider.backchannelLogout(userSession, uriInfo, realm);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        userSession.setState(UserSessionModel.State.LOGGED_OUT);
        session.sessions().removeUserSession(realm, userSession);
    }

    public static void backchannelLogoutClientSession(KeycloakSession session, RealmModel realm, ClientSessionModel clientSession, UserSessionModel userSession, UriInfo uriInfo, HttpHeaders headers) {
        ClientModel client = clientSession.getClient();
        if (client instanceof ClientModel && !client.isFrontchannelLogout() && clientSession.getAction() != ClientSessionModel.Action.LOGGED_OUT) {
            String authMethod = clientSession.getAuthMethod();
            if (authMethod == null) {
                return;
            }
            LoginProtocol protocol = (LoginProtocol)session.getProvider(LoginProtocol.class, authMethod);
            protocol.setRealm(realm).setHttpHeaders(headers).setUriInfo(uriInfo);
            protocol.backchannelLogout(userSession, clientSession);
            clientSession.setAction(ClientSessionModel.Action.LOGGED_OUT);
        }
    }

    public static void backchannelUserFromClient(KeycloakSession session, RealmModel realm, UserModel user, ClientModel client, UriInfo uriInfo, HttpHeaders headers) {
        String clientId = client.getId();
        List userSessions = session.sessions().getUserSessions(realm, user);
        for (UserSessionModel userSession : userSessions) {
            List clientSessions = userSession.getClientSessions();
            for (ClientSessionModel clientSession : clientSessions) {
                if (!clientSession.getClient().getId().equals(clientId)) continue;
                AuthenticationManager.backchannelLogoutClientSession(session, realm, clientSession, userSession, uriInfo, headers);
                TokenManager.dettachClientSession(session.sessions(), realm, clientSession);
            }
        }
    }

    public static Response browserLogout(KeycloakSession session, RealmModel realm, UserSessionModel userSession, UriInfo uriInfo, ClientConnection connection, HttpHeaders headers) {
        IdentityProvider identityProvider;
        Response response;
        if (userSession == null) {
            return null;
        }
        UserModel user = userSession.getUser();
        logger.debugv("Logging out: {0} ({1})", (Object)user.getUsername(), (Object)userSession.getId());
        if (userSession.getState() != UserSessionModel.State.LOGGING_OUT) {
            userSession.setState(UserSessionModel.State.LOGGING_OUT);
        }
        LinkedList<ClientSessionModel> redirectClients = new LinkedList<ClientSessionModel>();
        for (ClientSessionModel clientSession : userSession.getClientSessions()) {
            String authMethod;
            ClientModel client = clientSession.getClient();
            if (clientSession.getAction() == ClientSessionModel.Action.LOGGED_OUT) continue;
            if (client.isFrontchannelLogout()) {
                authMethod = clientSession.getAuthMethod();
                if (authMethod == null) continue;
                redirectClients.add(clientSession);
                continue;
            }
            if (!(client instanceof ClientModel) || client.isFrontchannelLogout() || (authMethod = clientSession.getAuthMethod()) == null) continue;
            LoginProtocol protocol = (LoginProtocol)session.getProvider(LoginProtocol.class, authMethod);
            protocol.setRealm(realm).setHttpHeaders(headers).setUriInfo(uriInfo);
            try {
                logger.debugv("backchannel logout to: {0}", (Object)client.getClientId());
                protocol.backchannelLogout(userSession, clientSession);
                clientSession.setAction(ClientSessionModel.Action.LOGGED_OUT);
            }
            catch (Exception e) {
                logger.warn((Object)"Failed to logout client, continuing", (Throwable)e);
            }
        }
        for (ClientSessionModel nextRedirectClient : redirectClients) {
            String authMethod = nextRedirectClient.getAuthMethod();
            LoginProtocol protocol = (LoginProtocol)session.getProvider(LoginProtocol.class, authMethod);
            protocol.setRealm(realm).setHttpHeaders(headers).setUriInfo(uriInfo);
            nextRedirectClient.setAction(ClientSessionModel.Action.LOGGED_OUT);
            try {
                logger.debugv("frontchannel logout to: {0}", (Object)nextRedirectClient.getClient().getClientId());
                Response response2 = protocol.frontchannelLogout(userSession, nextRedirectClient);
                if (response2 == null) continue;
                logger.debug((Object)"returning frontchannel logout request to client");
                return response2;
            }
            catch (Exception e) {
                logger.warn((Object)"Failed to logout client, continuing", (Throwable)e);
            }
        }
        String brokerId = userSession.getNote("BROKER_PROVIDER_ID");
        if (brokerId != null && (response = (identityProvider = IdentityBrokerService.getIdentityProvider(session, realm, brokerId)).keycloakInitiatedBrowserLogout(userSession, uriInfo, realm)) != null) {
            return response;
        }
        return AuthenticationManager.finishBrowserLogout(session, realm, userSession, uriInfo, connection, headers);
    }

    public static Response finishBrowserLogout(KeycloakSession session, RealmModel realm, UserSessionModel userSession, UriInfo uriInfo, ClientConnection connection, HttpHeaders headers) {
        AuthenticationManager.expireIdentityCookie(realm, uriInfo, connection);
        AuthenticationManager.expireRememberMeCookie(realm, uriInfo, connection);
        userSession.setState(UserSessionModel.State.LOGGED_OUT);
        String method = userSession.getNote(KEYCLOAK_LOGOUT_PROTOCOL);
        EventBuilder event = new EventBuilder(realm, session, connection);
        LoginProtocol protocol = (LoginProtocol)session.getProvider(LoginProtocol.class, method);
        protocol.setRealm(realm).setHttpHeaders(headers).setUriInfo(uriInfo).setEventBuilder(event);
        Response response = protocol.finishLogout(userSession);
        session.sessions().removeUserSession(realm, userSession);
        return response;
    }

    public static AccessToken createIdentityToken(RealmModel realm, UserModel user, UserSessionModel session, String issuer) {
        AccessToken token = new AccessToken();
        token.id(KeycloakModelUtils.generateId());
        token.issuedNow();
        token.subject(user.getId());
        token.issuer(issuer);
        if (session != null) {
            token.setSessionState(session.getId());
        }
        if (realm.getSsoSessionMaxLifespan() > 0) {
            token.expiration(Time.currentTime() + realm.getSsoSessionMaxLifespan());
        }
        return token;
    }

    public static void createLoginCookie(RealmModel realm, UserModel user, UserSessionModel session, UriInfo uriInfo, ClientConnection connection) {
        String cookiePath = AuthenticationManager.getIdentityCookiePath(realm, uriInfo);
        String issuer = Urls.realmIssuer(uriInfo.getBaseUri(), realm.getName());
        AccessToken identityToken = AuthenticationManager.createIdentityToken(realm, user, session, issuer);
        String encoded = AuthenticationManager.encodeToken(realm, identityToken);
        boolean secureOnly = realm.getSslRequired().isRequired(connection);
        int maxAge = -1;
        if (session.isRememberMe()) {
            maxAge = realm.getSsoSessionMaxLifespan();
        }
        logger.debugv("Create login cookie - name: {0}, path: {1}, max-age: {2}", (Object)KEYCLOAK_IDENTITY_COOKIE, (Object)cookiePath, (Object)maxAge);
        CookieHelper.addCookie(KEYCLOAK_IDENTITY_COOKIE, encoded, cookiePath, null, null, maxAge, secureOnly, true);
        String sessionCookieValue = realm.getName() + "/" + user.getId();
        if (session != null) {
            sessionCookieValue = sessionCookieValue + "/" + session.getId();
        }
        CookieHelper.addCookie(KEYCLOAK_SESSION_COOKIE, sessionCookieValue, cookiePath, null, null, realm.getSsoSessionMaxLifespan(), secureOnly, false);
    }

    public static void createRememberMeCookie(RealmModel realm, String username, UriInfo uriInfo, ClientConnection connection) {
        String path = AuthenticationManager.getIdentityCookiePath(realm, uriInfo);
        boolean secureOnly = realm.getSslRequired().isRequired(connection);
        CookieHelper.addCookie(KEYCLOAK_REMEMBER_ME, "username:" + username, path, null, null, 31536000, secureOnly, true);
    }

    public static String getRememberMeUsername(RealmModel realm, HttpHeaders headers) {
        String value;
        String[] s;
        Cookie cookie;
        if (realm.isRememberMe() && (cookie = (Cookie)headers.getCookies().get(KEYCLOAK_REMEMBER_ME)) != null && (s = (value = cookie.getValue()).split(":"))[0].equals(FORM_USERNAME) && s.length == 2) {
            return s[1];
        }
        return null;
    }

    protected static String encodeToken(RealmModel realm, Object token) {
        String encodedToken = new JWSBuilder().jsonContent(token).rsa256(realm.getPrivateKey());
        return encodedToken;
    }

    public static void expireIdentityCookie(RealmModel realm, UriInfo uriInfo, ClientConnection connection) {
        logger.debug((Object)"Expiring identity cookie");
        String path = AuthenticationManager.getIdentityCookiePath(realm, uriInfo);
        AuthenticationManager.expireCookie(realm, KEYCLOAK_IDENTITY_COOKIE, path, true, connection);
        AuthenticationManager.expireCookie(realm, KEYCLOAK_SESSION_COOKIE, path, false, connection);
    }

    public static void expireRememberMeCookie(RealmModel realm, UriInfo uriInfo, ClientConnection connection) {
        logger.debug((Object)"Expiring remember me cookie");
        String path = AuthenticationManager.getIdentityCookiePath(realm, uriInfo);
        String cookieName = KEYCLOAK_REMEMBER_ME;
        AuthenticationManager.expireCookie(realm, cookieName, path, true, connection);
    }

    protected static String getIdentityCookiePath(RealmModel realm, UriInfo uriInfo) {
        return AuthenticationManager.getRealmCookiePath(realm, uriInfo);
    }

    public static String getRealmCookiePath(RealmModel realm, UriInfo uriInfo) {
        URI uri = RealmsResource.realmBaseUrl(uriInfo).build(new Object[]{realm.getName()});
        return uri.getRawPath();
    }

    public static void expireCookie(RealmModel realm, String cookieName, String path, boolean httpOnly, ClientConnection connection) {
        logger.debugv("Expiring cookie: {0} path: {1}", (Object)cookieName, (Object)path);
        boolean secureOnly = realm.getSslRequired().isRequired(connection);
        CookieHelper.addCookie(cookieName, "", path, null, "Expiring cookie", 0, secureOnly, httpOnly);
    }

    public AuthResult authenticateIdentityCookie(KeycloakSession session, RealmModel realm, UriInfo uriInfo, ClientConnection connection, HttpHeaders headers) {
        return AuthenticationManager.authenticateIdentityCookie(session, realm, uriInfo, connection, headers, true);
    }

    public static AuthResult authenticateIdentityCookie(KeycloakSession session, RealmModel realm, UriInfo uriInfo, ClientConnection connection, HttpHeaders headers, boolean checkActive) {
        Cookie cookie = (Cookie)headers.getCookies().get(KEYCLOAK_IDENTITY_COOKIE);
        if (cookie == null || "".equals(cookie.getValue())) {
            logger.debugv("Could not find cookie: {0}", (Object)KEYCLOAK_IDENTITY_COOKIE);
            return null;
        }
        String tokenString = cookie.getValue();
        AuthResult authResult = AuthenticationManager.verifyIdentityToken(session, realm, uriInfo, connection, checkActive, tokenString, headers);
        if (authResult == null) {
            AuthenticationManager.expireIdentityCookie(realm, uriInfo, connection);
            return null;
        }
        authResult.getSession().setLastSessionRefresh(Time.currentTime());
        return authResult;
    }

    public Response checkNonFormAuthentication(KeycloakSession session, ClientSessionModel clientSession, RealmModel realm, UriInfo uriInfo, HttpRequest request, ClientConnection clientConnection, HttpHeaders headers, EventBuilder event) {
        AuthResult authResult = AuthenticationManager.authenticateIdentityCookie(session, realm, uriInfo, clientConnection, headers, true);
        if (authResult != null) {
            UserModel user = authResult.getUser();
            UserSessionModel userSession = authResult.getSession();
            TokenManager.attachClientSession(userSession, clientSession);
            event.user(user).session(userSession).detail("auth_method", "sso");
            return AuthenticationManager.nextActionAfterAuthentication(session, userSession, clientSession, clientConnection, request, uriInfo, event);
        }
        return null;
    }

    public static Response redirectAfterSuccessfulFlow(KeycloakSession session, RealmModel realm, UserSessionModel userSession, ClientSessionModel clientSession, HttpRequest request, UriInfo uriInfo, ClientConnection clientConnection) {
        UserSessionModel oldSession;
        String oldSessionId;
        String[] split;
        Cookie sessionCookie = (Cookie)request.getHttpHeaders().getCookies().get(KEYCLOAK_SESSION_COOKIE);
        if (sessionCookie != null && (split = sessionCookie.getValue().split("/")).length >= 3 && !(oldSessionId = split[2]).equals(userSession.getId()) && (oldSession = session.sessions().getUserSession(realm, oldSessionId)) != null) {
            logger.debugv("Removing old user session: session: {0}", (Object)oldSessionId);
            session.sessions().removeUserSession(realm, oldSession);
        }
        AuthenticationManager.createLoginCookie(realm, userSession.getUser(), userSession, uriInfo, clientConnection);
        if (userSession.isRememberMe()) {
            AuthenticationManager.createRememberMeCookie(realm, userSession.getUser().getUsername(), uriInfo, clientConnection);
        }
        LoginProtocol protocol = (LoginProtocol)session.getProvider(LoginProtocol.class, clientSession.getAuthMethod());
        protocol.setRealm(realm).setHttpHeaders(request.getHttpHeaders()).setUriInfo(uriInfo);
        return protocol.authenticated(userSession, new ClientSessionCode(realm, clientSession));
    }

    public static Response nextActionAfterAuthentication(KeycloakSession session, UserSessionModel userSession, ClientSessionModel clientSession, ClientConnection clientConnection, HttpRequest request, UriInfo uriInfo, EventBuilder event) {
        RealmModel realm = clientSession.getRealm();
        UserModel user = userSession.getUser();
        AuthenticationManager.isForcePasswordUpdateRequired(realm, user);
        AuthenticationManager.isTotpConfigurationRequired(realm, user);
        AuthenticationManager.isEmailVerificationRequired(realm, user);
        ClientModel client = clientSession.getClient();
        ClientSessionCode accessCode = new ClientSessionCode(realm, clientSession);
        logger.debugv("processAccessCode: go to oauth page?: {0}", (Object)client.isConsentRequired());
        event.detail("code_id", clientSession.getId());
        Set requiredActions = user.getRequiredActions();
        if (!requiredActions.isEmpty()) {
            Iterator i = user.getRequiredActions().iterator();
            Object action = (UserModel.RequiredAction)i.next();
            if (action.equals((Object)UserModel.RequiredAction.VERIFY_EMAIL) && Validation.isEmpty(user.getEmail())) {
                action = i.hasNext() ? (UserModel.RequiredAction)i.next() : null;
            }
            if (action != null) {
                accessCode.setRequiredAction((UserModel.RequiredAction)action);
                LoginFormsProvider loginFormsProvider = ((LoginFormsProvider)session.getProvider(LoginFormsProvider.class)).setClientSessionCode(accessCode.getCode()).setUser(user);
                if (action.equals((Object)UserModel.RequiredAction.VERIFY_EMAIL)) {
                    event.clone().event(EventType.SEND_VERIFY_EMAIL).detail("email", user.getEmail()).success();
                    LoginActionsService.createActionCookie(realm, uriInfo, clientConnection, userSession.getId());
                }
                return loginFormsProvider.createResponse(action);
            }
        }
        if (client.isConsentRequired()) {
            accessCode.setAction(ClientSessionModel.Action.OAUTH_GRANT);
            UserConsentModel grantedConsent = user.getConsentByClient(client.getId());
            LinkedList<RoleModel> realmRoles = new LinkedList<RoleModel>();
            MultivaluedMapImpl resourceRoles = new MultivaluedMapImpl();
            for (RoleModel r : accessCode.getRequestedRoles()) {
                if (grantedConsent != null && grantedConsent.isRoleGranted(r)) continue;
                if (r.getContainer() instanceof RealmModel) {
                    realmRoles.add(r);
                    continue;
                }
                resourceRoles.add((Object)((ClientModel)r.getContainer()).getClientId(), (Object)r);
            }
            LinkedList<ProtocolMapperModel> protocolMappers = new LinkedList<ProtocolMapperModel>();
            for (ProtocolMapperModel protocolMapper : accessCode.getRequestedProtocolMappers()) {
                if (!protocolMapper.isConsentRequired() || protocolMapper.getConsentText() == null || grantedConsent != null && grantedConsent.isProtocolMapperGranted(protocolMapper)) continue;
                protocolMappers.add(protocolMapper);
            }
            if (realmRoles.size() > 0 || resourceRoles.size() > 0 || protocolMappers.size() > 0) {
                return ((LoginFormsProvider)session.getProvider(LoginFormsProvider.class)).setClientSessionCode(accessCode.getCode()).setAccessRequest(realmRoles, (MultivaluedMap)resourceRoles, protocolMappers).createOAuthGrant(clientSession);
            }
        }
        event.success();
        return AuthenticationManager.redirectAfterSuccessfulFlow(session, realm, userSession, clientSession, request, uriInfo, clientConnection);
    }

    private static void isForcePasswordUpdateRequired(RealmModel realm, UserModel user) {
        int daysToExpirePassword = realm.getPasswordPolicy().getDaysToExpirePassword();
        if (daysToExpirePassword != -1) {
            for (UserCredentialValueModel entity : user.getCredentialsDirectly()) {
                long timeToExpire;
                if (!entity.getType().equals("password")) continue;
                if (entity.getCreatedDate() == null) {
                    user.addRequiredAction(UserModel.RequiredAction.UPDATE_PASSWORD);
                    logger.debug((Object)"User is required to update password");
                    break;
                }
                long timeElapsed = Time.toMillis((int)Time.currentTime()) - entity.getCreatedDate();
                if (timeElapsed <= (timeToExpire = TimeUnit.DAYS.toMillis(daysToExpirePassword))) break;
                user.addRequiredAction(UserModel.RequiredAction.UPDATE_PASSWORD);
                logger.debug((Object)"User is required to update password");
                break;
            }
        }
    }

    protected static void isTotpConfigurationRequired(RealmModel realm, UserModel user) {
        for (RequiredCredentialModel c : realm.getRequiredCredentials()) {
            if (!c.getType().equals("totp") || user.isTotp()) continue;
            user.addRequiredAction(UserModel.RequiredAction.CONFIGURE_TOTP);
            logger.debug((Object)"User is required to configure totp");
        }
    }

    protected static void isEmailVerificationRequired(RealmModel realm, UserModel user) {
        if (realm.isVerifyEmail() && !user.isEmailVerified()) {
            user.addRequiredAction(UserModel.RequiredAction.VERIFY_EMAIL);
            logger.debug((Object)"User is required to verify email");
        }
    }

    protected static AuthResult verifyIdentityToken(KeycloakSession session, RealmModel realm, UriInfo uriInfo, ClientConnection connection, boolean checkActive, String tokenString, HttpHeaders headers) {
        try {
            UserModel user;
            AccessToken token = RSATokenVerifier.verifyToken((String)tokenString, (PublicKey)realm.getPublicKey(), (String)Urls.realmIssuer(uriInfo.getBaseUri(), realm.getName()), (boolean)checkActive);
            if (checkActive) {
                if (!token.isActive() || token.getIssuedAt() < realm.getNotBefore()) {
                    logger.debug((Object)"identity cookie expired");
                    return null;
                }
                logger.debugv("token active - active: {0}, issued-at: {1}, not-before: {2}", (Object)token.isActive(), (Object)token.getIssuedAt(), (Object)realm.getNotBefore());
            }
            if ((user = session.users().getUserById(token.getSubject(), realm)) == null || !user.isEnabled()) {
                logger.debug((Object)"Unknown user in identity token");
                return null;
            }
            UserSessionModel userSession = session.sessions().getUserSession(realm, token.getSessionState());
            if (!AuthenticationManager.isSessionValid(realm, userSession)) {
                if (userSession != null) {
                    AuthenticationManager.backchannelLogout(session, realm, userSession, uriInfo, connection, headers, true);
                }
                logger.debug((Object)"User session not active");
                return null;
            }
            return new AuthResult(user, userSession, token);
        }
        catch (VerificationException e) {
            logger.debug((Object)"Failed to verify identity token", (Throwable)e);
            return null;
        }
    }

    public AuthenticationStatus authenticateForm(KeycloakSession session, ClientConnection clientConnection, RealmModel realm, MultivaluedMap<String, String> formData) {
        String username = (String)formData.getFirst((Object)FORM_USERNAME);
        if (username == null) {
            logger.debug((Object)"Username not provided");
            return AuthenticationStatus.INVALID_USER;
        }
        if (realm.isBruteForceProtected() && this.protector.isTemporarilyDisabled(session, realm, username)) {
            return AuthenticationStatus.ACCOUNT_TEMPORARILY_DISABLED;
        }
        AuthenticationStatus status = this.authenticateInternal(session, realm, formData, username);
        if (realm.isBruteForceProtected()) {
            switch (status) {
                case SUCCESS: {
                    this.protector.successfulLogin(realm, username, clientConnection);
                    break;
                }
                case FAILED: 
                case MISSING_TOTP: 
                case MISSING_PASSWORD: 
                case INVALID_CREDENTIALS: {
                    this.protector.failedLogin(realm, username, clientConnection);
                    break;
                }
                case INVALID_USER: {
                    this.protector.invalidUser(realm, username, clientConnection);
                    break;
                }
            }
        }
        return status;
    }

    protected AuthenticationStatus authenticateInternal(KeycloakSession session, RealmModel realm, MultivaluedMap<String, String> formData, String username) {
        UserModel user = KeycloakModelUtils.findUserByNameOrEmail((KeycloakSession)session, (RealmModel)realm, (String)username);
        if (user == null) {
            logger.debugv("User {0} not found", (Object)username);
            return AuthenticationStatus.INVALID_USER;
        }
        HashSet<String> types = new HashSet<String>();
        for (RequiredCredentialModel credential : realm.getRequiredCredentials()) {
            types.add(credential.getType());
        }
        if (types.contains("password")) {
            String totp;
            String passwordToken;
            LinkedList<UserCredentialModel> credentials = new LinkedList<UserCredentialModel>();
            String password = (String)formData.getFirst((Object)"password");
            if (password != null) {
                credentials.add(UserCredentialModel.password((String)password));
            }
            if ((passwordToken = (String)formData.getFirst((Object)"password-token")) != null) {
                credentials.add(UserCredentialModel.passwordToken((String)passwordToken));
            }
            if ((totp = (String)formData.getFirst((Object)"totp")) != null) {
                credentials.add(UserCredentialModel.totp((String)totp));
            }
            if ((password == null || password.isEmpty()) && (passwordToken == null || passwordToken.isEmpty())) {
                logger.debug((Object)"Password not provided");
                return AuthenticationStatus.MISSING_PASSWORD;
            }
            logger.debugv("validating password for user: {0}", (Object)username);
            if (!session.users().validCredentials(realm, user, credentials)) {
                return AuthenticationStatus.INVALID_CREDENTIALS;
            }
            if (!user.isEnabled()) {
                return AuthenticationStatus.ACCOUNT_DISABLED;
            }
            if (user.isTotp() && totp == null) {
                return AuthenticationStatus.MISSING_TOTP;
            }
            if (!user.getRequiredActions().isEmpty()) {
                return AuthenticationStatus.ACTIONS_REQUIRED;
            }
            return AuthenticationStatus.SUCCESS;
        }
        if (types.contains("secret")) {
            String secret = (String)formData.getFirst((Object)"secret");
            if (secret == null) {
                logger.debug((Object)"Secret not provided");
                return AuthenticationStatus.MISSING_PASSWORD;
            }
            if (!session.users().validCredentials(realm, user, new UserCredentialModel[]{UserCredentialModel.secret((String)secret)})) {
                return AuthenticationStatus.INVALID_CREDENTIALS;
            }
            if (!user.isEnabled()) {
                return AuthenticationStatus.ACCOUNT_DISABLED;
            }
            if (!user.getRequiredActions().isEmpty()) {
                return AuthenticationStatus.ACTIONS_REQUIRED;
            }
            return AuthenticationStatus.SUCCESS;
        }
        logger.warn((Object)"Do not know how to authenticate user");
        return AuthenticationStatus.FAILED;
    }

    public static class AuthResult {
        private final UserModel user;
        private final UserSessionModel session;
        private final AccessToken token;

        public AuthResult(UserModel user, UserSessionModel session, AccessToken token) {
            this.user = user;
            this.session = session;
            this.token = token;
        }

        public UserSessionModel getSession() {
            return this.session;
        }

        public UserModel getUser() {
            return this.user;
        }

        public AccessToken getToken() {
            return this.token;
        }
    }

    public static enum AuthenticationStatus {
        SUCCESS,
        ACCOUNT_TEMPORARILY_DISABLED,
        ACCOUNT_DISABLED,
        ACTIONS_REQUIRED,
        INVALID_USER,
        INVALID_CREDENTIALS,
        MISSING_PASSWORD,
        MISSING_TOTP,
        FAILED;

    }
}

